/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.sail;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.NotifyingSail;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailChangedEvent;
import org.eclipse.rdf4j.sail.SailChangedListener;
import org.eclipse.rdf4j.sail.SailConnectionListener;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.testsuite.sail.RDFStoreTest;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class RDFNotifyingStoreTest
extends RDFStoreTest
implements SailChangedListener {
    private int removeEventCount;
    private int addEventCount;
    private SailRepository repo;

    protected abstract NotifyingSail createSail() throws SailException;

    @BeforeEach
    public void addSailChangedListener() {
        ((NotifyingSail)this.sail).addSailChangedListener((SailChangedListener)this);
        this.removeEventCount = 0;
        this.addEventCount = 0;
        this.repo = new SailRepository(this.sail);
    }

    @Test
    public void testNotifyingRemoveAndClear() {
        this.con.begin();
        this.con.addStatement((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.guernica, RDF.TYPE, (Value)this.painting, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[]{this.context1});
        this.con.commit();
        this.con.begin();
        this.con.removeStatements((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.commit();
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)this.countAllElements(), (String)"Repository should contain 4 statements in total");
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)this.countContext1Elements(), (String)"Named context should contain 3 statements");
        Assertions.assertThat((boolean)this.con.hasStatement((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, true, new Resource[0])).isFalse();
        this.con.begin();
        this.con.removeStatements(null, null, null, new Resource[]{this.context1});
        this.con.commit();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.countAllElements(), (String)"Repository should contain 1 statement in total");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.countContext1Elements(), (String)"Named context should be empty");
        this.con.begin();
        this.con.clear(new Resource[0]);
        this.con.commit();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.countAllElements(), (String)"Repository should no longer contain any statements");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.addEventCount, (String)"There should have been 1 event in which statements were added");
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)this.removeEventCount, (String)"There should have been 3 events in which statements were removed");
    }

    @Test
    public void testUpdateQuery() {
        try (SailRepositoryConnection connection = this.repo.getConnection();){
            connection.begin();
            connection.add((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
            connection.add((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
            connection.add((Resource)this.picasso, RDF.TYPE, (Value)this.painter, new Resource[0]);
            connection.add((Resource)this.guernica, RDF.TYPE, (Value)this.painting, new Resource[0]);
            connection.add((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[0]);
            connection.commit();
        }
        connection = this.repo.getConnection();
        try {
            HashSet<Statement> added = new HashSet<Statement>();
            HashSet<Statement> removed = new HashSet<Statement>();
            ArrayList<Statement> addedRaw = new ArrayList<Statement>();
            ArrayList<Statement> removedRaw = new ArrayList<Statement>();
            RDFNotifyingStoreTest.registerConnectionListener(connection, added, removed, addedRaw, removedRaw);
            connection.prepareUpdate("DELETE {?a ?b ?c}INSERT {?a ?b ?c}WHERE {?a ?b ?c}").execute();
            org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)added.size());
            org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)removed.size());
            org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)addedRaw.size());
            org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)removedRaw.size());
            org.junit.jupiter.api.Assertions.assertEquals(added, removed);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        org.junit.jupiter.api.Assertions.assertEquals((long)5L, (long)this.con.size(new Resource[0]));
    }

    @Test
    public void testUpdateQuery2() {
        try (SailRepositoryConnection connection = this.repo.getConnection();){
            connection.begin();
            connection.add((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
            connection.add((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
            connection.commit();
        }
        connection = this.repo.getConnection();
        try {
            HashSet<Statement> added = new HashSet<Statement>();
            HashSet<Statement> removed = new HashSet<Statement>();
            ArrayList<Statement> addedRaw = new ArrayList<Statement>();
            ArrayList<Statement> removedRaw = new ArrayList<Statement>();
            RDFNotifyingStoreTest.registerConnectionListener(connection, added, removed, addedRaw, removedRaw);
            String statement = "<" + this.painter + "> <" + RDF.TYPE + "> <" + RDFS.CLASS + "> .";
            connection.prepareUpdate("DELETE {" + statement + "}INSERT {" + statement + "}WHERE {?a ?b ?c}").execute();
            org.junit.jupiter.api.Assertions.assertEquals(added, removed, (String)"Added (expected) is not the same as removed (actual)");
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)addedRaw.size());
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)removedRaw.size());
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)added.size());
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)removed.size());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)this.con.size(new Resource[0]));
    }

    private static void registerConnectionListener(SailRepositoryConnection connection, final Set<Statement> added, final Set<Statement> removed, final List<Statement> addedRaw, final List<Statement> removedRaw) {
        ((NotifyingSailConnection)connection.getSailConnection()).addConnectionListener(new SailConnectionListener(){

            public void statementAdded(Statement st) {
                boolean add = added.add(st);
                if (!add) {
                    removed.remove(st);
                }
                addedRaw.add(st);
            }

            public void statementRemoved(Statement st) {
                boolean add = removed.add(st);
                if (!add) {
                    added.remove(st);
                }
                removedRaw.add(st);
            }
        });
    }

    public void sailChanged(SailChangedEvent event) {
        if (event.statementsAdded()) {
            ++this.addEventCount;
        }
        if (event.statementsRemoved()) {
            ++this.removeEventCount;
        }
    }
}

