/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.sail;

import java.io.File;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.rdf4j.common.transaction.QueryEvaluationMode;
import org.eclipse.rdf4j.common.transaction.TransactionSetting;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.query.QueryResult;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.config.RepositoryConfig;
import org.eclipse.rdf4j.repository.config.RepositoryImplConfig;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.eclipse.rdf4j.repository.manager.RepositoryProvider;
import org.eclipse.rdf4j.repository.sail.config.SailRepositoryConfig;
import org.eclipse.rdf4j.sail.base.config.BaseSailConfig;
import org.eclipse.rdf4j.sail.config.SailImplConfig;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public abstract class EvaluationStrategyTest {
    @TempDir
    private File tempDir;
    private Repository strictRepo;
    private Repository standardRepo;
    private RepositoryManager manager;
    private Literal gYearLit = Values.literal((String)"2009", (IRI)XSD.GYEAR);
    private Literal gYearMonthLit = Values.literal((String)"2009-01", (CoreDatatype)CoreDatatype.XSD.GYEARMONTH);
    private IRI s1 = Values.iri((String)"urn:s1");
    private IRI s2 = Values.iri((String)"urn:s2");

    @BeforeAll
    public static void setUpClass() {
        System.setProperty("org.eclipse.rdf4j.repository.debug", "true");
    }

    @AfterAll
    public static void afterClass() {
        System.setProperty("org.eclipse.rdf4j.repository.debug", "false");
    }

    @BeforeEach
    public void setUp() {
        this.manager = RepositoryProvider.getRepositoryManager((File)this.tempDir);
        BaseSailConfig strictStoreConfig = this.getBaseSailConfig();
        strictStoreConfig.setDefaultQueryEvaluationMode(QueryEvaluationMode.STRICT);
        this.strictRepo = this.createRepo(strictStoreConfig, "test-strict");
        BaseSailConfig standardStoreConfig = this.getBaseSailConfig();
        standardStoreConfig.setDefaultQueryEvaluationMode(QueryEvaluationMode.STANDARD);
        this.standardRepo = this.createRepo(standardStoreConfig, "test-standard");
    }

    private Repository createRepo(BaseSailConfig config, String id) {
        SailRepositoryConfig ric = new SailRepositoryConfig((SailImplConfig)config);
        this.manager.addRepositoryConfig(new RepositoryConfig(id, (RepositoryImplConfig)ric));
        return this.manager.getRepository(id);
    }

    @Test
    public void testDatetimeSubtypesStrict() {
        try (RepositoryConnection conn = this.strictRepo.getConnection();){
            conn.add((Resource)this.s1, RDFS.LABEL, (Value)this.gYearLit, new Resource[0]);
            conn.add((Resource)this.s2, RDFS.LABEL, (Value)this.gYearMonthLit, new Resource[0]);
            String query = "SELECT * WHERE { ?s rdfs:label ?l . FILTER(?l >= \"2008\"^^xsd:gYear) }";
            List result = QueryResults.asList((QueryResult)conn.prepareTupleQuery(query).evaluate());
            Assertions.assertThat((List)result).hasSize(1);
        }
    }

    @Test
    public void testDatetimeSubtypesExtended() {
        try (RepositoryConnection conn = this.standardRepo.getConnection();){
            conn.add((Resource)this.s1, RDFS.LABEL, (Value)this.gYearLit, new Resource[0]);
            conn.add((Resource)this.s2, RDFS.LABEL, (Value)this.gYearMonthLit, new Resource[0]);
            String query = "SELECT * WHERE { ?s rdfs:label ?l . FILTER(?l >= \"2008\"^^xsd:gYear) }";
            List result = QueryResults.asList((QueryResult)conn.prepareTupleQuery(query).evaluate());
            Assertions.assertThat((List)result).hasSize(2);
        }
    }

    @Test
    public void testQueryEvaluationMode_Override() {
        try (RepositoryConnection conn = this.strictRepo.getConnection();){
            conn.add((Resource)this.s1, RDFS.LABEL, (Value)this.gYearLit, new Resource[0]);
            conn.add((Resource)this.s2, RDFS.LABEL, (Value)this.gYearMonthLit, new Resource[0]);
            String query = "SELECT * WHERE { ?s rdfs:label ?l . FILTER(?l >= \"2008\"^^xsd:gYear) }";
            conn.begin(new TransactionSetting[]{QueryEvaluationMode.STANDARD});
            List result = QueryResults.asList((QueryResult)conn.prepareTupleQuery(query).evaluate());
            conn.commit();
            Assertions.assertThat((List)result).hasSize(2);
            result = QueryResults.asList((QueryResult)conn.prepareTupleQuery(query).evaluate());
            Assertions.assertThat((List)result).hasSize(1);
        }
    }

    protected abstract BaseSailConfig getBaseSailConfig();
}

