/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.sail;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.LinkedHashModelFactory;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailConnection;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InferencingTest {
    private static final Logger logger = LoggerFactory.getLogger(InferencingTest.class);
    public static final String TEST_DIR_PREFIX = "/testcases/rdf-mt-inferencing";

    @BeforeAll
    public static void setUpClass() throws Exception {
        System.setProperty("org.eclipse.rdf4j.repository.debug", "true");
    }

    @AfterAll
    public static void afterClass() throws Exception {
        System.setProperty("org.eclipse.rdf4j.repository.debug", "false");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest(String subdir, String testName, boolean isPositiveTest) throws Exception {
        Model expectedStatements;
        InputStream stream;
        String name = subdir + "/" + testName;
        String inputData = "/testcases/rdf-mt-inferencing/" + name + "-in.nt";
        String outputData = "/testcases/rdf-mt-inferencing/" + name + "-out.nt";
        Collection entailedStatements = new HashSet();
        Sail sail = this.createSail();
        try (SailConnection con = sail.getConnection();){
            con.begin();
            con.clear(new Resource[0]);
            con.commit();
            try {
                stream = this.getClass().getResourceAsStream(inputData);
                try {
                    con.begin();
                    Model m = Rio.parse((InputStream)stream, (String)inputData, (RDFFormat)RDFFormat.NTRIPLES, (Resource[])new Resource[0]);
                    for (Statement st : m) {
                        con.addStatement(st.getSubject(), st.getPredicate(), st.getObject(), new Resource[]{st.getContext()});
                    }
                    con.commit();
                    entailedStatements = Iterations.addAll((CloseableIteration)con.getStatements(null, null, null, true, new Resource[0]), new HashSet());
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            catch (Exception e) {
                if (con.isActive()) {
                    con.rollback();
                }
                logger.error("exception while uploading input data", (Throwable)e);
            }
        }
        finally {
            sail.shutDown();
        }
        stream = this.getClass().getResourceAsStream(outputData);
        try {
            expectedStatements = Rio.parse((InputStream)stream, (String)"", (RDFFormat)Rio.getParserFormatForFileName((String)outputData).orElse(RDFFormat.NTRIPLES), (Resource[])new Resource[0]);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        boolean outputEntailed = Models.isSubset((Iterable)expectedStatements, entailedStatements);
        if (isPositiveTest && !outputEntailed) {
            LinkedHashModel diff = new LinkedHashModelFactory().createEmptyModel();
            for (Statement st : entailedStatements) {
                if (expectedStatements.contains((Object)st)) continue;
                diff.add((Object)st);
            }
            File dumpFile = this.dumpStatements(name, (Collection<? extends Statement>)diff);
            Assertions.fail((String)("Incomplete entailment, diff dumped to file " + dumpFile));
        } else if (!isPositiveTest && outputEntailed) {
            File dumpFile = this.dumpStatements(name, (Collection<? extends Statement>)expectedStatements);
            Assertions.fail((String)("Erroneous entailment, unexpected statements dumped to file " + dumpFile));
        }
    }

    private File dumpStatements(String name, Collection<? extends Statement> statements) throws Exception {
        String tmpDir = System.getProperty("java.io.tmpdir");
        name = name.replace("/", "_");
        File tmpFile = new File(tmpDir, "junit-" + name + ".nt");
        tmpFile.createNewFile();
        try (BufferedOutputStream export = new BufferedOutputStream(new FileOutputStream(tmpFile));){
            RDFWriter writer = Rio.createWriter((RDFFormat)RDFFormat.NTRIPLES, (OutputStream)export);
            writer.startRDF();
            for (Statement statement : statements) {
                writer.handleStatement(statement);
            }
            writer.endRDF();
        }
        return tmpFile;
    }

    @Test
    public void testSubClassOf001() throws Exception {
        this.runTest("subclassof", "test001", true);
    }

    @Test
    public void testSubClassOf002() throws Exception {
        this.runTest("subclassof", "test002", true);
    }

    @Test
    public void testSubClassOf003() throws Exception {
        this.runTest("subclassof", "test003", true);
    }

    @Test
    public void testSubClassOfError001() throws Exception {
        this.runTest("subclassof", "error001", false);
    }

    @Test
    public void testSubPropertyOf001() throws Exception {
        this.runTest("subpropertyof", "test001", true);
    }

    @Test
    public void testSubPropertyOf002() throws Exception {
        this.runTest("subpropertyof", "test002", true);
    }

    @Test
    public void testSubPropertyOf003() throws Exception {
        this.runTest("subpropertyof", "test003", true);
    }

    @Test
    public void testSubPropertyOf004() throws Exception {
        this.runTest("subpropertyof", "test004", true);
    }

    @Test
    public void testSubPropertyOfError001() throws Exception {
        this.runTest("subpropertyof", "error001", false);
    }

    @Test
    public void testDomain001() throws Exception {
        this.runTest("domain", "test001", true);
    }

    @Test
    public void testDomainError001() throws Exception {
        this.runTest("domain", "error001", false);
    }

    @Test
    public void testRange001() throws Exception {
        this.runTest("range", "test001", true);
    }

    @Test
    public void testRangeError001() throws Exception {
        this.runTest("range", "error001", false);
    }

    @Test
    public void testType001() throws Exception {
        this.runTest("type", "test001", true);
    }

    @Test
    public void testType002() throws Exception {
        this.runTest("type", "test002", true);
    }

    @Test
    public void testType003() throws Exception {
        this.runTest("type", "test003", true);
    }

    @Test
    public void testType004() throws Exception {
        this.runTest("type", "test004", true);
    }

    @Test
    public void testType005() throws Exception {
        this.runTest("type", "test005", true);
    }

    @Test
    public void testType006() throws Exception {
        this.runTest("type", "test006", true);
    }

    @Test
    public void testTypeError001() throws Exception {
        this.runTest("type", "error001", false);
    }

    @Test
    public void testTypeError002() throws Exception {
        this.runTest("type", "error002", false);
    }

    protected abstract Sail createSail();
}

