/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.sail;

import java.io.File;
import java.util.List;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.query.QueryResult;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.ExtendedEvaluationStrategyFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.StrictEvaluationStrategyFactory;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.config.RepositoryConfig;
import org.eclipse.rdf4j.repository.config.RepositoryImplConfig;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.eclipse.rdf4j.repository.manager.RepositoryProvider;
import org.eclipse.rdf4j.repository.sail.config.SailRepositoryConfig;
import org.eclipse.rdf4j.sail.base.config.BaseSailConfig;
import org.eclipse.rdf4j.sail.config.SailImplConfig;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public abstract class EvaluationStrategyTest {
    @TempDir
    public File tempDir;
    private Repository strictRepo;
    private Repository extendedRepo;
    private RepositoryManager manager;

    @BeforeAll
    public static void setUpClass() throws Exception {
        System.setProperty("org.eclipse.rdf4j.repository.debug", "true");
    }

    @AfterAll
    public static void afterClass() throws Exception {
        System.setProperty("org.eclipse.rdf4j.repository.debug", "false");
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.manager = RepositoryProvider.getRepositoryManager((File)this.tempDir);
        BaseSailConfig strictStoreConfig = this.getBaseSailConfig();
        strictStoreConfig.setEvaluationStrategyFactoryClassName(StrictEvaluationStrategyFactory.class.getName());
        this.strictRepo = this.createRepo(strictStoreConfig, "test-strict");
        BaseSailConfig extendedStoreConfig = this.getBaseSailConfig();
        extendedStoreConfig.setEvaluationStrategyFactoryClassName(ExtendedEvaluationStrategyFactory.class.getName());
        this.extendedRepo = this.createRepo(extendedStoreConfig, "test-extended");
    }

    private Repository createRepo(BaseSailConfig config, String id) {
        SailRepositoryConfig ric = new SailRepositoryConfig((SailImplConfig)config);
        this.manager.addRepositoryConfig(new RepositoryConfig(id, (RepositoryImplConfig)ric));
        return this.manager.getRepository(id);
    }

    @Test
    public void testDatetimeSubtypesStrict() {
        ValueFactory vf = this.strictRepo.getValueFactory();
        try (RepositoryConnection conn = this.strictRepo.getConnection();){
            Literal l1 = vf.createLiteral("2009", XSD.GYEAR);
            Literal l2 = vf.createLiteral("2009-01", (CoreDatatype)CoreDatatype.XSD.GYEARMONTH);
            IRI s1 = vf.createIRI("urn:s1");
            IRI s2 = vf.createIRI("urn:s2");
            conn.add((Resource)s1, RDFS.LABEL, (Value)l1, new Resource[0]);
            conn.add((Resource)s2, RDFS.LABEL, (Value)l2, new Resource[0]);
            String query = "SELECT * WHERE { ?s rdfs:label ?l . FILTER(?l >= \"2008\"^^xsd:gYear) }";
            List result = QueryResults.asList((QueryResult)conn.prepareTupleQuery(query).evaluate());
            Assertions.assertEquals((int)1, (int)result.size());
        }
    }

    @Test
    public void testDatetimeSubtypesExtended() {
        ValueFactory vf = this.extendedRepo.getValueFactory();
        try (RepositoryConnection conn = this.extendedRepo.getConnection();){
            Literal l1 = vf.createLiteral("2009", (CoreDatatype)CoreDatatype.XSD.GYEAR);
            Literal l2 = vf.createLiteral("2009-01", XSD.GYEARMONTH);
            IRI s1 = vf.createIRI("urn:s1");
            IRI s2 = vf.createIRI("urn:s2");
            conn.add((Resource)s1, RDFS.LABEL, (Value)l1, new Resource[0]);
            conn.add((Resource)s2, RDFS.LABEL, (Value)l2, new Resource[0]);
            String query = "SELECT * WHERE { ?s rdfs:label ?l . FILTER(?l >= \"2008\"^^xsd:gYear) }";
            List result = QueryResults.asList((QueryResult)conn.prepareTupleQuery(query).evaluate());
            Assertions.assertEquals((int)2, (int)result.size());
        }
    }

    protected abstract BaseSailConfig getBaseSailConfig();
}

