/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.sail;

import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SailConcurrencyTest {
    private static final Logger logger = LoggerFactory.getLogger(SailConcurrencyTest.class);
    private static final int MAX_STATEMENTS = 150000;
    private static final int MAX_STATEMENT_IDX = 1000;
    private static final long MAX_TEST_TIME = 30000L;
    private Sail store;
    private ValueFactory vf;
    private boolean m_failed;
    private boolean continueRunning;

    @Before
    public void setUp() throws Exception {
        this.store = this.createSail();
        this.store.init();
        this.vf = this.store.getValueFactory();
    }

    protected abstract Sail createSail() throws SailException;

    @After
    public void tearDown() throws Exception {
        this.store.shutDown();
    }

    @Test
    public void testConcurrentAddLargeTxn() throws Exception {
        logger.info("executing two large concurrent transactions");
        CountDownLatch runnersDone = new CountDownLatch(2);
        CountDownLatch otherTxnCommitted = new CountDownLatch(1);
        IRI context1 = this.vf.createIRI("urn:context1");
        IRI context2 = this.vf.createIRI("urn:context2");
        UploadTransaction runner1 = new UploadTransaction(runnersDone, otherTxnCommitted, context1, false);
        UploadTransaction runner2 = new UploadTransaction(runnersDone, otherTxnCommitted, context2, false);
        long start = System.currentTimeMillis();
        new Thread(runner1).start();
        new Thread(runner2).start();
        if (!runnersDone.await(15000L, TimeUnit.MILLISECONDS)) {
            int targetSize = Math.max(runner1.getSize(), runner2.getSize());
            runner1.stopAt(targetSize);
            runner2.stopAt(targetSize);
        }
        while (!runnersDone.await(5L, TimeUnit.MINUTES)) {
            logger.info("Still waiting for transactions to commit");
        }
        long finish = System.currentTimeMillis();
        logger.info("committed both txns in " + (finish - start) / 1000L + "s");
        try (SailConnection conn = this.store.getConnection();){
            long size1 = conn.size(new Resource[]{context1});
            long size2 = conn.size(new Resource[]{context2});
            logger.debug("size 1 = {}, size 2 = {}", (Object)size1, (Object)size2);
            Assert.assertEquals((String)"upload into context 1 should have been fully committed", (long)runner1.getSize(), (long)size1);
            Assert.assertEquals((String)"upload into context 2 should have been fully committed", (long)runner2.getSize(), (long)size2);
        }
    }

    @Test
    public void testConcurrentAddLargeTxnRollback() throws Exception {
        logger.info("executing two large concurrent transactions");
        CountDownLatch runnersDone = new CountDownLatch(2);
        CountDownLatch otherTxnCommitted = new CountDownLatch(1);
        IRI context1 = this.vf.createIRI("urn:context1");
        IRI context2 = this.vf.createIRI("urn:context2");
        UploadTransaction runner1 = new UploadTransaction(runnersDone, otherTxnCommitted, context1, false);
        UploadTransaction runner2 = new UploadTransaction(runnersDone, otherTxnCommitted, context2, true);
        long start = System.currentTimeMillis();
        new Thread(runner1).start();
        new Thread(runner2).start();
        if (!runnersDone.await(15000L, TimeUnit.MILLISECONDS)) {
            int targetSize = Math.max(runner1.getSize(), runner2.getSize());
            runner1.stopAt(targetSize);
            runner2.stopAt(targetSize);
        }
        while (!runnersDone.await(5L, TimeUnit.MINUTES)) {
            logger.info("Still waiting for transaction to rollback");
        }
        long finish = System.currentTimeMillis();
        logger.info("completed both txns in " + (finish - start) / 1000L + "s");
        try (SailConnection conn = this.store.getConnection();){
            long size1 = conn.size(new Resource[]{context1});
            long size2 = conn.size(new Resource[]{context2});
            logger.debug("size 1 = {}, size 2 = {}", (Object)size1, (Object)size2);
            Assert.assertEquals((String)"upload into context 1 should have been fully committed", (long)runner1.getSize(), (long)size1);
            Assert.assertEquals((String)"upload into context 2 should have been rolled back", (long)0L, (long)size2);
        }
    }

    @Test
    @Ignore(value="This test takes a long time and accomplishes little extra")
    public void testGetContextIDs() throws Exception {
        Random insertRandomizer = new Random(12345L);
        Random removeRandomizer = new Random(System.currentTimeMillis());
        Runnable writer = () -> {
            try (SailConnection connection = this.store.getConnection();){
                while (this.continueRunning) {
                    connection.begin();
                    for (int i = 0; i < 10; ++i) {
                        this.insertTestStatement(connection, insertRandomizer.nextInt() % 1000);
                        this.removeTestStatement(connection, removeRandomizer.nextInt() % 1000);
                    }
                    connection.commit();
                }
            }
            catch (Throwable t) {
                this.continueRunning = false;
                this.fail("Writer failed", t);
            }
        };
        Runnable reader = () -> {
            try (SailConnection connection = this.store.getConnection();){
                block12: while (this.continueRunning) {
                    CloseableIteration contextIter = connection.getContextIDs();
                    try {
                        while (true) {
                            if (!contextIter.hasNext()) continue block12;
                            Resource context = (Resource)contextIter.next();
                            Assert.assertNotNull((Object)context);
                        }
                    }
                    finally {
                        if (contextIter == null) continue;
                        contextIter.close();
                    }
                }
                return;
            }
            catch (Throwable t) {
                this.continueRunning = false;
                this.fail("Reader failed", t);
            }
        };
        Thread readerThread1 = new Thread(reader);
        Thread readerThread2 = new Thread(reader);
        Thread writerThread1 = new Thread(writer);
        Thread writerThread2 = new Thread(writer);
        logger.info("Running concurrency test...");
        this.continueRunning = true;
        readerThread1.start();
        readerThread2.start();
        writerThread1.start();
        writerThread2.start();
        readerThread1.join(30000L);
        this.continueRunning = false;
        readerThread1.join(1000L);
        readerThread2.join(1000L);
        writerThread1.join(1000L);
        writerThread2.join(1000L);
        if (this.hasFailed()) {
            Assert.fail((String)"Test Failed");
        } else {
            logger.info("Test succeeded");
        }
    }

    protected synchronized void fail(String message, Throwable t) {
        System.err.println(message);
        t.printStackTrace();
        this.m_failed = true;
    }

    protected synchronized boolean hasFailed() {
        return this.m_failed;
    }

    protected void insertTestStatement(SailConnection connection, int i) throws SailException {
        connection.addStatement((Resource)this.vf.createIRI("http://test#s" + i), this.vf.createIRI("http://test#p" + i), (Value)this.vf.createIRI("http://test#o" + i), new Resource[]{this.vf.createIRI("http://test#context_" + i)});
    }

    protected void removeTestStatement(SailConnection connection, int i) throws SailException {
        connection.removeStatements((Resource)this.vf.createIRI("http://test#s" + i), this.vf.createIRI("http://test#p" + i), (Value)this.vf.createIRI("http://test#o" + i), new Resource[]{this.vf.createIRI("http://test#context_" + i)});
    }

    protected class UploadTransaction
    implements Runnable {
        private final IRI context;
        private int txnSize;
        private final CountDownLatch completed;
        private final CountDownLatch otherTxnCommitted;
        private final AtomicInteger targetSize = new AtomicInteger(150000);
        private final boolean rollback;

        public UploadTransaction(CountDownLatch completed, CountDownLatch otherTxnCommitted, IRI context, boolean rollback) {
            this.completed = completed;
            this.otherTxnCommitted = otherTxnCommitted;
            this.context = context;
            this.rollback = rollback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try (SailConnection conn = SailConcurrencyTest.this.store.getConnection();){
                conn.begin();
                while (this.txnSize < this.targetSize.get()) {
                    IRI subject = SailConcurrencyTest.this.vf.createIRI("urn:instance-" + this.txnSize);
                    conn.addStatement((Resource)subject, RDFS.LABEL, (Value)SailConcurrencyTest.this.vf.createLiteral("li" + this.txnSize), new Resource[]{this.context});
                    conn.addStatement((Resource)subject, RDFS.COMMENT, (Value)SailConcurrencyTest.this.vf.createLiteral("ci" + this.txnSize), new Resource[]{this.context});
                    this.txnSize += 2;
                }
                logger.info("Uploaded " + this.txnSize + " statements");
                if (this.rollback) {
                    this.otherTxnCommitted.await();
                    logger.info("Testing rollback of " + this.txnSize + " statements");
                    conn.rollback();
                } else {
                    conn.commit();
                    this.otherTxnCommitted.countDown();
                }
            }
            catch (Throwable t) {
                logger.error("error while executing transactions", t);
            }
            finally {
                this.completed.countDown();
            }
        }

        public void stopAt(int target) {
            this.targetSize.set(target);
        }

        public int getSize() {
            return this.txnSize;
        }
    }
}

