/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.query.parser.QueryParserUtil;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public abstract class RDFStoreTest {
    @Rule
    public Timeout to = new Timeout(60L, TimeUnit.SECONDS);
    private static final String EXAMPLE_NS = "http://example.org/";
    private static final String PAINTER = "Painter";
    private static final String PAINTS = "paints";
    private static final String PAINTING = "Painting";
    private static final String PICASSO = "picasso";
    private static final String REMBRANDT = "rembrandt";
    private static final String GUERNICA = "guernica";
    private static final String NIGHTWATCH = "nightwatch";
    private static final String CONTEXT_1 = "context1";
    private static final String CONTEXT_2 = "context2";
    protected IRI painter;
    protected IRI paints;
    protected IRI painting;
    protected IRI picasso;
    protected IRI rembrandt;
    protected IRI guernica;
    protected IRI nightwatch;
    protected IRI context1;
    protected IRI context2;
    protected Sail sail;
    protected SailConnection con;
    protected ValueFactory vf;

    @BeforeClass
    public static void setUpClass() throws Exception {
        System.setProperty("org.eclipse.rdf4j.repository.debug", "true");
    }

    protected abstract Sail createSail();

    @Before
    public void setUp() throws Exception {
        this.sail = this.createSail();
        this.con = this.sail.getConnection();
        this.vf = this.sail.getValueFactory();
        this.painter = this.vf.createIRI(EXAMPLE_NS, PAINTER);
        this.paints = this.vf.createIRI(EXAMPLE_NS, PAINTS);
        this.painting = this.vf.createIRI(EXAMPLE_NS, PAINTING);
        this.picasso = this.vf.createIRI(EXAMPLE_NS, PICASSO);
        this.guernica = this.vf.createIRI(EXAMPLE_NS, GUERNICA);
        this.rembrandt = this.vf.createIRI(EXAMPLE_NS, REMBRANDT);
        this.nightwatch = this.vf.createIRI(EXAMPLE_NS, NIGHTWATCH);
        this.context1 = this.vf.createIRI(EXAMPLE_NS, CONTEXT_1);
        this.context2 = this.vf.createIRI(EXAMPLE_NS, CONTEXT_2);
    }

    @After
    public void tearDown() throws Exception {
        block7: {
            try {
                if (!this.con.isOpen()) break block7;
                try {
                    if (this.con.isActive()) {
                        this.con.rollback();
                    }
                }
                finally {
                    this.con.close();
                }
            }
            finally {
                this.sail.shutDown();
                this.sail = null;
            }
        }
    }

    @Test
    public void testEmptyRepository() throws Exception {
        Assert.assertEquals((String)"Empty repository should not return any statements", (long)0L, (long)this.countAllElements());
        Assert.assertEquals((String)"Named context should be empty", (long)0L, (long)this.countContext1Elements());
        Assert.assertEquals((String)"Empty repository should not return any context identifiers", (long)0L, (long)this.countElements((Iteration<?, ?>)this.con.getContextIDs()));
        Assert.assertEquals((String)"Empty repository should not return any query results", (long)0L, (long)this.countQueryResults("select * from {S} P {O}"));
    }

    @Test
    public void testValueRoundTrip1() throws Exception {
        IRI subj = this.vf.createIRI("http://example.org/picasso");
        IRI pred = this.vf.createIRI("http://example.org/paints");
        IRI obj = this.vf.createIRI("http://example.org/guernica");
        this.testValueRoundTrip((Resource)subj, pred, (Value)obj);
    }

    @Test
    public void testValueRoundTrip2() throws Exception {
        BNode subj = this.vf.createBNode();
        IRI pred = this.vf.createIRI("http://example.org/paints");
        IRI obj = this.vf.createIRI("http://example.org/guernica");
        this.testValueRoundTrip((Resource)subj, pred, (Value)obj);
    }

    @Test
    public void testValueRoundTrip3() throws Exception {
        IRI subj = this.vf.createIRI("http://example.org/picasso");
        IRI pred = this.vf.createIRI("http://example.org/paints");
        Literal obj = this.vf.createLiteral(GUERNICA);
        this.testValueRoundTrip((Resource)subj, pred, (Value)obj);
    }

    @Test
    public void testValueRoundTrip4() throws Exception {
        IRI subj = this.vf.createIRI("http://example.org/picasso");
        IRI pred = this.vf.createIRI("http://example.org/paints");
        Literal obj = this.vf.createLiteral(GUERNICA, "es");
        this.testValueRoundTrip((Resource)subj, pred, (Value)obj);
    }

    @Test
    public void testValueRoundTrip5() throws Exception {
        IRI subj = this.vf.createIRI("http://example.org/picasso");
        IRI pred = this.vf.createIRI("http://example.org/paints");
        Literal obj = this.vf.createLiteral(3);
        this.testValueRoundTrip((Resource)subj, pred, (Value)obj);
    }

    @Test
    public void testDecimalRoundTrip() throws Exception {
        IRI subj = this.vf.createIRI("http://example.org/picasso");
        IRI pred = this.vf.createIRI("http://example.org/paints");
        Literal obj = this.vf.createLiteral("3", XSD.DECIMAL);
        this.testValueRoundTrip((Resource)subj, pred, (Value)obj);
    }

    @Test
    public void testTimeZoneRoundTrip() throws Exception {
        IRI subj = this.vf.createIRI("http://example.org/picasso");
        IRI pred = this.vf.createIRI("http://example.org/paints");
        Literal obj = this.vf.createLiteral("2006-08-23+00:00", XSD.DATE);
        this.testValueRoundTrip((Resource)subj, pred, (Value)obj);
        this.con.begin();
        this.con.removeStatements(null, null, null, new Resource[0]);
        this.con.commit();
        obj = this.vf.createLiteral("2006-08-23", XSD.DATE);
        this.testValueRoundTrip((Resource)subj, pred, (Value)obj);
    }

    @Test
    public void testLongURIRoundTrip() throws Exception {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 512; ++i) {
            sb.append(Character.toChars(65 + i % 26));
        }
        IRI subj = this.vf.createIRI("http://example.org/picasso");
        IRI pred = this.vf.createIRI("http://example.org/paints");
        IRI obj = this.vf.createIRI("http://example.org/guernica" + sb.toString());
        this.testValueRoundTrip((Resource)subj, pred, (Value)obj);
    }

    @Test
    public void testLongLiteralRoundTrip() throws Exception {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 512; ++i) {
            sb.append(Character.toChars(65 + i % 26));
        }
        IRI subj = this.vf.createIRI("http://example.org/picasso");
        IRI pred = this.vf.createIRI("http://example.org/paints");
        Literal obj = this.vf.createLiteral(GUERNICA + sb.toString());
        this.testValueRoundTrip((Resource)subj, pred, (Value)obj);
    }

    @Test
    public void testReallyLongLiteralRoundTrip() throws Exception {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 1024000; ++i) {
            sb.append(Character.toChars(65 + i % 26));
        }
        IRI subj = this.vf.createIRI("http://example.org/picasso");
        IRI pred = this.vf.createIRI("http://example.org/paints");
        Literal obj = this.vf.createLiteral(GUERNICA + sb.toString());
        this.testValueRoundTrip((Resource)subj, pred, (Value)obj);
    }

    @Test
    public void testLongLangRoundTrip() throws Exception {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 512; ++i) {
            sb.append(Character.toChars(65 + i % 26));
        }
        IRI subj = this.vf.createIRI("http://example.org/picasso");
        IRI pred = this.vf.createIRI("http://example.org/paints");
        Literal obj = this.vf.createLiteral(GUERNICA + sb.toString(), "es");
        this.testValueRoundTrip((Resource)subj, pred, (Value)obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testValueRoundTrip(Resource subj, IRI pred, Value obj) throws Exception {
        this.con.begin();
        this.con.addStatement(subj, pred, obj, new Resource[0]);
        this.con.commit();
        try (CloseableIteration stIter = this.con.getStatements(null, null, null, false, new Resource[0]);){
            Assert.assertTrue((boolean)stIter.hasNext());
            Statement st = (Statement)stIter.next();
            Assert.assertEquals((Object)subj, (Object)st.getSubject());
            Assert.assertEquals((Object)pred, (Object)st.getPredicate());
            Assert.assertEquals((Object)obj, (Object)st.getObject());
            Assert.assertTrue((!stIter.hasNext() ? 1 : 0) != 0);
        }
        ParsedTupleQuery tupleQuery = QueryParserUtil.parseTupleQuery((QueryLanguage)QueryLanguage.SERQL, (String)("SELECT S, P, O FROM {S} P {O} WHERE P = <" + pred.stringValue() + ">"), null);
        try (CloseableIteration iter = this.con.evaluate(tupleQuery.getTupleExpr(), null, EmptyBindingSet.getInstance(), false);){
            Assert.assertTrue((boolean)iter.hasNext());
            BindingSet bindings = (BindingSet)iter.next();
            Assert.assertEquals((Object)subj, (Object)bindings.getValue("S"));
            Assert.assertEquals((Object)pred, (Object)bindings.getValue("P"));
            Assert.assertEquals((Object)obj, (Object)bindings.getValue("O"));
            Assert.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCreateURI1() throws Exception {
        IRI picasso1 = this.vf.createIRI(EXAMPLE_NS, PICASSO);
        IRI picasso2 = this.vf.createIRI("http://example.org/picasso");
        this.con.begin();
        this.con.addStatement((Resource)picasso1, this.paints, (Value)this.guernica, new Resource[0]);
        this.con.addStatement((Resource)picasso2, this.paints, (Value)this.guernica, new Resource[0]);
        this.con.commit();
        Assert.assertEquals((String)"createURI(Sring) and createURI(String, String) should create equal URIs", (long)1L, (long)this.con.size(new Resource[0]));
    }

    @Test
    public void testCreateURI2() throws Exception {
        IRI picasso1 = this.vf.createIRI("http://example.org/picasso");
        IRI picasso2 = this.vf.createIRI(EXAMPLE_NS, PICASSO);
        this.con.begin();
        this.con.addStatement((Resource)picasso1, this.paints, (Value)this.guernica, new Resource[0]);
        this.con.addStatement((Resource)picasso2, this.paints, (Value)this.guernica, new Resource[0]);
        this.con.commit();
        Assert.assertEquals((String)"createURI(Sring) and createURI(String, String) should create equal URIs", (long)1L, (long)this.con.size(new Resource[0]));
    }

    @Test
    public void testInvalidDateTime() throws Exception {
        Literal date1 = this.vf.createLiteral("2004-12-20", XSD.DATETIME);
        Literal date2 = this.vf.createLiteral("2004-12-20", XSD.DATETIME);
        Assert.assertEquals((Object)date1, (Object)date2);
    }

    @Test
    public void testSize() throws Exception {
        Assert.assertEquals((String)"Size of empty repository should be 0", (long)0L, (long)this.con.size(new Resource[0]));
        this.con.begin();
        this.con.addStatement((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.guernica, RDF.TYPE, (Value)this.painting, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[]{this.context1});
        this.con.commit();
        Assert.assertEquals((String)"Size of repository should be 5", (long)5L, (long)this.con.size(new Resource[0]));
        Assert.assertEquals((String)"Size of named context should be 3", (long)3L, (long)this.con.size(new Resource[]{this.context1}));
        IRI unknownContext = this.vf.createIRI("http://example.org/unknown");
        Assert.assertEquals((String)"Size of unknown context should be 0", (long)0L, (long)this.con.size(new Resource[]{unknownContext}));
        IRI uriImplContext1 = this.vf.createIRI(this.context1.toString());
        Assert.assertEquals((String)"Size of named context (defined as URIImpl) should be 3", (long)3L, (long)this.con.size(new Resource[]{uriImplContext1}));
    }

    @Test
    public void testAddData() throws Exception {
        this.con.begin();
        this.con.addStatement((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.guernica, RDF.TYPE, (Value)this.painting, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[]{this.context1});
        this.con.commit();
        Assert.assertEquals((String)"Repository should contain 5 statements in total", (long)5L, (long)this.countAllElements());
        Assert.assertEquals((String)"Named context should contain 3 statements", (long)3L, (long)this.countContext1Elements());
        Assert.assertEquals((String)"Repository should have 1 context identifier", (long)1L, (long)this.countElements((Iteration<?, ?>)this.con.getContextIDs()));
        Assert.assertEquals((String)"Repository should contain 5 statements in total", (long)5L, (long)this.countQueryResults("select * from {S} P {O}"));
        Assert.assertEquals((String)"Statement (Painter, type, Class) should be in the repository", (long)1L, (long)this.countQueryResults("select 1 from {ex:Painter} rdf:type {rdfs:Class}"));
        Assert.assertEquals((String)"Statement (picasso, type, Painter) should be in the repository", (long)1L, (long)this.countQueryResults("select 1 from {ex:picasso} rdf:type {ex:Painter}"));
        Assert.assertEquals((String)"Statement (Painter, paints, Painting) should not be in the repository", (long)0L, (long)this.countQueryResults("select 1 from {ex:Painter} ex:paints {ex:Painting}"));
        Assert.assertEquals((String)"Statement (picasso, creates, guernica) should not be in the repository", (long)0L, (long)this.countQueryResults("select 1 from {ex:picasso} ex:creates {ex:guernica}"));
        Assert.assertEquals((String)"Repository should contain 2 statements matching (picasso, _, _)", (long)2L, (long)this.countQueryResults("select * from {ex:picasso} P {O}"));
        Assert.assertEquals((String)"Repository should contain 1 statement matching (picasso, paints, _)", (long)1L, (long)this.countQueryResults("select * from {ex:picasso} ex:paints {O}"));
        Assert.assertEquals((String)"Repository should contain 4 statements matching (_, type, _)", (long)4L, (long)this.countQueryResults("select * from {S} rdf:type {O}"));
        Assert.assertEquals((String)"Repository should contain 2 statements matching (_, _, Class)", (long)2L, (long)this.countQueryResults("select * from {S} P {rdfs:Class}"));
        Assert.assertEquals((String)"Repository should contain 0 statements matching (_, _, type)", (long)0L, (long)this.countQueryResults("select * from {S} P {rdf:type}"));
    }

    @Test
    public void testAddWhileQuerying() throws Exception {
        BindingSet bindings;
        this.con.begin();
        this.con.addStatement((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, new Resource[0]);
        this.con.addStatement((Resource)this.guernica, RDF.TYPE, (Value)this.painting, new Resource[0]);
        this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[0]);
        this.con.commit();
        ParsedTupleQuery tupleQuery = QueryParserUtil.parseTupleQuery((QueryLanguage)QueryLanguage.SERQL, (String)"SELECT C FROM {} rdf:type {C}", null);
        CloseableIteration iter = this.con.evaluate(tupleQuery.getTupleExpr(), null, EmptyBindingSet.getInstance(), false);
        this.con.begin();
        while (iter.hasNext()) {
            bindings = (BindingSet)iter.next();
            Value c = bindings.getValue("C");
            if (!(c instanceof Resource)) continue;
            this.con.addStatement((Resource)c, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        }
        this.con.commit();
        Assert.assertEquals((long)3L, (long)this.countElements((Iteration<?, ?>)this.con.getStatements(null, RDF.TYPE, (Value)RDFS.CLASS, false, new Resource[0])));
        tupleQuery = QueryParserUtil.parseTupleQuery((QueryLanguage)QueryLanguage.SERQL, (String)"SELECT P FROM {} P {}", null);
        iter = this.con.evaluate(tupleQuery.getTupleExpr(), null, EmptyBindingSet.getInstance(), false);
        while (iter.hasNext()) {
            bindings = (BindingSet)iter.next();
            Value p = bindings.getValue("P");
            if (!(p instanceof IRI)) continue;
            this.con.begin();
            this.con.addStatement((Resource)((IRI)p), RDF.TYPE, (Value)RDF.PROPERTY, new Resource[0]);
            this.con.commit();
        }
        Assert.assertEquals((long)2L, (long)this.countElements((Iteration<?, ?>)this.con.getStatements(null, RDF.TYPE, (Value)RDF.PROPERTY, false, new Resource[0])));
    }

    @Test
    public void testRemoveAndClear() throws Exception {
        this.con.begin();
        this.con.addStatement((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.guernica, RDF.TYPE, (Value)this.painting, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[]{this.context1});
        this.con.commit();
        this.con.begin();
        this.con.removeStatements((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.commit();
        Assert.assertEquals((String)"Repository should contain 4 statements in total", (long)4L, (long)this.countAllElements());
        Assert.assertEquals((String)"Named context should contain 3 statements", (long)3L, (long)this.countContext1Elements());
        Assert.assertEquals((String)"Statement (Painting, type, Class) should no longer be in the repository", (long)0L, (long)this.countQueryResults("select 1 from {ex:Painting} rdf:type {rdfs:Class}"));
        this.con.begin();
        this.con.removeStatements(null, null, null, new Resource[]{this.context1});
        this.con.commit();
        Assert.assertEquals((String)"Repository should contain 1 statement in total", (long)1L, (long)this.countAllElements());
        Assert.assertEquals((String)"Named context should be empty", (long)0L, (long)this.countContext1Elements());
        this.con.begin();
        this.con.clear(new Resource[0]);
        this.con.commit();
        Assert.assertEquals((String)"Repository should no longer contain any statements", (long)0L, (long)this.countAllElements());
    }

    @Test
    public void testClose() {
        try {
            this.con.close();
            this.con.addStatement((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
            Assert.fail((String)"Operation on connection after close should result in IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (SailException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testContexts() throws Exception {
        this.con.begin();
        this.con.addStatement((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.guernica, RDF.TYPE, (Value)this.painting, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.rembrandt, RDF.TYPE, (Value)this.painter, new Resource[]{this.context2});
        this.con.addStatement((Resource)this.nightwatch, RDF.TYPE, (Value)this.painting, new Resource[]{this.context2});
        this.con.addStatement((Resource)this.rembrandt, this.paints, (Value)this.nightwatch, new Resource[]{this.context2});
        this.con.commit();
        Assert.assertEquals((String)"context1 should contain 3 statements", (long)3L, (long)this.countContext1Elements());
        Assert.assertEquals((String)"context2 should contain 3 statements", (long)3L, (long)this.countElements((Iteration<?, ?>)this.con.getStatements(null, null, null, false, new Resource[]{this.context2})));
        Assert.assertEquals((String)"Repository should contain 8 statements", (long)8L, (long)this.countAllElements());
        Assert.assertEquals((String)"statements without context should equal 2", (long)2L, (long)this.countElements((Iteration<?, ?>)this.con.getStatements(null, null, null, false, new Resource[]{null})));
        Assert.assertEquals((String)"Statements without context and statements in context 1 together should total 5", (long)5L, (long)this.countElements((Iteration<?, ?>)this.con.getStatements(null, null, null, false, new Resource[]{null, this.context1})));
        Assert.assertEquals((String)"Statements without context and statements in context 2 together should total 5", (long)5L, (long)this.countElements((Iteration<?, ?>)this.con.getStatements(null, null, null, false, new Resource[]{null, this.context2})));
        Assert.assertEquals((String)"Statements in context 1 and in context 2 together should total 6", (long)6L, (long)this.countElements((Iteration<?, ?>)this.con.getStatements(null, null, null, false, new Resource[]{this.context1, this.context2})));
        this.con.begin();
        this.con.removeStatements((Resource)this.picasso, null, null, new Resource[]{this.context1});
        this.con.commit();
        Assert.assertEquals((String)"context1 should contain 1 statements", (long)1L, (long)this.countContext1Elements());
        Assert.assertEquals((String)"Repository should contain 6 statements", (long)6L, (long)this.countAllElements());
        Assert.assertEquals((String)"Statements without context and statements in context 1 together should total 3", (long)3L, (long)this.countElements((Iteration<?, ?>)this.con.getStatements(null, null, null, false, new Resource[]{null, this.context1})));
        Assert.assertEquals((String)"Statements without context and statements in context 2 together should total 5", (long)5L, (long)this.countElements((Iteration<?, ?>)this.con.getStatements(null, null, null, false, new Resource[]{this.context2, null})));
        Assert.assertEquals((String)"Statements in context 1 and in context 2 together should total 4", (long)4L, (long)this.countElements((Iteration<?, ?>)this.con.getStatements(null, null, null, false, new Resource[]{this.context1, this.context2})));
    }

    @Test
    public void testQueryBindings() throws Exception {
        this.con.begin();
        this.con.addStatement((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.guernica, RDF.TYPE, (Value)this.painting, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[]{this.context1});
        this.con.commit();
        ParsedTupleQuery tupleQuery = QueryParserUtil.parseTupleQuery((QueryLanguage)QueryLanguage.SERQL, (String)"select X from {X} rdf:type {Y} rdf:type {rdfs:Class}", null);
        TupleExpr tupleExpr = tupleQuery.getTupleExpr();
        MapBindingSet bindings = new MapBindingSet(2);
        CloseableIteration iter = this.con.evaluate(tupleExpr, null, (BindingSet)bindings, false);
        int resultCount = this.verifyQueryResult((CloseableIteration<? extends BindingSet, QueryEvaluationException>)iter, 1);
        Assert.assertEquals((String)"Wrong number of query results", (long)2L, (long)resultCount);
        bindings.addBinding("Y", (Value)this.painter);
        iter = this.con.evaluate(tupleExpr, null, (BindingSet)bindings, false);
        resultCount = this.verifyQueryResult((CloseableIteration<? extends BindingSet, QueryEvaluationException>)iter, 1);
        Assert.assertEquals((String)"Wrong number of query results", (long)1L, (long)resultCount);
        bindings.addBinding("Z", (Value)this.painting);
        iter = this.con.evaluate(tupleExpr, null, (BindingSet)bindings, false);
        resultCount = this.verifyQueryResult((CloseableIteration<? extends BindingSet, QueryEvaluationException>)iter, 1);
        Assert.assertEquals((String)"Wrong number of query results", (long)1L, (long)resultCount);
        bindings.removeBinding("Y");
        iter = this.con.evaluate(tupleExpr, null, (BindingSet)bindings, false);
        resultCount = this.verifyQueryResult((CloseableIteration<? extends BindingSet, QueryEvaluationException>)iter, 1);
        Assert.assertEquals((String)"Wrong number of query results", (long)2L, (long)resultCount);
        tupleQuery = QueryParserUtil.parseTupleQuery((QueryLanguage)QueryLanguage.SERQL, (String)"select X from {X} rdf:type {Y} rdf:type {rdfs:Class} where Y = Z", null);
        tupleExpr = tupleQuery.getTupleExpr();
        bindings.clear();
        iter = this.con.evaluate(tupleExpr, null, (BindingSet)bindings, false);
        resultCount = this.verifyQueryResult((CloseableIteration<? extends BindingSet, QueryEvaluationException>)iter, 1);
        Assert.assertEquals((String)"Wrong number of query results", (long)0L, (long)resultCount);
        bindings.addBinding("Z", (Value)this.painter);
        iter = this.con.evaluate(tupleExpr, null, (BindingSet)bindings, false);
        resultCount = this.verifyQueryResult((CloseableIteration<? extends BindingSet, QueryEvaluationException>)iter, 1);
        Assert.assertEquals((String)"Wrong number of query results", (long)1L, (long)resultCount);
    }

    @Test
    @Ignore(value="test is fundamentelly flawed as it uses multithreaded access on the same connection")
    @Deprecated
    public void testMultiThreadedAccess() {
        Runnable runnable = new Runnable(){
            SailConnection sharedCon;
            {
                this.sharedCon = RDFStoreTest.this.con;
            }

            @Override
            public void run() {
                Assert.assertTrue((this.sharedCon != null ? 1 : 0) != 0);
                try {
                    while (this.sharedCon.isActive()) {
                        Thread.sleep(10L);
                    }
                    this.sharedCon.begin();
                    this.sharedCon.addStatement((Resource)RDFStoreTest.this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
                    this.sharedCon.commit();
                    Thread.sleep(500L);
                    CloseableIteration result = this.sharedCon.getStatements(null, null, null, true, new Resource[0]);
                    Assert.assertTrue((boolean)result.hasNext());
                    int numberOfStatements = 0;
                    while (result.hasNext()) {
                        ++numberOfStatements;
                        Statement st = (Statement)result.next();
                        Assert.assertTrue((st.getSubject().equals(RDFStoreTest.this.painter) || st.getSubject().equals(RDFStoreTest.this.picasso) ? 1 : 0) != 0);
                        Assert.assertTrue((boolean)st.getPredicate().equals((Object)RDF.TYPE));
                        Assert.assertTrue((st.getObject().equals(RDFS.CLASS) || st.getObject().equals(RDFStoreTest.this.painter) ? 1 : 0) != 0);
                    }
                    Assert.assertTrue((String)"we should have retrieved statements from both threads", (numberOfStatements == 2 ? 1 : 0) != 0);
                }
                catch (SailException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
                catch (InterruptedException e) {
                    Assert.fail((String)e.getMessage());
                }
                try {
                    Thread.sleep(1000L);
                    this.sharedCon.getStatements(null, null, null, true, new Resource[0]);
                    Assert.fail((String)"should have caused an IllegalStateException");
                }
                catch (InterruptedException e) {
                    Assert.fail((String)e.getMessage());
                }
                catch (SailException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        };
        Thread newThread = new Thread(runnable, "B (parallel)");
        newThread.start();
        try {
            while (this.con.isActive()) {
                Thread.sleep(10L);
            }
            this.con.begin();
            this.con.addStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, new Resource[0]);
            this.con.commit();
            Thread.sleep(1000L);
            this.con.close();
        }
        catch (SailException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (InterruptedException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testStatementEquals() throws Exception {
        Statement st = this.vf.createStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter);
        Assert.assertEquals((Object)st, (Object)this.vf.createStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter));
        Assert.assertNotEquals((Object)st, (Object)this.vf.createStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, (Resource)this.context1));
        Assert.assertNotEquals((Object)st, (Object)this.vf.createStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, (Resource)this.context2));
    }

    @Test
    public void testStatementSerialization() throws Exception {
        Statement st = this.vf.createStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(st);
        out.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bais);
        Statement deserializedStatement = (Statement)in.readObject();
        in.close();
        Assert.assertTrue((boolean)st.equals((Object)deserializedStatement));
    }

    @Test
    public void testGetNamespaces() throws Exception {
        this.con.begin();
        this.con.setNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.con.commit();
        try (CloseableIteration namespaces = this.con.getNamespaces();){
            Assert.assertTrue((boolean)namespaces.hasNext());
            Namespace rdf = (Namespace)namespaces.next();
            Assert.assertEquals((Object)"rdf", (Object)rdf.getPrefix());
            Assert.assertEquals((Object)"http://www.w3.org/1999/02/22-rdf-syntax-ns#", (Object)rdf.getName());
            Assert.assertTrue((!namespaces.hasNext() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGetNamespace() throws Exception {
        this.con.begin();
        this.con.setNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.con.commit();
        Assert.assertEquals((Object)"http://www.w3.org/1999/02/22-rdf-syntax-ns#", (Object)this.con.getNamespace("rdf"));
    }

    @Test
    public void testClearNamespaces() throws Exception {
        this.con.begin();
        this.con.setNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.con.setNamespace("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        this.con.clearNamespaces();
        this.con.commit();
        Assert.assertTrue((!this.con.getNamespaces().hasNext() ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveNamespaces() throws Exception {
        this.con.begin();
        this.con.setNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.con.removeNamespace("rdf");
        this.con.commit();
        Assert.assertNull((Object)this.con.getNamespace("rdf"));
    }

    @Test
    public void testNullNamespaceDisallowed() throws Exception {
        try {
            this.con.setNamespace("foo", null);
            Assert.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testNullPrefixDisallowed() throws Exception {
        try {
            this.con.setNamespace(null, "foo");
            Assert.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.con.getNamespace(null);
            Assert.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.con.removeNamespace(null);
            Assert.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testGetContextIDs() throws Exception {
        Assert.assertEquals((long)0L, (long)this.countElements((Iteration<?, ?>)this.con.getContextIDs()));
        this.con.begin();
        this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[]{this.context1});
        Assert.assertEquals((long)1L, (long)this.countElements((Iteration<?, ?>)this.con.getContextIDs()));
        Assert.assertEquals((Object)this.context1, this.first((Iteration)this.con.getContextIDs()));
        this.con.removeStatements((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[]{this.context1});
        Assert.assertEquals((long)0L, (long)this.countElements((Iteration<?, ?>)this.con.getContextIDs()));
        this.con.commit();
        Assert.assertEquals((long)0L, (long)this.countElements((Iteration<?, ?>)this.con.getContextIDs()));
        this.con.begin();
        this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[]{this.context2});
        Assert.assertEquals((long)1L, (long)this.countElements((Iteration<?, ?>)this.con.getContextIDs()));
        Assert.assertEquals((Object)this.context2, this.first((Iteration)this.con.getContextIDs()));
        this.con.commit();
    }

    @Test
    public void testOldURI() throws Exception {
        Assert.assertEquals((long)0L, (long)this.countAllElements());
        this.con.begin();
        this.con.addStatement((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.guernica, RDF.TYPE, (Value)this.painting, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[]{this.context1});
        Assert.assertEquals((long)5L, (long)this.countAllElements());
        this.con.commit();
        this.con.begin();
        this.con.clear(new Resource[0]);
        this.con.commit();
        this.con.begin();
        this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[]{this.context1});
        this.con.commit();
        Assert.assertEquals((long)1L, (long)this.countAllElements());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDualConnections() throws Exception {
        try (SailConnection con2 = this.sail.getConnection();){
            Assert.assertEquals((long)0L, (long)this.countAllElements());
            this.con.begin();
            this.con.addStatement((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
            this.con.addStatement((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
            this.con.addStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, new Resource[]{this.context1});
            this.con.addStatement((Resource)this.guernica, RDF.TYPE, (Value)this.painting, new Resource[]{this.context1});
            this.con.commit();
            Assert.assertEquals((long)4L, (long)this.countAllElements());
            con2.begin();
            con2.addStatement((Resource)RDF.NIL, RDF.TYPE, (Value)RDF.LIST, new Resource[0]);
            String query = "SELECT S, P, O FROM {S} P {O}";
            ParsedTupleQuery tupleQuery = QueryParserUtil.parseTupleQuery((QueryLanguage)QueryLanguage.SERQL, (String)query, null);
            Assert.assertEquals((long)5L, (long)this.countElements((Iteration<?, ?>)con2.evaluate(tupleQuery.getTupleExpr(), null, EmptyBindingSet.getInstance(), false)));
            Runnable clearer = () -> {
                try {
                    this.con.begin();
                    this.con.clear(new Resource[0]);
                    this.con.commit();
                }
                catch (SailException e) {
                    throw new RuntimeException(e);
                }
            };
            Thread thread = new Thread(clearer);
            thread.start();
            Thread.yield();
            Thread.yield();
            con2.commit();
            thread.join();
        }
    }

    @Test
    public void testBNodeReuse() throws Exception {
        this.con.begin();
        this.con.addStatement((Resource)RDF.VALUE, RDF.VALUE, (Value)RDF.VALUE, new Resource[0]);
        Assert.assertEquals((long)1L, (long)this.con.size(new Resource[0]));
        BNode b1 = this.vf.createBNode();
        this.con.addStatement((Resource)b1, RDF.VALUE, (Value)b1, new Resource[0]);
        this.con.removeStatements((Resource)b1, RDF.VALUE, (Value)b1, new Resource[0]);
        Assert.assertEquals((long)1L, (long)this.con.size(new Resource[0]));
        BNode b2 = this.vf.createBNode();
        this.con.addStatement((Resource)b2, RDF.VALUE, (Value)b2, new Resource[0]);
        this.con.addStatement((Resource)b1, RDF.VALUE, (Value)b1, new Resource[0]);
        Assert.assertEquals((long)3L, (long)this.con.size(new Resource[0]));
        this.con.commit();
    }

    @Test
    public void testDuplicateCount() {
        this.con.begin();
        this.con.addStatement((Resource)RDF.SUBJECT, RDF.PREDICATE, (Value)RDF.OBJECT, new Resource[0]);
        this.con.commit();
        this.con.begin();
        this.con.addStatement((Resource)RDF.SUBJECT, RDF.PREDICATE, (Value)RDF.OBJECT, new Resource[0]);
        Assert.assertEquals((String)"Statement should appear once", (long)1L, (long)this.con.size(new Resource[0]));
        this.con.commit();
    }

    @Test
    public void testDuplicateGetStatement() {
        this.con.begin();
        this.con.addStatement((Resource)RDF.SUBJECT, RDF.PREDICATE, (Value)RDF.OBJECT, new Resource[0]);
        this.con.commit();
        this.con.begin();
        this.con.addStatement((Resource)RDF.SUBJECT, RDF.PREDICATE, (Value)RDF.OBJECT, new Resource[0]);
        try (Stream stream = this.con.getStatements(null, null, null, false, new Resource[0]).stream();){
            long count = stream.count();
            Assert.assertEquals((String)"Statement should appear once", (long)1L, (long)count);
        }
        this.con.commit();
    }

    @Test
    public void testDuplicateGetStatementAfterCommit() {
        this.con.begin();
        this.con.addStatement((Resource)RDF.SUBJECT, RDF.PREDICATE, (Value)RDF.OBJECT, new Resource[0]);
        this.con.commit();
        this.con.begin();
        this.con.addStatement((Resource)RDF.SUBJECT, RDF.PREDICATE, (Value)RDF.OBJECT, new Resource[0]);
        this.con.commit();
        try (Stream stream = this.con.getStatements(null, null, null, false, new Resource[0]).stream();){
            long count = stream.count();
            Assert.assertEquals((String)"Statement should appear once", (long)1L, (long)count);
        }
    }

    @Test
    public void testDuplicateCountAfterComit() {
        this.con.begin();
        this.con.addStatement((Resource)RDF.SUBJECT, RDF.PREDICATE, (Value)RDF.OBJECT, new Resource[0]);
        this.con.commit();
        this.con.begin();
        this.con.addStatement((Resource)RDF.SUBJECT, RDF.PREDICATE, (Value)RDF.OBJECT, new Resource[0]);
        this.con.commit();
        Assert.assertEquals((String)"Statement should appear once", (long)1L, (long)this.con.size(new Resource[0]));
    }

    @Test
    public void testDuplicateCountMultipleTimes() {
        this.con.begin();
        this.con.addStatement((Resource)RDF.SUBJECT, RDF.PREDICATE, (Value)RDF.OBJECT, new Resource[0]);
        this.con.commit();
        this.con.begin();
        this.con.addStatement((Resource)RDF.SUBJECT, RDF.PREDICATE, (Value)RDF.OBJECT, new Resource[0]);
        Assert.assertEquals((String)"Statement should appear once", (long)1L, (long)this.con.size(new Resource[0]));
        Assert.assertEquals((String)"Statement should appear once", (long)1L, (long)this.con.size(new Resource[0]));
        Assert.assertEquals((String)"Statement should appear once", (long)1L, (long)this.con.size(new Resource[0]));
        this.con.commit();
    }

    private <T> T first(Iteration<T, ?> iter) throws Exception {
        try {
            if (iter.hasNext()) {
                Object object = iter.next();
                return (T)object;
            }
        }
        finally {
            Iterations.closeCloseable(iter);
        }
        return null;
    }

    protected int countContext1Elements() throws Exception, SailException {
        return this.countElements((Iteration<?, ?>)this.con.getStatements(null, null, null, false, new Resource[]{this.context1}));
    }

    protected int countAllElements() throws Exception, SailException {
        return this.countElements((Iteration<?, ?>)this.con.getStatements(null, null, null, false, new Resource[0]));
    }

    private int countElements(Iteration<?, ?> iter) throws Exception {
        int count = 0;
        try {
            while (iter.hasNext()) {
                iter.next();
                ++count;
            }
        }
        finally {
            Iterations.closeCloseable(iter);
        }
        return count;
    }

    protected int countQueryResults(String query) throws Exception {
        ParsedTupleQuery tupleQuery = QueryParserUtil.parseTupleQuery((QueryLanguage)QueryLanguage.SERQL, (String)(query + " using namespace ex = <" + EXAMPLE_NS + ">"), null);
        return this.countElements((Iteration<?, ?>)this.con.evaluate(tupleQuery.getTupleExpr(), null, EmptyBindingSet.getInstance(), false));
    }

    private int verifyQueryResult(CloseableIteration<? extends BindingSet, QueryEvaluationException> resultIter, int expectedBindingCount) throws QueryEvaluationException {
        int resultCount = 0;
        while (resultIter.hasNext()) {
            BindingSet resultBindings = (BindingSet)resultIter.next();
            ++resultCount;
            Assert.assertEquals((String)"Wrong number of binding names for binding set", (long)expectedBindingCount, (long)resultBindings.getBindingNames().size());
            int bindingCount = 0;
            Iterator bindingIter = resultBindings.iterator();
            while (bindingIter.hasNext()) {
                bindingIter.next();
                ++bindingCount;
            }
            Assert.assertEquals((String)"Wrong number of bindings in binding set", (long)expectedBindingCount, (long)bindingCount);
        }
        return resultCount;
    }
}

