/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail;

import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.sail.NotifyingSail;
import org.eclipse.rdf4j.sail.RDFStoreTest;
import org.eclipse.rdf4j.sail.SailChangedEvent;
import org.eclipse.rdf4j.sail.SailChangedListener;
import org.eclipse.rdf4j.sail.SailException;
import org.junit.Assert;
import org.junit.Test;

public abstract class RDFNotifyingStoreTest
extends RDFStoreTest
implements SailChangedListener {
    private int removeEventCount;
    private int addEventCount;

    protected abstract NotifyingSail createSail() throws SailException;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        ((NotifyingSail)this.sail).addSailChangedListener((SailChangedListener)this);
    }

    @Test
    public void testNotifyingRemoveAndClear() throws Exception {
        this.con.begin();
        this.con.addStatement((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.guernica, RDF.TYPE, (Value)this.painting, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[]{this.context1});
        this.con.commit();
        this.con.begin();
        this.con.removeStatements((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.commit();
        Assert.assertEquals((String)"Repository should contain 4 statements in total", (long)4L, (long)this.countAllElements());
        Assert.assertEquals((String)"Named context should contain 3 statements", (long)3L, (long)this.countContext1Elements());
        Assert.assertEquals((String)"Statement (Painting, type, Class) should no longer be in the repository", (long)0L, (long)this.countQueryResults("select 1 from {ex:Painting} rdf:type {rdfs:Class}"));
        this.con.begin();
        this.con.removeStatements(null, null, null, new Resource[]{this.context1});
        this.con.commit();
        Assert.assertEquals((String)"Repository should contain 1 statement in total", (long)1L, (long)this.countAllElements());
        Assert.assertEquals((String)"Named context should be empty", (long)0L, (long)this.countContext1Elements());
        this.con.begin();
        this.con.clear(new Resource[0]);
        this.con.commit();
        Assert.assertEquals((String)"Repository should no longer contain any statements", (long)0L, (long)this.countAllElements());
        Assert.assertEquals((String)"There should have been 1 event in which statements were added", (long)1L, (long)this.addEventCount);
        Assert.assertEquals((String)"There should have been 3 events in which statements were removed", (long)3L, (long)this.removeEventCount);
    }

    public void sailChanged(SailChangedEvent event) {
        if (event.statementsAdded()) {
            ++this.addEventCount;
        }
        if (event.statementsRemoved()) {
            ++this.removeEventCount;
        }
    }
}

