/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.IsolationLevels;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.UnknownSailTransactionStateException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SailIsolationLevelTest {
    private final Logger logger = LoggerFactory.getLogger(SailIsolationLevelTest.class);
    protected Sail store;
    private ValueFactory vf;
    private String failedMessage;
    private Throwable failed;

    @BeforeClass
    public static void setUpClass() throws Exception {
        System.setProperty("org.eclipse.rdf4j.repository.debug", "true");
    }

    @Before
    public void setUp() throws Exception {
        this.store = this.createSail();
        this.store.initialize();
        this.vf = this.store.getValueFactory();
        this.failed = null;
    }

    @After
    public void tearDown() throws Exception {
        this.store.shutDown();
    }

    protected abstract Sail createSail() throws SailException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isSupported(IsolationLevels level) throws SailException {
        SailConnection con = this.store.getConnection();
        try {
            con.begin((IsolationLevel)level);
            boolean bl = true;
            return bl;
        }
        catch (UnknownSailTransactionStateException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            con.rollback();
            con.close();
        }
    }

    @Test
    public void testNone() throws Exception {
        this.readPending((IsolationLevel)IsolationLevels.NONE);
    }

    @Test
    public void testReadUncommitted() throws Exception {
        this.rollbackTriple((IsolationLevel)IsolationLevels.READ_UNCOMMITTED);
        this.readPending((IsolationLevel)IsolationLevels.READ_UNCOMMITTED);
        this.readPendingWhileActive((IsolationLevel)IsolationLevels.READ_UNCOMMITTED);
    }

    @Test
    public void testReadCommitted() throws Exception {
        this.readCommitted((IsolationLevel)IsolationLevels.READ_COMMITTED);
        this.rollbackTriple((IsolationLevel)IsolationLevels.READ_COMMITTED);
        this.readPending((IsolationLevel)IsolationLevels.READ_COMMITTED);
        this.readPendingWhileActive((IsolationLevel)IsolationLevels.READ_COMMITTED);
    }

    @Test
    public void testSnapshotRead() throws Exception {
        if (this.isSupported(IsolationLevels.SNAPSHOT_READ)) {
            this.snapshotRead((IsolationLevel)IsolationLevels.SNAPSHOT_READ);
            this.readCommitted((IsolationLevel)IsolationLevels.SNAPSHOT_READ);
            this.rollbackTriple((IsolationLevel)IsolationLevels.SNAPSHOT_READ);
            this.readPending((IsolationLevel)IsolationLevels.SNAPSHOT_READ);
            this.readPendingWhileActive((IsolationLevel)IsolationLevels.SNAPSHOT_READ);
        } else {
            this.logger.warn("{} does not support {}", (Object)this.store, (Object)IsolationLevels.SNAPSHOT_READ);
        }
    }

    @Test
    public void testSnapshot() throws Exception {
        if (this.isSupported(IsolationLevels.SNAPSHOT)) {
            this.snapshot(IsolationLevels.SNAPSHOT);
            this.snapshotRead((IsolationLevel)IsolationLevels.SNAPSHOT);
            this.repeatableRead(IsolationLevels.SNAPSHOT);
            this.readCommitted((IsolationLevel)IsolationLevels.SNAPSHOT);
            this.rollbackTriple((IsolationLevel)IsolationLevels.SNAPSHOT);
            this.readPending((IsolationLevel)IsolationLevels.SNAPSHOT);
            this.readPendingWhileActive((IsolationLevel)IsolationLevels.SNAPSHOT);
        } else {
            this.logger.warn("{} does not support {}", (Object)this.store, (Object)IsolationLevels.SNAPSHOT);
        }
    }

    @Test
    public void testSerializable() throws Exception {
        if (this.isSupported(IsolationLevels.SERIALIZABLE)) {
            this.serializable(IsolationLevels.SERIALIZABLE);
            this.snapshot(IsolationLevels.SERIALIZABLE);
            this.snapshotRead((IsolationLevel)IsolationLevels.SERIALIZABLE);
            this.repeatableRead(IsolationLevels.SERIALIZABLE);
            this.readCommitted((IsolationLevel)IsolationLevels.SERIALIZABLE);
            this.rollbackTriple((IsolationLevel)IsolationLevels.SERIALIZABLE);
            this.readPending((IsolationLevel)IsolationLevels.SERIALIZABLE);
            this.readPendingWhileActive((IsolationLevel)IsolationLevels.SERIALIZABLE);
        } else {
            this.logger.warn("{} does not support {}", (Object)this.store, (Object)IsolationLevels.SERIALIZABLE);
        }
    }

    private void readPending(IsolationLevel level) throws SailException {
        this.clear(this.store);
        try (SailConnection con = this.store.getConnection();){
            con.begin(level);
            con.addStatement((Resource)RDF.NIL, RDF.TYPE, (Value)RDF.LIST, new Resource[0]);
            Assert.assertEquals((long)1L, (long)this.count(con, (Resource)RDF.NIL, RDF.TYPE, (Value)RDF.LIST, false, new Resource[0]));
            con.removeStatements((Resource)RDF.NIL, RDF.TYPE, (Value)RDF.LIST, new Resource[0]);
            con.commit();
        }
    }

    private void readPendingWhileActive(IsolationLevel level) throws SailException {
        this.clear(this.store);
        try (SailConnection con = this.store.getConnection();
             CloseableIteration unusedStatements = con.getStatements(null, null, null, true, new Resource[0]);){
            con.begin(level);
            con.addStatement((Resource)RDF.NIL, RDF.TYPE, (Value)RDF.LIST, new Resource[0]);
            Assert.assertEquals((long)1L, (long)this.count(con, (Resource)RDF.NIL, RDF.TYPE, (Value)RDF.LIST, false, new Resource[0]));
            con.removeStatements((Resource)RDF.NIL, RDF.TYPE, (Value)RDF.LIST, new Resource[0]);
            con.commit();
        }
    }

    private void rollbackTriple(IsolationLevel level) throws SailException {
        this.clear(this.store);
        try (SailConnection con = this.store.getConnection();){
            con.begin(level);
            con.addStatement((Resource)RDF.NIL, RDF.TYPE, (Value)RDF.LIST, new Resource[0]);
            con.rollback();
            Assert.assertEquals((long)0L, (long)this.count(con, (Resource)RDF.NIL, RDF.TYPE, (Value)RDF.LIST, false, new Resource[0]));
        }
    }

    private void readCommitted(final IsolationLevel level) throws Exception {
        this.clear(this.store);
        final CountDownLatch start = new CountDownLatch(2);
        final CountDownLatch begin = new CountDownLatch(1);
        final CountDownLatch uncommitted = new CountDownLatch(1);
        Thread writer = new Thread(new Runnable(){

            @Override
            public void run() {
                try (SailConnection write = SailIsolationLevelTest.this.store.getConnection();){
                    start.countDown();
                    start.await();
                    write.begin(level);
                    write.addStatement((Resource)RDF.NIL, RDF.TYPE, (Value)RDF.LIST, new Resource[0]);
                    begin.countDown();
                    uncommitted.await(1L, TimeUnit.SECONDS);
                    write.rollback();
                }
                catch (Throwable e) {
                    SailIsolationLevelTest.this.fail("Writer failed", e);
                }
            }
        });
        Thread reader = new Thread(new Runnable(){

            @Override
            public void run() {
                try (SailConnection read = SailIsolationLevelTest.this.store.getConnection();){
                    start.countDown();
                    start.await();
                    begin.await();
                    read.begin(level);
                    long counted = SailIsolationLevelTest.this.count(read, (Resource)RDF.NIL, RDF.TYPE, (Value)RDF.LIST, false, new Resource[0]);
                    uncommitted.countDown();
                    try {
                        read.commit();
                    }
                    catch (SailException e) {
                        read.rollback();
                        if (read != null) {
                            if (var2_3 != null) {
                                try {
                                    read.close();
                                }
                                catch (Throwable throwable) {
                                    var2_3.addSuppressed(throwable);
                                }
                            } else {
                                read.close();
                            }
                        }
                        return;
                    }
                    Assert.assertEquals((long)0L, (long)counted);
                }
                catch (Throwable e) {
                    SailIsolationLevelTest.this.fail("Reader failed", e);
                }
            }
        });
        reader.start();
        writer.start();
        reader.join();
        writer.join();
        this.assertNotFailed();
    }

    private void repeatableRead(final IsolationLevels level) throws Exception {
        this.clear(this.store);
        final CountDownLatch start = new CountDownLatch(2);
        final CountDownLatch begin = new CountDownLatch(1);
        final CountDownLatch observed = new CountDownLatch(1);
        final CountDownLatch changed = new CountDownLatch(1);
        Thread writer = new Thread(new Runnable(){

            @Override
            public void run() {
                try (SailConnection write = SailIsolationLevelTest.this.store.getConnection();){
                    start.countDown();
                    start.await();
                    write.begin((IsolationLevel)level);
                    write.addStatement((Resource)RDF.NIL, RDF.TYPE, (Value)RDF.LIST, new Resource[0]);
                    write.commit();
                    begin.countDown();
                    observed.await(1L, TimeUnit.SECONDS);
                    write.begin((IsolationLevel)level);
                    write.removeStatements((Resource)RDF.NIL, RDF.TYPE, (Value)RDF.LIST, new Resource[0]);
                    write.commit();
                    changed.countDown();
                }
                catch (Throwable e) {
                    SailIsolationLevelTest.this.fail("Writer failed", e);
                }
            }
        });
        Thread reader = new Thread(new Runnable(){

            @Override
            public void run() {
                try (SailConnection read = SailIsolationLevelTest.this.store.getConnection();){
                    start.countDown();
                    start.await();
                    begin.await();
                    read.begin((IsolationLevel)level);
                    long first = SailIsolationLevelTest.this.count(read, (Resource)RDF.NIL, RDF.TYPE, (Value)RDF.LIST, false, new Resource[0]);
                    Assert.assertEquals((long)1L, (long)first);
                    observed.countDown();
                    changed.await(1L, TimeUnit.SECONDS);
                    long second = SailIsolationLevelTest.this.count(read, (Resource)RDF.NIL, RDF.TYPE, (Value)RDF.LIST, false, new Resource[0]);
                    try {
                        read.commit();
                    }
                    catch (SailException e) {
                        read.rollback();
                        if (read != null) {
                            if (var2_3 != null) {
                                try {
                                    read.close();
                                }
                                catch (Throwable throwable) {
                                    var2_3.addSuppressed(throwable);
                                }
                            } else {
                                read.close();
                            }
                        }
                        return;
                    }
                    Assert.assertEquals((long)first, (long)second);
                }
                catch (Throwable e) {
                    SailIsolationLevelTest.this.fail("Reader failed", e);
                }
            }
        });
        reader.start();
        writer.start();
        reader.join();
        writer.join();
        this.assertNotFailed();
    }

    private void snapshotRead(IsolationLevel level) throws SailException {
        this.clear(this.store);
        try (SailConnection con = this.store.getConnection();){
            con.begin(level);
            int size = 1000;
            for (int i = 0; i < size; ++i) {
                this.insertTestStatement(con, i);
            }
            int counter = 0;
            try (CloseableIteration stmts = con.getStatements(null, null, null, false, new Resource[0]);){
                while (stmts.hasNext()) {
                    Statement st = (Statement)stmts.next();
                    if (++counter >= size) continue;
                    con.removeStatements(st.getSubject(), st.getPredicate(), st.getObject(), new Resource[]{st.getContext()});
                    this.insertTestStatement(con, size + counter);
                    this.insertTestStatement(con, size + size + counter);
                }
            }
            try {
                con.commit();
            }
            catch (SailException e) {
                e.printStackTrace();
                if (con != null) {
                    if (var3_3 != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable) {
                            var3_3.addSuppressed(throwable);
                        }
                    } else {
                        con.close();
                    }
                }
                return;
            }
            Assert.assertEquals((long)size, (long)counter);
        }
    }

    private void snapshot(final IsolationLevels level) throws Exception {
        this.clear(this.store);
        final CountDownLatch start = new CountDownLatch(2);
        final CountDownLatch begin = new CountDownLatch(1);
        final CountDownLatch observed = new CountDownLatch(1);
        final CountDownLatch changed = new CountDownLatch(1);
        Thread writer = new Thread(new Runnable(){

            @Override
            public void run() {
                try (SailConnection write = SailIsolationLevelTest.this.store.getConnection();){
                    start.countDown();
                    start.await();
                    write.begin((IsolationLevel)level);
                    SailIsolationLevelTest.this.insertTestStatement(write, 1);
                    write.commit();
                    begin.countDown();
                    observed.await(1L, TimeUnit.SECONDS);
                    write.begin((IsolationLevel)level);
                    SailIsolationLevelTest.this.insertTestStatement(write, 2);
                    write.commit();
                    changed.countDown();
                }
                catch (Throwable e) {
                    SailIsolationLevelTest.this.fail("Writer failed", e);
                }
            }
        });
        Thread reader = new Thread(new Runnable(){

            @Override
            public void run() {
                try (SailConnection read = SailIsolationLevelTest.this.store.getConnection();){
                    start.countDown();
                    start.await();
                    begin.await();
                    read.begin((IsolationLevel)level);
                    long first = SailIsolationLevelTest.this.count(read, null, null, null, false, new Resource[0]);
                    observed.countDown();
                    changed.await(1L, TimeUnit.SECONDS);
                    long second = SailIsolationLevelTest.this.count(read, null, null, null, false, new Resource[0]);
                    try {
                        read.commit();
                    }
                    catch (SailException e) {
                        read.rollback();
                        if (read != null) {
                            if (var2_3 != null) {
                                try {
                                    read.close();
                                }
                                catch (Throwable throwable) {
                                    var2_3.addSuppressed(throwable);
                                }
                            } else {
                                read.close();
                            }
                        }
                        return;
                    }
                    Assert.assertEquals((long)first, (long)second);
                }
                catch (Throwable e) {
                    SailIsolationLevelTest.this.fail("Reader failed", e);
                }
            }
        });
        reader.start();
        writer.start();
        reader.join();
        writer.join();
        this.assertNotFailed();
    }

    private void serializable(IsolationLevels level) throws Exception {
        this.clear(this.store);
        ValueFactory vf = this.store.getValueFactory();
        IRI subj = vf.createIRI("http://test#s");
        IRI pred = vf.createIRI("http://test#p");
        try (SailConnection prep = this.store.getConnection();){
            prep.begin((IsolationLevel)level);
            prep.addStatement((Resource)subj, pred, (Value)vf.createLiteral(1), new Resource[0]);
            prep.commit();
        }
        CountDownLatch start = new CountDownLatch(2);
        CountDownLatch observed = new CountDownLatch(2);
        Thread t1 = this.incrementBy(start, observed, level, vf, subj, pred, 3);
        Thread t2 = this.incrementBy(start, observed, level, vf, subj, pred, 5);
        t2.start();
        t1.start();
        t2.join();
        t1.join();
        this.assertNotFailed();
        try (SailConnection check = this.store.getConnection();){
            check.begin((IsolationLevel)level);
            Literal lit = this.readLiteral(check, subj, pred);
            int val = lit.intValue();
            if (val != 4 && val != 6) {
                Assert.assertEquals((long)9L, (long)val);
            }
            check.commit();
        }
    }

    protected Thread incrementBy(final CountDownLatch start, final CountDownLatch observed, final IsolationLevels level, final ValueFactory vf, final IRI subj, final IRI pred, final int by) {
        return new Thread(new Runnable(){

            @Override
            public void run() {
                try (SailConnection con = SailIsolationLevelTest.this.store.getConnection();){
                    start.countDown();
                    start.await();
                    con.begin((IsolationLevel)level);
                    Literal o1 = SailIsolationLevelTest.this.readLiteral(con, subj, pred);
                    observed.countDown();
                    observed.await(1L, TimeUnit.SECONDS);
                    con.removeStatements((Resource)subj, pred, (Value)o1, new Resource[0]);
                    con.addStatement((Resource)subj, pred, (Value)vf.createLiteral(o1.intValue() + by), new Resource[0]);
                    try {
                        con.commit();
                    }
                    catch (SailException e) {
                        con.rollback();
                    }
                }
                catch (Throwable e) {
                    SailIsolationLevelTest.this.fail("Increment " + by + " failed", e);
                }
            }
        });
    }

    private void clear(Sail store) throws SailException {
        try (SailConnection con = store.getConnection();){
            con.begin();
            con.clear(new Resource[0]);
            con.commit();
        }
    }

    protected long count(SailConnection con, Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        try (CloseableIteration stmts = con.getStatements(subj, pred, obj, includeInferred, contexts);){
            long counter = 0L;
            while (stmts.hasNext()) {
                stmts.next();
                ++counter;
            }
            long l = counter;
            return l;
        }
    }

    protected Literal readLiteral(SailConnection con, IRI subj, IRI pred) throws SailException {
        try (CloseableIteration stmts = con.getStatements((Resource)subj, pred, null, false, new Resource[0]);){
            if (!stmts.hasNext()) {
                Literal literal = null;
                return literal;
            }
            Value obj = ((Statement)stmts.next()).getObject();
            if (stmts.hasNext()) {
                Assert.fail((String)("multiple literals: " + obj + " and " + stmts.next()));
            }
            Literal literal = (Literal)obj;
            return literal;
        }
    }

    protected void insertTestStatement(SailConnection connection, int i) throws SailException {
        Literal lit = this.vf.createLiteral(Integer.toString(i), XMLSchema.INTEGER);
        connection.addStatement((Resource)this.vf.createIRI("http://test#s" + i), this.vf.createIRI("http://test#p"), (Value)lit, new Resource[]{this.vf.createIRI("http://test#context_" + i)});
    }

    protected synchronized void fail(String message, Throwable t) {
        this.failedMessage = message;
        this.failed = t;
    }

    protected synchronized void assertNotFailed() {
        if (this.failed != null) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)this.failedMessage))).initCause(this.failed));
        }
    }
}

