/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf.datastore;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.eclipse.rdf4j.common.io.NioFile;

public class DataFile
implements Closeable {
    private static final byte[] MAGIC_NUMBER = new byte[]{110, 100, 102};
    private static final byte FILE_FORMAT_VERSION = 1;
    private static final long HEADER_LENGTH = MAGIC_NUMBER.length + 1;
    private final NioFile nioFile;
    private final boolean forceSync;
    int dataLengthApproximateAverage = 25;

    public DataFile(File file) throws IOException {
        this(file, false);
    }

    public DataFile(File file, boolean forceSync) throws IOException {
        this.nioFile = new NioFile(file);
        this.forceSync = forceSync;
        try {
            if (this.nioFile.size() == 0L) {
                this.nioFile.writeBytes(MAGIC_NUMBER, 0L);
                this.nioFile.writeByte((byte)1, (long)MAGIC_NUMBER.length);
                this.sync();
            } else {
                if (this.nioFile.size() < HEADER_LENGTH) {
                    throw new IOException("File too small to be a compatible data file");
                }
                if (!Arrays.equals(MAGIC_NUMBER, this.nioFile.readBytes(0L, MAGIC_NUMBER.length))) {
                    throw new IOException("File doesn't contain compatible data records");
                }
                byte version = this.nioFile.readByte((long)MAGIC_NUMBER.length);
                if (version > 1) {
                    throw new IOException("Unable to read data file; it uses a newer file format");
                }
                if (version != 1) {
                    throw new IOException("Unable to read data file; invalid file format version: " + version);
                }
            }
        }
        catch (IOException e) {
            this.nioFile.close();
            throw e;
        }
    }

    public File getFile() {
        return this.nioFile.getFile();
    }

    public long storeData(byte[] data) throws IOException {
        assert (data != null) : "data must not be null";
        long offset = this.nioFile.size();
        ByteBuffer buf = ByteBuffer.allocate(data.length + 4);
        buf.putInt(data.length);
        buf.put(data);
        buf.rewind();
        this.nioFile.write(buf, offset);
        return offset;
    }

    public byte[] getData(long offset) throws IOException {
        assert (offset > 0L) : "offset must be larger than 0, is: " + offset;
        byte[] data = new byte[this.dataLengthApproximateAverage * 2 + 4];
        ByteBuffer buf = ByteBuffer.wrap(data);
        this.nioFile.read(buf, offset);
        int dataLength = data[0] << 24 & 0xFF000000 | data[1] << 16 & 0xFF0000 | data[2] << 8 & 0xFF00 | data[3] & 0xFF;
        if (dataLength <= data.length - 4) {
            this.dataLengthApproximateAverage = (int)Math.min(200.0, (double)this.dataLengthApproximateAverage / 100.0 * 99.0 + (double)dataLength / 100.0);
            return Arrays.copyOfRange(data, 4, dataLength + 4);
        }
        this.dataLengthApproximateAverage = Math.min(200, (this.dataLengthApproximateAverage + dataLength) / 2);
        data = new byte[dataLength];
        buf = ByteBuffer.wrap(data);
        this.nioFile.read(buf, offset + 4L);
        return data;
    }

    public void clear() throws IOException {
        this.nioFile.truncate(HEADER_LENGTH);
    }

    public void sync() throws IOException {
        if (this.forceSync) {
            this.nioFile.force(false);
        }
    }

    @Override
    public void close() throws IOException {
        this.nioFile.close();
    }

    public DataIterator iterator() {
        return new DataIterator();
    }

    static /* synthetic */ long access$000() {
        return HEADER_LENGTH;
    }

    public class DataIterator {
        private long position = DataFile.access$000();

        public boolean hasNext() throws IOException {
            return this.position < DataFile.this.nioFile.size();
        }

        public byte[] next() throws IOException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            byte[] data = DataFile.this.getData(this.position);
            this.position += (long)(4 + data.length);
            return data;
        }
    }
}

