/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb;

import java.io.Serializable;
import java.util.Objects;
import org.eclipse.rdf4j.sail.lmdb.ValueStore;
import org.eclipse.rdf4j.sail.lmdb.model.LmdbValue;

public interface ValueStoreRevision {
    public long getRevisionId();

    public ValueStore getValueStore();

    public boolean resolveValue(long var1, LmdbValue var3);

    public static class Lazy
    extends Base
    implements Serializable {
        private static final long serialVersionUID = -2434063125560285009L;
        private final ValueStoreRevision revision;

        public Lazy(ValueStoreRevision revision) {
            this.revision = revision;
        }

        @Override
        public long getRevisionId() {
            return this.revision.getRevisionId();
        }

        @Override
        public ValueStore getValueStore() {
            return this.revision.getValueStore();
        }

        @Override
        public boolean resolveValue(long id, LmdbValue value) {
            if (this.revision.resolveValue(id, value)) {
                value.setInternalID(id, this.revision);
                return true;
            }
            return false;
        }
    }

    public static class Default
    extends Base
    implements Serializable {
        private static final long serialVersionUID = -2434063125560285009L;
        private static volatile long revisionIdCounter = 0L;
        private final transient ValueStore valueStore;
        private final long revisionId = ++revisionIdCounter;

        public Default(ValueStore valueStore) {
            this.valueStore = valueStore;
        }

        @Override
        public long getRevisionId() {
            return this.revisionId;
        }

        @Override
        public ValueStore getValueStore() {
            return this.valueStore;
        }

        @Override
        public boolean resolveValue(long id, LmdbValue value) {
            return this.valueStore.resolveValue(id, value);
        }
    }

    public static abstract class Base
    implements ValueStoreRevision {
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ValueStoreRevision)) {
                return false;
            }
            ValueStoreRevision other = (ValueStoreRevision)o;
            return this.getRevisionId() == other.getRevisionId() && Objects.equals((Object)this.getValueStore(), (Object)other.getValueStore());
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.getValueStore(), this.getRevisionId()});
        }
    }
}

