/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.extensiblestore.evaluationstatistics;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import net.agkn.hll.HLL;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.EvaluationStatistics;
import org.eclipse.rdf4j.sail.extensiblestore.ExtensibleSailStore;
import org.eclipse.rdf4j.sail.extensiblestore.evaluationstatistics.DynamicStatistics;
import org.eclipse.rdf4j.sail.extensiblestore.evaluationstatistics.ExtensibleEvaluationStatistics;
import org.eclipse.rdf4j.sail.extensiblestore.valuefactory.ExtensibleStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class ExtensibleDynamicEvaluationStatistics
extends ExtensibleEvaluationStatistics
implements DynamicStatistics {
    private static final Logger logger = LoggerFactory.getLogger(ExtensibleDynamicEvaluationStatistics.class);
    private static final int QUEUE_LIMIT = 128;
    private static final int SINGLE_DIMENSION_INDEX_SIZE = 1024;
    ConcurrentLinkedQueue<StatementQueueItem> queue = new ConcurrentLinkedQueue();
    private final Object monitor = new Object();
    AtomicInteger queueSize = new AtomicInteger();
    private final HashFunction HASH_FUNCTION = Hashing.murmur3_128();
    private final HLL EMPTY_HLL = this.getHLL();
    private final HLL size = this.getHLL();
    private final HLL size_removed = this.getHLL();
    private final Map<Integer, HLL> subjectIndex = new HashMap<Integer, HLL>();
    private final Map<Integer, HLL> predicateIndex = new HashMap<Integer, HLL>();
    private final Map<Integer, HLL> objectIndex = new HashMap<Integer, HLL>();
    private final Map<Integer, HLL> contextIndex = new HashMap<Integer, HLL>();
    private final HLL defaultContext = this.getHLL();
    private final HLL[][] subjectPredicateIndex = new HLL[64][64];
    private final HLL[][] predicateObjectIndex = new HLL[64][64];
    private final Map<Integer, HLL> subjectIndex_removed = new HashMap<Integer, HLL>();
    private final Map<Integer, HLL> predicateIndex_removed = new HashMap<Integer, HLL>();
    private final Map<Integer, HLL> objectIndex_removed = new HashMap<Integer, HLL>();
    private final Map<Integer, HLL> contextIndex_removed = new HashMap<Integer, HLL>();
    private final HLL defaultContext_removed = this.getHLL();
    private final HLL[][] subjectPredicateIndex_removed = new HLL[64][64];
    private final HLL[][] predicateObjectIndex_removed = new HLL[64][64];
    private volatile Thread queueConsumingThread;

    public ExtensibleDynamicEvaluationStatistics(ExtensibleSailStore extensibleSailStore) {
        super(extensibleSailStore);
        Stream.of(new HLL[][][]{this.subjectPredicateIndex, this.predicateObjectIndex, this.subjectPredicateIndex_removed, this.predicateObjectIndex_removed}).forEach(index -> {
            for (int i = 0; i < ((HLL[][])index).length; ++i) {
                for (int j = 0; j < index[i].length; ++j) {
                    index[i][j] = this.getHLL();
                }
            }
        });
    }

    @Override
    protected EvaluationStatistics.CardinalityCalculator createCardinalityCalculator() {
        return new ExtensibleDynamicEvaluationStatisticsCardinalityCalculator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double staleness(long expectedSize) {
        Object object = this.monitor;
        synchronized (object) {
            double estimatedSize = this.size.cardinality() - this.size_removed.cardinality();
            double diff = Math.abs((estimatedSize += 500.0) - (double)(expectedSize += 500L));
            double staleness = estimatedSize + (double)expectedSize == 0.0 || diff == 0.0 ? 0.0 : ((double)expectedSize > estimatedSize ? diff / (double)expectedSize : diff / Math.max(0.0, estimatedSize));
            logger.debug("expected size {}; estimated size: {}; staleness: {}", new Object[]{expectedSize, estimatedSize, staleness});
            return staleness;
        }
    }

    private double getHllCardinality(HLL[][] index, HLL[][] index_removed, Value value1, Value value2) {
        int value1IndexIntoAdded = Math.abs(value1.hashCode() % index.length);
        int value2IndexIntoAdded = Math.abs(value2.hashCode() % index.length);
        double cardinalityAdded = index[value1IndexIntoAdded][value2IndexIntoAdded].cardinality();
        int value1IndexIntoRemoved = Math.abs(value1.hashCode() % index_removed.length);
        int value2IndexIntoRemoved = Math.abs(value2.hashCode() % index_removed.length);
        double removedStatements = index_removed[value1IndexIntoRemoved][value2IndexIntoRemoved].cardinality();
        return cardinalityAdded - removedStatements;
    }

    private double getHllCardinality(Map<Integer, HLL> index, Map<Integer, HLL> index_removed, Value value) {
        int indexIntoMap = Math.abs(value.hashCode() % 1024);
        double cardinalityAdded = index.getOrDefault(indexIntoMap, this.EMPTY_HLL).cardinality();
        double cardinalityRemoved = index_removed.getOrDefault(indexIntoMap, this.EMPTY_HLL).cardinality();
        return cardinalityAdded - cardinalityRemoved;
    }

    @Override
    public void add(ExtensibleStatement statement) {
        this.queue.add(new StatementQueueItem(statement, StatementQueueItem.Type.added));
        int size = this.queueSize.incrementAndGet();
        if (size > 128 && this.queueConsumingThread == null) {
            this.startQueueConsumingThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startQueueConsumingThread() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.queueConsumingThread == null) {
                this.queueConsumingThread = new Thread(() -> {
                    block10: {
                        block5: while (true) {
                            while (!this.queue.isEmpty()) {
                                StatementQueueItem poll = this.queue.poll();
                                this.queueSize.decrementAndGet();
                                ExtensibleStatement statement = poll.statement;
                                long statementHash = this.HASH_FUNCTION.hashString((CharSequence)statement.toString(), StandardCharsets.UTF_8).asLong();
                                if (poll.type == StatementQueueItem.Type.added) {
                                    this.handleStatement(statement, statementHash, this.size, this.subjectIndex, this.predicateIndex, this.objectIndex, this.subjectPredicateIndex, this.predicateObjectIndex, this.defaultContext, this.contextIndex);
                                } else {
                                    assert (poll.type == StatementQueueItem.Type.removed);
                                    this.handleStatement(statement, statementHash, this.size_removed, this.subjectIndex_removed, this.predicateIndex_removed, this.objectIndex_removed, this.subjectPredicateIndex_removed, this.predicateObjectIndex_removed, this.defaultContext_removed, this.contextIndex_removed);
                                }
                                if (!this.queue.isEmpty()) continue;
                                try {
                                    Thread.sleep(2L);
                                    continue block5;
                                }
                                catch (InterruptedException interruptedException) {
                                }
                            }
                            break block10;
                            {
                                continue block5;
                                break;
                            }
                            break;
                        }
                        finally {
                            this.queueConsumingThread = null;
                        }
                    }
                });
                this.queueConsumingThread.setDaemon(true);
                this.queueConsumingThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleStatement(Statement statement, long statementHash, HLL size, Map<Integer, HLL> subjectIndex, Map<Integer, HLL> predicateIndex, Map<Integer, HLL> objectIndex, HLL[][] subjectPredicateIndex, HLL[][] predicateObjectIndex, HLL defaultContext, Map<Integer, HLL> contextIndex) {
        Object object = this.monitor;
        synchronized (object) {
            size.addRaw(statementHash);
            int subjectHash = statement.getSubject().hashCode();
            int predicateHash = statement.getPredicate().hashCode();
            int objectHash = statement.getObject().hashCode();
            this.indexOneValue(statementHash, subjectIndex, subjectHash);
            this.indexOneValue(statementHash, predicateIndex, predicateHash);
            this.indexOneValue(statementHash, objectIndex, objectHash);
            this.indexTwoValues(statementHash, subjectPredicateIndex, subjectHash, predicateHash);
            this.indexTwoValues(statementHash, predicateObjectIndex, predicateHash, objectHash);
            if (statement.getContext() == null) {
                defaultContext.addRaw(statementHash);
            } else {
                this.indexOneValue(statementHash, contextIndex, statement.getContext().hashCode());
            }
        }
    }

    private void indexTwoValues(long statementHash, HLL[][] index, int indexHash, int indexHash2) {
        index[Math.abs(indexHash % index.length)][Math.abs(indexHash2 % index.length)].addRaw(statementHash);
    }

    private void indexOneValue(long statementHash, Map<Integer, HLL> index, int indexHash) {
        index.compute(Math.abs(indexHash % 1024), (key, val) -> {
            if (val == null) {
                val = this.getHLL();
            }
            val.addRaw(statementHash);
            return val;
        });
    }

    private HLL getHLL() {
        return new HLL(13, 5);
    }

    @Override
    public void remove(ExtensibleStatement statement) {
        this.queue.add(new StatementQueueItem(statement, StatementQueueItem.Type.removed));
        int size = this.queueSize.incrementAndGet();
        if (size > 128 && this.queueConsumingThread == null) {
            this.startQueueConsumingThread();
        }
    }

    @Override
    public void removeByQuery(Resource subj, IRI pred, Value obj, boolean inferred, Resource ... contexts) {
    }

    public void waitForQueue() throws InterruptedException {
        while (this.queueConsumingThread != null) {
            try {
                this.queueConsumingThread.join();
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    class ExtensibleDynamicEvaluationStatisticsCardinalityCalculator
    extends EvaluationStatistics.CardinalityCalculator {
        ExtensibleDynamicEvaluationStatisticsCardinalityCalculator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected double getCardinality(StatementPattern sp) {
            Object object = ExtensibleDynamicEvaluationStatistics.this.monitor;
            synchronized (object) {
                double min = ExtensibleDynamicEvaluationStatistics.this.size.cardinality() - ExtensibleDynamicEvaluationStatistics.this.size_removed.cardinality();
                min = Math.min(min, this.getSubjectCardinality(sp.getSubjectVar()));
                min = Math.min(min, this.getPredicateCardinality(sp.getPredicateVar()));
                min = Math.min(min, this.getObjectCardinality(sp.getObjectVar()));
                if (min < 2.0) {
                    return min;
                }
                if (sp.getSubjectVar().getValue() != null && sp.getPredicateVar().getValue() != null) {
                    min = Math.min(min, ExtensibleDynamicEvaluationStatistics.this.getHllCardinality(ExtensibleDynamicEvaluationStatistics.this.subjectPredicateIndex, ExtensibleDynamicEvaluationStatistics.this.subjectPredicateIndex_removed, sp.getSubjectVar().getValue(), sp.getPredicateVar().getValue()));
                }
                if (sp.getPredicateVar().getValue() != null && sp.getObjectVar().getValue() != null) {
                    min = Math.min(min, ExtensibleDynamicEvaluationStatistics.this.getHllCardinality(ExtensibleDynamicEvaluationStatistics.this.predicateObjectIndex, ExtensibleDynamicEvaluationStatistics.this.predicateObjectIndex_removed, sp.getPredicateVar().getValue(), sp.getObjectVar().getValue()));
                }
                return min;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected double getSubjectCardinality(Var var) {
            Object object = ExtensibleDynamicEvaluationStatistics.this.monitor;
            synchronized (object) {
                if (var.getValue() == null) {
                    return ExtensibleDynamicEvaluationStatistics.this.size.cardinality();
                }
                return ExtensibleDynamicEvaluationStatistics.this.getHllCardinality(ExtensibleDynamicEvaluationStatistics.this.subjectIndex, ExtensibleDynamicEvaluationStatistics.this.subjectIndex_removed, var.getValue());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected double getPredicateCardinality(Var var) {
            Object object = ExtensibleDynamicEvaluationStatistics.this.monitor;
            synchronized (object) {
                if (var.getValue() == null) {
                    return ExtensibleDynamicEvaluationStatistics.this.size.cardinality();
                }
                return ExtensibleDynamicEvaluationStatistics.this.getHllCardinality(ExtensibleDynamicEvaluationStatistics.this.predicateIndex, ExtensibleDynamicEvaluationStatistics.this.predicateIndex_removed, var.getValue());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected double getObjectCardinality(Var var) {
            Object object = ExtensibleDynamicEvaluationStatistics.this.monitor;
            synchronized (object) {
                if (var.getValue() == null) {
                    return ExtensibleDynamicEvaluationStatistics.this.size.cardinality();
                }
                return ExtensibleDynamicEvaluationStatistics.this.getHllCardinality(ExtensibleDynamicEvaluationStatistics.this.objectIndex, ExtensibleDynamicEvaluationStatistics.this.objectIndex_removed, var.getValue());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected double getContextCardinality(Var var) {
            Object object = ExtensibleDynamicEvaluationStatistics.this.monitor;
            synchronized (object) {
                if (var == null || var.getValue() == null) {
                    return ExtensibleDynamicEvaluationStatistics.this.defaultContext.cardinality() - ExtensibleDynamicEvaluationStatistics.this.defaultContext_removed.cardinality();
                }
                return ExtensibleDynamicEvaluationStatistics.this.getHllCardinality(ExtensibleDynamicEvaluationStatistics.this.contextIndex, ExtensibleDynamicEvaluationStatistics.this.contextIndex_removed, var.getValue());
            }
        }
    }

    static class StatementQueueItem {
        ExtensibleStatement statement;
        Type type;

        public StatementQueueItem(ExtensibleStatement statement, Type type) {
            this.statement = statement;
            this.type = type;
        }

        static enum Type {
            added,
            removed;

        }
    }
}

