/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.extensiblestore;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.rdf4j.collection.factory.api.CollectionFactory;
import org.eclipse.rdf4j.collection.factory.mapdb.MapDb3CollectionFactory;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategyFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolverClient;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.StrictEvaluationStrategyFactory;
import org.eclipse.rdf4j.repository.sparql.federation.SPARQLServiceResolver;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.extensiblestore.DataStructureInterface;
import org.eclipse.rdf4j.sail.extensiblestore.EagerReadCache;
import org.eclipse.rdf4j.sail.extensiblestore.ExtensibleSailStore;
import org.eclipse.rdf4j.sail.extensiblestore.LazyReadCache;
import org.eclipse.rdf4j.sail.extensiblestore.NamespaceStoreInterface;
import org.eclipse.rdf4j.sail.extensiblestore.evaluationstatistics.EvaluationStatisticsEnum;
import org.eclipse.rdf4j.sail.extensiblestore.valuefactory.ExtensibleStatementHelper;
import org.eclipse.rdf4j.sail.helpers.AbstractNotifyingSail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public abstract class ExtensibleStore<T extends DataStructureInterface, N extends NamespaceStoreInterface>
extends AbstractNotifyingSail
implements FederatedServiceResolverClient {
    private static final Logger logger = LoggerFactory.getLogger(ExtensibleStore.class);
    protected ExtensibleSailStore sailStore;
    protected N namespaceStore;
    protected T dataStructure;
    private final Cache cache;
    private EvaluationStrategyFactory evalStratFactory;
    private SPARQLServiceResolver dependentServiceResolver;
    private FederatedServiceResolver serviceResolver;

    public ExtensibleStore() {
        this(Cache.EAGER);
    }

    public ExtensibleStore(Cache cache) {
        this.cache = cache;
    }

    ExtensibleSailStore getSailStore() {
        return this.sailStore;
    }

    protected synchronized void initializeInternal() throws SailException {
        if (this.sailStore != null) {
            this.sailStore.close();
        }
        DataStructureInterface dataStructure = (DataStructureInterface)Objects.requireNonNull(this.dataStructure);
        switch (this.cache.ordinal()) {
            case 2: {
                dataStructure = new EagerReadCache(dataStructure);
                break;
            }
            case 1: {
                dataStructure = new LazyReadCache(dataStructure);
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.sailStore = new ExtensibleSailStore(dataStructure, (NamespaceStoreInterface)Objects.requireNonNull(this.namespaceStore), this.getEvaluationStatisticsType(), this.getExtensibleStatementHelper());
        this.sailStore.init();
        this.namespaceStore.init();
    }

    public List<IsolationLevel> getSupportedIsolationLevels() {
        return Arrays.asList(IsolationLevels.NONE, IsolationLevels.READ_UNCOMMITTED, IsolationLevels.READ_COMMITTED);
    }

    public IsolationLevel getDefaultIsolationLevel() {
        return IsolationLevels.READ_COMMITTED;
    }

    public void setFederatedServiceResolver(FederatedServiceResolver resolver) {
        this.serviceResolver = resolver;
    }

    public ValueFactory getValueFactory() {
        return SimpleValueFactory.getInstance();
    }

    public synchronized EvaluationStrategyFactory getEvaluationStrategyFactory() {
        if (this.evalStratFactory == null) {
            this.evalStratFactory = new StrictEvaluationStrategyFactory(this.getFederatedServiceResolver());
        }
        this.evalStratFactory.setQuerySolutionCacheThreshold(this.getIterationCacheSyncThreshold());
        this.evalStratFactory.setTrackResultSize(this.isTrackResultSize());
        return this.evalStratFactory;
    }

    public synchronized FederatedServiceResolver getFederatedServiceResolver() {
        if (this.serviceResolver == null) {
            if (this.dependentServiceResolver == null) {
                this.dependentServiceResolver = new SPARQLServiceResolver();
            }
            this.setFederatedServiceResolver((FederatedServiceResolver)this.dependentServiceResolver);
        }
        return this.serviceResolver;
    }

    public void setEvaluationStrategyFactory(EvaluationStrategyFactory evalStratFactory) {
        this.evalStratFactory = evalStratFactory;
    }

    protected synchronized void shutDownInternal() throws SailException {
        this.sailStore.close();
        this.sailStore = null;
        this.dataStructure = null;
        this.namespaceStore = null;
    }

    public EvaluationStatisticsEnum getEvaluationStatisticsType() {
        return EvaluationStatisticsEnum.dynamic;
    }

    public ExtensibleStatementHelper getExtensibleStatementHelper() {
        return ExtensibleStatementHelper.getDefaultImpl();
    }

    public Supplier<CollectionFactory> getCollectionFactory() {
        return () -> new MapDb3CollectionFactory(this.getIterationCacheSyncThreshold());
    }

    public static enum Cache {
        NONE,
        LAZY,
        EAGER;

    }
}

