/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.extensiblestore;

import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.sail.InterruptedSailException;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.extensiblestore.DataStructureInterface;
import org.eclipse.rdf4j.sail.extensiblestore.FilteringIteration;
import org.eclipse.rdf4j.sail.extensiblestore.valuefactory.ExtensibleStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EagerReadCache
implements DataStructureInterface {
    private static final Logger logger = LoggerFactory.getLogger(EagerReadCache.class);
    private static final Runtime RUNTIME = Runtime.getRuntime();
    private static final long MIN_AVAILABLE_MEM = 0x2000000L;
    private static final int MIN_CACHE_SIZE = 100000;
    private final DataStructureInterface delegate;
    private volatile LinkedHashModel cache = null;
    private int lowMemCounter = 0;

    public EagerReadCache(DataStructureInterface delegate) {
        this.delegate = delegate;
    }

    @Override
    public void addStatement(ExtensibleStatement statement) {
        this.delegate.addStatement(statement);
        this.clearCache();
    }

    @Override
    public void removeStatement(ExtensibleStatement statement) {
        this.delegate.removeStatement(statement);
        this.clearCache();
    }

    @Override
    public CloseableIteration<? extends ExtensibleStatement> getStatements(Resource subject, IRI predicate, Value object, boolean inferred, Resource ... context) {
        LinkedHashModel cache = this.cache;
        if (cache == null) {
            if (subject != null && predicate != null && object != null) {
                return this.delegate.getStatements(subject, predicate, object, inferred, context);
            }
            cache = this.fillCache();
        }
        if (cache == null) {
            return this.delegate.getStatements(subject, predicate, object, inferred, context);
        }
        final Iterable statements = cache.getStatements(subject, predicate, object, context);
        return new FilteringIteration(new LookAheadIteration<ExtensibleStatement>(){
            final Iterator<Statement> iterator;
            {
                this.iterator = statements.iterator();
            }

            protected ExtensibleStatement getNextElement() throws SailException {
                if (this.iterator.hasNext()) {
                    Statement next = this.iterator.next();
                    return (ExtensibleStatement)((LinkedHashModel.ModelStatement)next).getStatement();
                }
                return null;
            }

            protected void handleClose() {
            }
        }, subject, predicate, object, inferred, context);
    }

    private synchronized Model fillCache() {
        LinkedHashModel cache = this.cache;
        if (cache != null) {
            return cache;
        }
        logger.debug("Filling cache");
        if (this.lowMemCounter > 100) {
            if (this.lowMemCounter++ % 100 == 0 && !this.isLowOnMemory()) {
                this.lowMemCounter = 0;
            } else {
                logger.debug("Canceled filling cache due to low memory");
                return null;
            }
        }
        cache = new LinkedHashModel();
        int i = 0;
        try (CloseableIteration<? extends ExtensibleStatement> statements = this.delegate.getStatements(null, null, null, true, new Resource[0]);){
            while (statements.hasNext()) {
                if (i++ > 100000 && i % 1000 == 0 && this.isLowOnMemory()) {
                    logger.debug("Canceled filling cache due to low memory");
                    ++this.lowMemCounter;
                    Model model = null;
                    return model;
                }
                cache.add((Statement)statements.next());
            }
        }
        statements = this.delegate.getStatements(null, null, null, false, new Resource[0]);
        try {
            while (statements.hasNext()) {
                if (i++ > 100000 && i % 1000 == 0 && this.isLowOnMemory()) {
                    logger.debug("Canceled filling cache due to low memory");
                    ++this.lowMemCounter;
                    Model model = null;
                    return model;
                }
                cache.add((Statement)statements.next());
            }
        }
        finally {
            if (statements != null) {
                statements.close();
            }
        }
        this.cache = cache;
        logger.debug("Cache filled");
        return cache;
    }

    private boolean isLowOnMemory() {
        if (EagerReadCache.getFreeToAllocateMemory() < 0x2000000L) {
            System.gc();
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new InterruptedSailException((Throwable)e);
            }
            System.gc();
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new InterruptedSailException((Throwable)e);
            }
            return EagerReadCache.getFreeToAllocateMemory() < 0x2000000L;
        }
        return false;
    }

    private static long getFreeToAllocateMemory() {
        long maxMemory = RUNTIME.maxMemory();
        long totalMemory = RUNTIME.totalMemory();
        long freeMemory = RUNTIME.freeMemory();
        long used = totalMemory - freeMemory;
        long freeToAllocateMemory = maxMemory - used;
        return freeToAllocateMemory;
    }

    @Override
    public void flushForReading() {
        this.delegate.flushForReading();
    }

    @Override
    public void init() {
        this.delegate.init();
    }

    @Override
    public void clear(boolean inferred, Resource[] contexts) {
        this.delegate.clear(inferred, contexts);
        this.clearCache();
    }

    @Override
    public void flushForCommit() {
        this.delegate.flushForCommit();
        this.clearCache();
    }

    @Override
    public boolean removeStatementsByQuery(Resource subj, IRI pred, Value obj, boolean inferred, Resource[] contexts) {
        boolean removed = this.delegate.removeStatementsByQuery(subj, pred, obj, inferred, contexts);
        this.clearCache();
        return removed;
    }

    public void clearCache() {
        if (this.cache != null) {
            logger.debug("Clearing cache");
        }
        this.cache = null;
    }

    @Override
    public long getEstimatedSize() {
        LinkedHashModel cache = this.cache;
        if (cache != null) {
            return cache.size();
        }
        return this.delegate.getEstimatedSize();
    }

    @Override
    public Comparator<Value> getComparator() {
        return null;
    }
}

