/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.extensiblestore;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.common.iteration.SingletonIteration;
import org.eclipse.rdf4j.common.order.StatementOrder;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.extensiblestore.DataStructureInterface;
import org.eclipse.rdf4j.sail.extensiblestore.valuefactory.ExtensibleStatement;
import org.eclipse.rdf4j.sail.extensiblestore.valuefactory.ExtensibleStatementHelper;

class ReadCommittedWrapper
implements DataStructureInterface {
    private final DataStructureInterface dataStructure;
    private Map<ExtensibleStatement, ExtensibleStatement> internalAdded = new HashMap<ExtensibleStatement, ExtensibleStatement>();
    private Map<ExtensibleStatement, ExtensibleStatement> internalRemoved = new HashMap<ExtensibleStatement, ExtensibleStatement>();

    ReadCommittedWrapper(DataStructureInterface dataStructure) {
        this.dataStructure = dataStructure;
    }

    @Override
    public void addStatement(ExtensibleStatement statement) {
        ExtensibleStatement put = this.internalAdded.put(statement, statement);
        if (put == null) {
            this.internalRemoved.remove(statement);
        }
    }

    @Override
    public void removeStatement(ExtensibleStatement statement) {
        ExtensibleStatement put = this.internalRemoved.put(statement, statement);
        if (put == null) {
            this.internalAdded.remove(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseableIteration<? extends ExtensibleStatement> getStatements(final Resource subject, final IRI predicate, final Value object, final boolean inferred, final Resource ... context) {
        if (subject != null && predicate != null && object != null && context != null && context.length == 1) {
            Statement statement = SimpleValueFactory.getInstance().createStatement(subject, predicate, object, context[0]);
            statement = ExtensibleStatementHelper.getDefaultImpl().fromStatement(statement, inferred);
            ExtensibleStatement extensibleStatement = this.internalAdded.get(statement);
            if (extensibleStatement != null) {
                return new SingletonIteration((Object)extensibleStatement);
            }
            if (this.internalRemoved.containsKey(statement)) {
                return new EmptyIteration();
            }
            DataStructureInterface dataStructureInterface = this.dataStructure;
            synchronized (dataStructureInterface) {
                return this.dataStructure.getStatements(subject, predicate, object, inferred, context);
            }
        }
        DataStructureInterface dataStructureInterface = this.dataStructure;
        synchronized (dataStructureInterface) {
            return new LookAheadIteration<ExtensibleStatement>(){
                final Set<ExtensibleStatement> internalAddedLocal;
                final Set<ExtensibleStatement> internalRemovedLocal;
                final Iterator<ExtensibleStatement> left;
                final CloseableIteration<? extends ExtensibleStatement> right;
                {
                    this.internalAddedLocal = new HashSet<ExtensibleStatement>(ReadCommittedWrapper.this.internalAdded.values());
                    this.internalRemovedLocal = new HashSet<ExtensibleStatement>(ReadCommittedWrapper.this.internalRemoved.values());
                    this.left = this.internalAddedLocal.stream().filter(statement -> {
                        if (subject != null && !statement.getSubject().equals(subject)) {
                            return false;
                        }
                        if (predicate != null && !statement.getPredicate().equals((Object)predicate)) {
                            return false;
                        }
                        if (object != null && !statement.getObject().equals(object)) {
                            return false;
                        }
                        if (context != null && context.length > 0 && !ReadCommittedWrapper.containsContext(context, statement.getContext())) {
                            return false;
                        }
                        return inferred || inferred == statement.isInferred();
                    }).iterator();
                    this.right = ReadCommittedWrapper.this.dataStructure.getStatements(subject, predicate, object, inferred, context);
                }

                protected void handleClose() throws SailException {
                    this.right.close();
                }

                protected ExtensibleStatement getNextElement() throws SailException {
                    ExtensibleStatement next = null;
                    do {
                        ExtensibleStatement tempNext = null;
                        if (this.left.hasNext()) {
                            tempNext = this.left.next();
                        } else if (this.right.hasNext()) {
                            tempNext = (ExtensibleStatement)this.right.next();
                            if (!this.internalAddedLocal.isEmpty() && this.internalAddedLocal.contains(tempNext)) {
                                tempNext = null;
                            }
                        }
                        if (tempNext == null || !this.internalRemovedLocal.isEmpty() && this.internalRemovedLocal.contains(tempNext)) continue;
                        next = tempNext;
                    } while (next == null && (this.left.hasNext() || this.right.hasNext()));
                    return next;
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseableIteration<? extends ExtensibleStatement> getStatements(final StatementOrder statementOrder, final Resource subject, final IRI predicate, final Value object, final boolean inferred, final Resource ... context) {
        if (subject != null && predicate != null && object != null && context != null && context.length == 1) {
            Statement statement = SimpleValueFactory.getInstance().createStatement(subject, predicate, object, context[0]);
            statement = ExtensibleStatementHelper.getDefaultImpl().fromStatement(statement, inferred);
            ExtensibleStatement extensibleStatement = this.internalAdded.get(statement);
            if (extensibleStatement != null) {
                return new SingletonIteration((Object)extensibleStatement);
            }
            if (this.internalRemoved.containsKey(statement)) {
                return new EmptyIteration();
            }
            DataStructureInterface dataStructureInterface = this.dataStructure;
            synchronized (dataStructureInterface) {
                return this.dataStructure.getStatements(statementOrder, subject, predicate, object, inferred, context);
            }
        }
        DataStructureInterface dataStructureInterface = this.dataStructure;
        synchronized (dataStructureInterface) {
            return new LookAheadIteration<ExtensibleStatement>(){
                Comparator<Statement> statementComparator;
                final TreeSet<ExtensibleStatement> internalAddedLocal;
                final Set<ExtensibleStatement> internalRemovedLocal;
                final Iterator<ExtensibleStatement> left;
                final CloseableIteration<? extends ExtensibleStatement> right;
                ExtensibleStatement nextLeft;
                ExtensibleStatement nextRight;
                {
                    this.statementComparator = statementOrder.getComparator(ReadCommittedWrapper.this.dataStructure.getComparator());
                    this.internalAddedLocal = new TreeSet<Statement>(this.statementComparator);
                    this.internalAddedLocal.addAll(ReadCommittedWrapper.this.internalAdded.values());
                    this.internalRemovedLocal = new HashSet<ExtensibleStatement>(ReadCommittedWrapper.this.internalRemoved.values());
                    this.left = this.internalAddedLocal.stream().filter(statement -> {
                        if (subject != null && !statement.getSubject().equals(subject)) {
                            return false;
                        }
                        if (predicate != null && !statement.getPredicate().equals((Object)predicate)) {
                            return false;
                        }
                        if (object != null && !statement.getObject().equals(object)) {
                            return false;
                        }
                        if (context != null && context.length > 0 && !ReadCommittedWrapper.containsContext(context, statement.getContext())) {
                            return false;
                        }
                        return inferred || inferred == statement.isInferred();
                    }).iterator();
                    this.right = ReadCommittedWrapper.this.dataStructure.getStatements(statementOrder, subject, predicate, object, inferred, context);
                    this.nextLeft = null;
                    this.nextRight = null;
                }

                protected void handleClose() throws SailException {
                    this.right.close();
                }

                protected ExtensibleStatement getNextElement() throws SailException {
                    ExtensibleStatement next = null;
                    do {
                        ExtensibleStatement tempNext = null;
                        if (this.nextLeft == null && this.left.hasNext()) {
                            this.nextLeft = this.left.next();
                        }
                        if (this.nextRight == null && this.right.hasNext()) {
                            this.nextRight = (ExtensibleStatement)this.right.next();
                        }
                        if (this.nextLeft != null && this.nextRight != null) {
                            int compare = this.statementComparator.compare(this.nextLeft, this.nextRight);
                            if (compare <= 0) {
                                tempNext = this.nextLeft;
                                this.nextLeft = null;
                            } else {
                                tempNext = this.nextRight;
                                this.nextRight = null;
                                if (!this.internalAddedLocal.isEmpty() && this.internalAddedLocal.contains(tempNext)) {
                                    tempNext = null;
                                }
                            }
                        } else if (this.nextLeft != null) {
                            tempNext = this.nextLeft;
                            this.nextLeft = null;
                        } else if (this.nextRight != null) {
                            tempNext = this.nextRight;
                            this.nextRight = null;
                            if (!this.internalAddedLocal.isEmpty() && this.internalAddedLocal.contains(tempNext)) {
                                tempNext = null;
                            }
                        }
                        if (tempNext == null || !this.internalRemovedLocal.isEmpty() && this.internalRemovedLocal.contains(tempNext)) continue;
                        next = tempNext;
                    } while (next == null && (this.left.hasNext() || this.right.hasNext()));
                    return next;
                }
            };
        }
    }

    private static boolean containsContext(Resource[] haystack, Resource needle) {
        for (Resource resource : haystack) {
            if (resource == null && needle == null) {
                return true;
            }
            if (resource == null || !resource.equals(needle)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushForCommit() {
        if (this.internalAdded.isEmpty() && this.internalRemoved.isEmpty()) {
            return;
        }
        List<ExtensibleStatement> internalAddedEffective = this.internalAdded.keySet().stream().filter(statement -> !this.internalRemoved.containsKey(statement)).collect(Collectors.toList());
        DataStructureInterface dataStructureInterface = this.dataStructure;
        synchronized (dataStructureInterface) {
            internalAddedEffective.forEach(this.dataStructure::addStatement);
            this.internalRemoved.values().forEach(this.dataStructure::removeStatement);
            this.dataStructure.flushForReading();
        }
        this.internalAdded = new HashMap<ExtensibleStatement, ExtensibleStatement>();
        this.internalRemoved = new HashMap<ExtensibleStatement, ExtensibleStatement>();
    }

    @Override
    public void flushForReading() {
    }

    @Override
    public Comparator<Value> getComparator() {
        return this.dataStructure.getComparator();
    }

    @Override
    public Set<StatementOrder> getSupportedOrders(Resource subj, IRI pred, Value obj, boolean inferred, Resource ... contexts) {
        return this.dataStructure.getSupportedOrders(subj, pred, obj, inferred, contexts);
    }

    @Override
    public void init() {
        this.dataStructure.init();
    }
}

