/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.extensiblestore;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.common.order.StatementOrder;
import org.eclipse.rdf4j.sail.extensiblestore.valuefactory.ExtensibleStatement;

@Experimental
public class SortedIteration<E extends ExtensibleStatement, X extends Exception>
extends LookAheadIteration<E> {
    private final CloseableIteration<E> wrappedIteration;
    private final StatementOrder statementOrder;
    private final Comparator<E> comparator;
    private boolean initialized;
    private Iterator<E> orderedIterator;

    public SortedIteration(CloseableIteration<E> wrappedIteration, StatementOrder statementOrder) {
        this.wrappedIteration = wrappedIteration;
        this.statementOrder = statementOrder;
        if (statementOrder.equals((Object)StatementOrder.S)) {
            this.comparator = Comparator.comparing(o -> o.getSubject().toString());
        } else if (statementOrder.equals((Object)StatementOrder.P)) {
            this.comparator = Comparator.comparing(o -> o.getPredicate().toString());
        } else if (statementOrder.equals((Object)StatementOrder.O)) {
            this.comparator = Comparator.comparing(o -> o.getObject().toString());
        } else if (statementOrder.equals((Object)StatementOrder.C)) {
            this.comparator = Comparator.comparing(o -> o.getContext().toString());
        } else {
            throw new IllegalArgumentException("Unknown StatementOrder: " + statementOrder);
        }
    }

    private void lazyInit() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        try (CloseableIteration<E> closeableIteration = this.wrappedIteration;){
            List list = Iterations.asList(this.wrappedIteration);
            list.sort(this.comparator);
            this.orderedIterator = list.iterator();
        }
    }

    protected E getNextElement() {
        this.lazyInit();
        if (this.orderedIterator == null) {
            throw new NoSuchElementException("Iteration has been closed");
        }
        if (this.orderedIterator.hasNext()) {
            return (E)((ExtensibleStatement)this.orderedIterator.next());
        }
        return null;
    }

    protected void handleClose() {
        this.wrappedIteration.close();
        this.orderedIterator = null;
    }
}

