/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.extensiblestore.evaluationstatistics;

import java.util.Collection;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.extensiblestore.DataStructureInterface;
import org.eclipse.rdf4j.sail.extensiblestore.evaluationstatistics.DynamicStatistics;
import org.eclipse.rdf4j.sail.extensiblestore.valuefactory.ExtensibleStatement;

@Experimental
public class EvaluationStatisticsWrapper
implements DataStructureInterface {
    private DynamicStatistics dynamicStatistics;
    private final DataStructureInterface delegate;

    public EvaluationStatisticsWrapper(DataStructureInterface delegate, DynamicStatistics dynamicStatistics) {
        this.delegate = delegate;
        this.dynamicStatistics = dynamicStatistics;
    }

    @Override
    public void addStatement(ExtensibleStatement statement) {
        this.delegate.addStatement(statement);
        this.dynamicStatistics.add(statement);
    }

    @Override
    public void removeStatement(ExtensibleStatement statement) {
        this.delegate.removeStatement(statement);
        this.dynamicStatistics.remove(statement);
    }

    @Override
    public CloseableIteration<? extends ExtensibleStatement> getStatements(Resource subject, IRI predicate, Value object, boolean inferred, Resource ... context) {
        return this.delegate.getStatements(subject, predicate, object, inferred, context);
    }

    @Override
    public void flushForReading() {
        this.delegate.flushForReading();
    }

    @Override
    public void init() {
        this.delegate.init();
    }

    @Override
    public void clear(boolean inferred, Resource[] contexts) {
        this.delegate.clear(inferred, contexts);
    }

    @Override
    public void flushForCommit() {
        this.delegate.flushForCommit();
    }

    @Override
    public boolean removeStatementsByQuery(Resource subj, IRI pred, Value obj, boolean inferred, Resource[] contexts) {
        this.dynamicStatistics.removeByQuery(subj, pred, obj, inferred, contexts);
        return this.delegate.removeStatementsByQuery(subj, pred, obj, inferred, contexts);
    }

    @Override
    public void addStatement(Collection<ExtensibleStatement> statements) {
        this.delegate.addStatement(statements);
        statements.forEach(this.dynamicStatistics::add);
    }

    @Override
    public void removeStatement(Collection<ExtensibleStatement> statements) {
        this.delegate.addStatement(statements);
        statements.forEach(this.dynamicStatistics::remove);
    }

    @Override
    public long getEstimatedSize() {
        return this.delegate.getEstimatedSize();
    }

    public void setEvaluationStatistics(DynamicStatistics dynamicStatistics) {
        this.dynamicStatistics = dynamicStatistics;
    }
}

