/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.extensiblestore;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.EvaluationStatistics;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.base.SailSource;
import org.eclipse.rdf4j.sail.base.SailStore;
import org.eclipse.rdf4j.sail.extensiblestore.DataStructureInterface;
import org.eclipse.rdf4j.sail.extensiblestore.ExtensibleSailSource;
import org.eclipse.rdf4j.sail.extensiblestore.NamespaceStoreInterface;
import org.eclipse.rdf4j.sail.extensiblestore.evaluationstatistics.DynamicStatistics;
import org.eclipse.rdf4j.sail.extensiblestore.evaluationstatistics.EvaluationStatisticsEnum;
import org.eclipse.rdf4j.sail.extensiblestore.evaluationstatistics.EvaluationStatisticsWrapper;
import org.eclipse.rdf4j.sail.extensiblestore.evaluationstatistics.ExtensibleEvaluationStatistics;
import org.eclipse.rdf4j.sail.extensiblestore.valuefactory.ExtensibleStatement;
import org.eclipse.rdf4j.sail.extensiblestore.valuefactory.ExtensibleStatementHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensibleSailStore
implements SailStore {
    private static final Logger logger = LoggerFactory.getLogger(ExtensibleSailStore.class);
    public static final int EVALUATION_STATISTICS_STALENESS_CHECK_INTERVAL = 60000;
    private final ExtensibleSailSource sailSource;
    private final ExtensibleSailSource sailSourceInferred;
    private final EvaluationStatisticsEnum evaluationStatisticsEnum;
    private ExtensibleEvaluationStatistics evaluationStatistics;
    private Thread evaluationStatisticsMaintainerThread;
    private final DataStructureInterface dataStructure;
    private volatile boolean closed;

    public ExtensibleSailStore(DataStructureInterface dataStructure, NamespaceStoreInterface namespaceStore, EvaluationStatisticsEnum evaluationStatisticsEnum, ExtensibleStatementHelper extensibleStatementHelper) {
        this.evaluationStatisticsEnum = evaluationStatisticsEnum;
        this.evaluationStatistics = evaluationStatisticsEnum.getInstance(this);
        if (this.evaluationStatistics instanceof DynamicStatistics) {
            dataStructure = new EvaluationStatisticsWrapper(dataStructure, (DynamicStatistics)((Object)this.evaluationStatistics));
            this.startEvaluationStatisticsMaintainerThread();
        }
        this.dataStructure = dataStructure;
        this.sailSource = new ExtensibleSailSource(dataStructure, namespaceStore, false, extensibleStatementHelper);
        this.sailSourceInferred = new ExtensibleSailSource(dataStructure, namespaceStore, true, extensibleStatementHelper);
    }

    private synchronized void startEvaluationStatisticsMaintainerThread() {
        if (!this.closed) {
            return;
        }
        this.evaluationStatisticsMaintainerThread = new Thread(new EvaluationStatisticsThread());
        this.evaluationStatisticsMaintainerThread.setDaemon(true);
        this.evaluationStatisticsMaintainerThread.start();
    }

    public synchronized void close() throws SailException {
        this.closed = true;
        if (this.evaluationStatisticsMaintainerThread != null) {
            this.evaluationStatisticsMaintainerThread.interrupt();
        }
        this.sailSource.close();
        this.sailSourceInferred.close();
    }

    public ValueFactory getValueFactory() {
        return SimpleValueFactory.getInstance();
    }

    public EvaluationStatistics getEvaluationStatistics() {
        return this.evaluationStatistics;
    }

    public SailSource getExplicitSailSource() {
        return this.sailSource;
    }

    public SailSource getInferredSailSource() {
        return this.sailSourceInferred;
    }

    public void init() {
        this.sailSource.init();
        this.sailSourceInferred.init();
    }

    private void startRecalculateStatistics() {
        logger.info("Recalculating stats: started");
        DynamicStatistics instance = (DynamicStatistics)((Object)this.evaluationStatisticsEnum.getInstance(this));
        this.addToStats(instance, this.dataStructure.getStatements(null, null, null, false, new Resource[0]));
        this.addToStats(instance, this.dataStructure.getStatements(null, null, null, true, new Resource[0]));
        ((EvaluationStatisticsWrapper)this.dataStructure).setEvaluationStatistics(instance);
        this.evaluationStatistics = (ExtensibleEvaluationStatistics)((Object)instance);
        logger.info("Recalculating stats: complete");
    }

    private void addToStats(DynamicStatistics instance, CloseableIteration<? extends ExtensibleStatement, SailException> statements) {
        long estimatedSize = this.dataStructure.getEstimatedSize();
        long counter = 0L;
        while (statements.hasNext()) {
            ExtensibleStatement next = (ExtensibleStatement)statements.next();
            instance.add(next);
            if (Thread.interrupted() || this.closed) {
                return;
            }
            if (++counter % 100000L != 0L) continue;
            logger.info("Recalculating stats: {}%", (Object)Math.round(100.0 / (double)estimatedSize * (double)counter));
        }
    }

    class EvaluationStatisticsThread
    implements Runnable {
        EvaluationStatisticsThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                double staleness;
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    if (!Thread.interrupted()) {
                        ExtensibleSailStore.this.startEvaluationStatisticsMaintainerThread();
                    }
                    return;
                }
                if (ExtensibleSailStore.this.closed) {
                    return;
                }
                long estimatedSize = ExtensibleSailStore.this.dataStructure.getEstimatedSize();
                if (estimatedSize > 1000L && (staleness = ((DynamicStatistics)((Object)ExtensibleSailStore.this.evaluationStatistics)).staleness(estimatedSize)) > 0.2) {
                    long formattedStaleness = Math.round(staleness * 100.0);
                    logger.info("Evaluation statistics is stale ({}%) and needs to be recalculated", (Object)formattedStaleness);
                    ExtensibleSailStore.this.startRecalculateStatistics();
                }
            }
            catch (Exception e) {
                if (!ExtensibleSailStore.this.closed && !Thread.interrupted()) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                if (!Thread.interrupted()) {
                    ExtensibleSailStore.this.startEvaluationStatisticsMaintainerThread();
                }
            }
        }
    }
}

