/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.extensiblestore;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.extensiblestore.DataStructureInterface;
import org.eclipse.rdf4j.sail.extensiblestore.PartialStatement;
import org.eclipse.rdf4j.sail.extensiblestore.valuefactory.ExtensibleStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadCache
implements DataStructureInterface {
    private static final Logger logger = LoggerFactory.getLogger(ReadCache.class);
    DataStructureInterface delegate;
    final int STATEMENTS_PER_CACHE_ITEM_LIMIT = 100000;
    Cache<PartialStatement, List<ExtensibleStatement>> cache = CacheBuilder.newBuilder().softValues().build();
    private volatile long cacheTicket = Long.MIN_VALUE;

    public ReadCache(DataStructureInterface delegate) {
        this.delegate = delegate;
    }

    @Override
    public void addStatement(ExtensibleStatement statement) {
        this.delegate.addStatement(statement);
        this.clearCache();
    }

    @Override
    public void removeStatement(ExtensibleStatement statement) {
        this.delegate.removeStatement(statement);
        this.clearCache();
    }

    @Override
    public CloseableIteration<? extends ExtensibleStatement, SailException> getStatements(final Resource subject, final IRI predicate, final Value object, final boolean inferred, final Resource ... context) {
        final PartialStatement partialStatement = new PartialStatement(subject, predicate, object, inferred, context);
        CloseableIteration<? extends ExtensibleStatement, SailException> cached = this.getCached(partialStatement);
        if (cached != null) {
            logger.trace("cache hit");
            return cached;
        }
        final long localCacheTicket = this.cacheTicket;
        return new CloseableIteration<ExtensibleStatement, SailException>(){
            final CloseableIteration<? extends ExtensibleStatement, SailException> statements;
            List<ExtensibleStatement> cache;
            {
                this.statements = ReadCache.this.delegate.getStatements(subject, predicate, object, inferred, context);
                this.cache = new ArrayList<ExtensibleStatement>();
            }

            public boolean hasNext() throws SailException {
                return this.statements.hasNext();
            }

            public ExtensibleStatement next() throws SailException {
                ExtensibleStatement next = (ExtensibleStatement)this.statements.next();
                if (this.cache != null) {
                    this.cache.add(next);
                    if (this.cache.size() > 100000) {
                        this.cache = null;
                        logger.trace("cache limit");
                    }
                }
                return next;
            }

            public void remove() throws SailException {
            }

            public void close() throws SailException {
                if (!this.statements.hasNext()) {
                    ReadCache.this.submitToCache(localCacheTicket, partialStatement, this.cache);
                } else {
                    logger.trace("iteration was not fully consumed before being closed and could not be cached");
                }
                this.statements.close();
            }
        };
    }

    private synchronized CloseableIteration<? extends ExtensibleStatement, SailException> getCached(PartialStatement partialStatement) {
        final List statements = (List)this.cache.getIfPresent((Object)partialStatement);
        if (statements != null) {
            return new LookAheadIteration<ExtensibleStatement, SailException>(){
                final Iterator<ExtensibleStatement> iterator;
                {
                    this.iterator = statements.iterator();
                }

                protected ExtensibleStatement getNextElement() throws SailException {
                    if (this.iterator.hasNext()) {
                        return this.iterator.next();
                    }
                    return null;
                }
            };
        }
        return null;
    }

    @Override
    public void flushForReading() {
        this.delegate.flushForReading();
    }

    @Override
    public void init() {
        this.delegate.init();
    }

    @Override
    public void clear(boolean inferred, Resource[] contexts) {
        this.delegate.clear(inferred, contexts);
        this.clearCache();
    }

    @Override
    public void flushForCommit() {
        this.delegate.flushForCommit();
        this.clearCache();
    }

    @Override
    public boolean removeStatementsByQuery(Resource subj, IRI pred, Value obj, boolean inferred, Resource[] contexts) {
        boolean removed = this.delegate.removeStatementsByQuery(subj, pred, obj, inferred, contexts);
        this.clearCache();
        return removed;
    }

    public synchronized void clearCache() {
        this.cache.invalidateAll();
        ++this.cacheTicket;
    }

    public synchronized void submitToCache(Long localCacheTicket, PartialStatement partialStatement, List<ExtensibleStatement> statements) {
        if (localCacheTicket == this.cacheTicket && statements != null) {
            this.cache.put((Object)partialStatement, statements);
        }
    }

    @Override
    public long getEstimatedSize() {
        return this.delegate.getEstimatedSize();
    }
}

