/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.extensiblestore;

import java.util.Collection;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.extensiblestore.valuefactory.ExtensibleStatement;

@Experimental
public interface DataStructureInterface {
    public void addStatement(ExtensibleStatement var1);

    public void removeStatement(ExtensibleStatement var1);

    default public void addStatement(Collection<ExtensibleStatement> statements) {
        for (ExtensibleStatement statement : statements) {
            this.addStatement(statement);
        }
    }

    default public void removeStatement(Collection<ExtensibleStatement> statements) {
        for (ExtensibleStatement statement : statements) {
            this.removeStatement(statement);
        }
    }

    public CloseableIteration<? extends ExtensibleStatement, SailException> getStatements(Resource var1, IRI var2, Value var3, boolean var4, Resource ... var5);

    public void flushForReading();

    public void init();

    default public void clear(boolean inferred, Resource[] contexts) {
        try (CloseableIteration<? extends ExtensibleStatement, SailException> statements = this.getStatements(null, null, null, inferred, contexts);){
            while (statements.hasNext()) {
                this.removeStatement((ExtensibleStatement)statements.next());
            }
        }
    }

    public void flushForCommit();

    default public boolean removeStatementsByQuery(Resource subj, IRI pred, Value obj, boolean inferred, Resource[] contexts) {
        boolean deleted = false;
        try (CloseableIteration<? extends ExtensibleStatement, SailException> statements = this.getStatements(subj, pred, obj, inferred, contexts);){
            while (statements.hasNext()) {
                this.removeStatement((ExtensibleStatement)statements.next());
                deleted = true;
            }
        }
        return deleted;
    }

    default public long getEstimatedSize() {
        long inferred = this.getStatements(null, null, null, true, new Resource[0]).stream().count();
        long explicit = this.getStatements(null, null, null, false, new Resource[0]).stream().count();
        return inferred + explicit;
    }
}

