/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.extensiblestore;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategyFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolverClient;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.StrictEvaluationStrategyFactory;
import org.eclipse.rdf4j.repository.sparql.federation.SPARQLServiceResolver;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.extensiblestore.DataStructureInterface;
import org.eclipse.rdf4j.sail.extensiblestore.ExtensibleSailStore;
import org.eclipse.rdf4j.sail.extensiblestore.NamespaceStoreInterface;
import org.eclipse.rdf4j.sail.extensiblestore.ReadCache;
import org.eclipse.rdf4j.sail.extensiblestore.evaluationstatistics.EvaluationStatisticsEnum;
import org.eclipse.rdf4j.sail.extensiblestore.valuefactory.ExtensibleStatementHelper;
import org.eclipse.rdf4j.sail.helpers.AbstractNotifyingSail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public abstract class ExtensibleStore<T extends DataStructureInterface, N extends NamespaceStoreInterface>
extends AbstractNotifyingSail
implements FederatedServiceResolverClient {
    private static final Logger logger = LoggerFactory.getLogger(ExtensibleStore.class);
    protected ExtensibleSailStore sailStore;
    protected N namespaceStore;
    protected T dataStructure;
    final boolean cacheEnabled;
    private EvaluationStrategyFactory evalStratFactory;
    private SPARQLServiceResolver dependentServiceResolver;
    private FederatedServiceResolver serviceResolver;

    public ExtensibleStore() {
        this(true);
    }

    public ExtensibleStore(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }

    ExtensibleSailStore getSailStore() {
        return this.sailStore;
    }

    protected synchronized void initializeInternal() throws SailException {
        if (this.sailStore != null) {
            this.sailStore.close();
        }
        DataStructureInterface dataStructure = (DataStructureInterface)Objects.requireNonNull(this.dataStructure);
        if (this.cacheEnabled) {
            dataStructure = new ReadCache(dataStructure);
        }
        this.sailStore = new ExtensibleSailStore(dataStructure, (NamespaceStoreInterface)Objects.requireNonNull(this.namespaceStore), this.getEvaluationStatisticsType(), this.getExtensibleStatementHelper());
        this.sailStore.init();
        this.namespaceStore.init();
    }

    public List<IsolationLevel> getSupportedIsolationLevels() {
        return Arrays.asList(IsolationLevels.NONE, IsolationLevels.READ_UNCOMMITTED, IsolationLevels.READ_COMMITTED);
    }

    public IsolationLevel getDefaultIsolationLevel() {
        return IsolationLevels.READ_COMMITTED;
    }

    public void setFederatedServiceResolver(FederatedServiceResolver resolver) {
        this.serviceResolver = resolver;
    }

    public ValueFactory getValueFactory() {
        return SimpleValueFactory.getInstance();
    }

    public synchronized EvaluationStrategyFactory getEvaluationStrategyFactory() {
        if (this.evalStratFactory == null) {
            this.evalStratFactory = new StrictEvaluationStrategyFactory(this.getFederatedServiceResolver());
        }
        this.evalStratFactory.setQuerySolutionCacheThreshold(this.getIterationCacheSyncThreshold());
        this.evalStratFactory.setTrackResultSize(this.isTrackResultSize());
        return this.evalStratFactory;
    }

    public synchronized FederatedServiceResolver getFederatedServiceResolver() {
        if (this.serviceResolver == null) {
            if (this.dependentServiceResolver == null) {
                this.dependentServiceResolver = new SPARQLServiceResolver();
            }
            this.setFederatedServiceResolver((FederatedServiceResolver)this.dependentServiceResolver);
        }
        return this.serviceResolver;
    }

    public void setEvaluationStrategyFactory(EvaluationStrategyFactory evalStratFactory) {
        this.evalStratFactory = evalStratFactory;
    }

    protected synchronized void shutDownInternal() throws SailException {
        this.sailStore.close();
        this.sailStore = null;
        this.dataStructure = null;
        this.namespaceStore = null;
    }

    public EvaluationStatisticsEnum getEvaluationStatisticsType() {
        return EvaluationStatisticsEnum.dynamic;
    }

    public ExtensibleStatementHelper getExtensibleStatementHelper() {
        return ExtensibleStatementHelper.getDefaultImpl();
    }
}

