/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.extensiblestore.evaluationstatistics;

import java.util.stream.Stream;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.EvaluationStatistics;
import org.eclipse.rdf4j.sail.base.SailDataset;
import org.eclipse.rdf4j.sail.extensiblestore.ExtensibleSailStore;
import org.eclipse.rdf4j.sail.extensiblestore.evaluationstatistics.ExtensibleEvaluationStatistics;

@Experimental
public class ExtensibleDirectEvaluationStatistics
extends ExtensibleEvaluationStatistics {
    EvaluationStatistics.CardinalityCalculator cardinalityCalculator = new EvaluationStatistics.CardinalityCalculator(){

        protected double getCardinality(StatementPattern sp) {
            SailDataset dataset = ExtensibleDirectEvaluationStatistics.this.extensibleSailStore.getExplicitSailSource().dataset((IsolationLevel)IsolationLevels.NONE);
            Resource subject = (Resource)sp.getSubjectVar().getValue();
            IRI predicate = (IRI)sp.getPredicateVar().getValue();
            Value object = sp.getObjectVar().getValue();
            if (sp.getScope() == StatementPattern.Scope.DEFAULT_CONTEXTS) {
                try (Stream stream = Iterations.stream((Iteration)dataset.getStatements(subject, predicate, object, new Resource[0]));){
                    double d = stream.count();
                    return d;
                }
            }
            Resource[] context = new Resource[]{(Resource)sp.getContextVar().getValue()};
            try (Stream stream = Iterations.stream((Iteration)dataset.getStatements(subject, predicate, object, context));){
                double d = stream.count();
                return d;
            }
        }
    };

    public ExtensibleDirectEvaluationStatistics(ExtensibleSailStore extensibleSailStore) {
        super(extensibleSailStore);
    }

    @Override
    protected EvaluationStatistics.CardinalityCalculator createCardinalityCalculator() {
        return this.cardinalityCalculator;
    }
}

