/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.extensiblestore.evaluationstatistics;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.apache.druid.hll.HyperLogLogCollector;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.EvaluationStatistics;
import org.eclipse.rdf4j.sail.extensiblestore.ExtensibleSailStore;
import org.eclipse.rdf4j.sail.extensiblestore.evaluationstatistics.DynamicStatistics;
import org.eclipse.rdf4j.sail.extensiblestore.evaluationstatistics.ExtensibleEvaluationStatistics;
import org.eclipse.rdf4j.sail.extensiblestore.valuefactory.ExtensibleStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class ExtensibleDynamicEvaluationStatistics
extends ExtensibleEvaluationStatistics
implements DynamicStatistics {
    private static final Logger logger = LoggerFactory.getLogger(ExtensibleDynamicEvaluationStatistics.class);
    private static final int QUEUE_LIMIT = 128;
    private static final int SINGLE_DIMENSION_INDEX_SIZE = 1024;
    ConcurrentLinkedQueue<StatementQueueItem> queue = new ConcurrentLinkedQueue();
    AtomicInteger queueSize = new AtomicInteger();
    private final HashFunction HASH_FUNCTION = Hashing.murmur3_128();
    private final HyperLogLogCollector EMPTY_HLL = HyperLogLogCollector.makeLatestCollector();
    private final HyperLogLogCollector size = HyperLogLogCollector.makeLatestCollector();
    private final HyperLogLogCollector size_removed = HyperLogLogCollector.makeLatestCollector();
    private final Map<Integer, HyperLogLogCollector> subjectIndex = new HashMap<Integer, HyperLogLogCollector>();
    private final Map<Integer, HyperLogLogCollector> predicateIndex = new HashMap<Integer, HyperLogLogCollector>();
    private final Map<Integer, HyperLogLogCollector> objectIndex = new HashMap<Integer, HyperLogLogCollector>();
    private final Map<Integer, HyperLogLogCollector> contextIndex = new HashMap<Integer, HyperLogLogCollector>();
    private final HyperLogLogCollector defaultContext = HyperLogLogCollector.makeLatestCollector();
    private final HyperLogLogCollector[][] subjectPredicateIndex = new HyperLogLogCollector[64][64];
    private final HyperLogLogCollector[][] predicateObjectIndex = new HyperLogLogCollector[64][64];
    private final Map<Integer, HyperLogLogCollector> subjectIndex_removed = new HashMap<Integer, HyperLogLogCollector>();
    private final Map<Integer, HyperLogLogCollector> predicateIndex_removed = new HashMap<Integer, HyperLogLogCollector>();
    private final Map<Integer, HyperLogLogCollector> objectIndex_removed = new HashMap<Integer, HyperLogLogCollector>();
    private final Map<Integer, HyperLogLogCollector> contextIndex_removed = new HashMap<Integer, HyperLogLogCollector>();
    private final HyperLogLogCollector defaultContext_removed = HyperLogLogCollector.makeLatestCollector();
    private final HyperLogLogCollector[][] subjectPredicateIndex_removed = new HyperLogLogCollector[64][64];
    private final HyperLogLogCollector[][] predicateObjectIndex_removed = new HyperLogLogCollector[64][64];
    private volatile Thread queueConsumingThread;

    public ExtensibleDynamicEvaluationStatistics(ExtensibleSailStore extensibleSailStore) {
        super(extensibleSailStore);
        Stream.of(new HyperLogLogCollector[][][]{this.subjectPredicateIndex, this.predicateObjectIndex, this.subjectPredicateIndex_removed, this.predicateObjectIndex_removed}).forEach(index -> {
            for (int i = 0; i < ((HyperLogLogCollector[][])index).length; ++i) {
                for (int j = 0; j < index[i].length; ++j) {
                    index[i][j] = HyperLogLogCollector.makeLatestCollector();
                }
            }
        });
    }

    @Override
    protected EvaluationStatistics.CardinalityCalculator createCardinalityCalculator() {
        return new ExtensibleDynamicEvaluationStatisticsCardinalityCalculator();
    }

    @Override
    public synchronized double staleness(long actualSize) {
        double estimatedSize = this.size.estimateCardinality() - this.size_removed.estimateCardinality();
        double diff = Math.abs(estimatedSize - (double)actualSize);
        double staleness = 1.0 / Math.max(estimatedSize, (double)actualSize) * diff;
        logger.debug("Actual size: {}; estimated size: {}; staleness: {}", new Object[]{actualSize, estimatedSize, staleness});
        return staleness;
    }

    private double getHllCardinality(HyperLogLogCollector[][] index, HyperLogLogCollector[][] index_removed, Value value1, Value value2) {
        int value1IndexIntoAdded = Math.abs(value1.hashCode() % index.length);
        int value2IndexIntoAdded = Math.abs(value2.hashCode() % index.length);
        double cardinalityAdded = index[value1IndexIntoAdded][value2IndexIntoAdded].estimateCardinality();
        int value1IndexIntoRemoved = Math.abs(value1.hashCode() % index_removed.length);
        int value2IndexIntoRemoved = Math.abs(value2.hashCode() % index_removed.length);
        double removedStatements = index_removed[value1IndexIntoRemoved][value2IndexIntoRemoved].estimateCardinality();
        return cardinalityAdded - removedStatements;
    }

    private double getHllCardinality(Map<Integer, HyperLogLogCollector> index, Map<Integer, HyperLogLogCollector> index_removed, Value value) {
        int indexIntoMap = Math.abs(value.hashCode() % 1024);
        double cardinalityAdded = index.getOrDefault(indexIntoMap, this.EMPTY_HLL).estimateCardinality();
        double cardinalityRemoved = index_removed.getOrDefault(indexIntoMap, this.EMPTY_HLL).estimateCardinality();
        return cardinalityAdded - cardinalityRemoved;
    }

    @Override
    public void add(ExtensibleStatement statement) {
        this.queue.add(new StatementQueueItem(statement, StatementQueueItem.Type.added));
        int size = this.queueSize.incrementAndGet();
        if (size > 128 && this.queueConsumingThread == null) {
            this.startQueueConsumingThread();
        }
    }

    private synchronized void startQueueConsumingThread() {
        if (this.queueConsumingThread == null) {
            this.queueConsumingThread = new Thread(() -> {
                block10: {
                    block5: while (true) {
                        while (!this.queue.isEmpty()) {
                            StatementQueueItem poll = this.queue.poll();
                            this.queueSize.decrementAndGet();
                            ExtensibleStatement statement = poll.statement;
                            byte[] statementHash = this.HASH_FUNCTION.hashString((CharSequence)statement.toString(), StandardCharsets.UTF_8).asBytes();
                            if (poll.type == StatementQueueItem.Type.added) {
                                this.handleStatement(statement, statementHash, this.size, this.subjectIndex, this.predicateIndex, this.objectIndex, this.subjectPredicateIndex, this.predicateObjectIndex, this.defaultContext, this.contextIndex);
                            } else {
                                assert (poll.type == StatementQueueItem.Type.removed);
                                this.handleStatement(statement, statementHash, this.size_removed, this.subjectIndex_removed, this.predicateIndex_removed, this.objectIndex_removed, this.subjectPredicateIndex_removed, this.predicateObjectIndex_removed, this.defaultContext_removed, this.contextIndex_removed);
                            }
                            if (!this.queue.isEmpty()) continue;
                            try {
                                Thread.sleep(2L);
                                continue block5;
                            }
                            catch (InterruptedException interruptedException) {
                            }
                        }
                        break block10;
                        {
                            continue block5;
                            break;
                        }
                        break;
                    }
                    finally {
                        this.queueConsumingThread = null;
                    }
                }
            });
            this.queueConsumingThread.setDaemon(true);
            this.queueConsumingThread.start();
        }
    }

    private synchronized void handleStatement(Statement statement, byte[] statementHash, HyperLogLogCollector size, Map<Integer, HyperLogLogCollector> subjectIndex, Map<Integer, HyperLogLogCollector> predicateIndex, Map<Integer, HyperLogLogCollector> objectIndex, HyperLogLogCollector[][] subjectPredicateIndex, HyperLogLogCollector[][] predicateObjectIndex, HyperLogLogCollector defaultContext, Map<Integer, HyperLogLogCollector> contextIndex) {
        size.add(statementHash);
        int subjectHash = statement.getSubject().hashCode();
        int predicateHash = statement.getPredicate().hashCode();
        int objectHash = statement.getObject().hashCode();
        this.indexOneValue(statementHash, subjectIndex, subjectHash);
        this.indexOneValue(statementHash, predicateIndex, predicateHash);
        this.indexOneValue(statementHash, objectIndex, objectHash);
        this.indexTwoValues(statementHash, subjectPredicateIndex, subjectHash, predicateHash);
        this.indexTwoValues(statementHash, predicateObjectIndex, predicateHash, objectHash);
        if (statement.getContext() == null) {
            defaultContext.add(statementHash);
        } else {
            this.indexOneValue(statementHash, contextIndex, statement.getContext().hashCode());
        }
    }

    private void indexTwoValues(byte[] statementHash, HyperLogLogCollector[][] index, int indexHash, int indexHash2) {
        index[Math.abs(indexHash % index.length)][Math.abs(indexHash2 % index.length)].add(statementHash);
    }

    private void indexOneValue(byte[] statementHash, Map<Integer, HyperLogLogCollector> index, int indexHash) {
        index.compute(Math.abs(indexHash % 1024), (key, val) -> {
            if (val == null) {
                val = HyperLogLogCollector.makeLatestCollector();
            }
            val.add(statementHash);
            return val;
        });
    }

    @Override
    public void remove(ExtensibleStatement statement) {
        this.queue.add(new StatementQueueItem(statement, StatementQueueItem.Type.removed));
        int size = this.queueSize.incrementAndGet();
        if (size > 128 && this.queueConsumingThread == null) {
            this.startQueueConsumingThread();
        }
    }

    @Override
    public void removeByQuery(Resource subj, IRI pred, Value obj, boolean inferred, Resource ... contexts) {
    }

    public void waitForQueue() throws InterruptedException {
        while (this.queueConsumingThread != null) {
            try {
                this.queueConsumingThread.join();
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    static class StatementQueueItem {
        ExtensibleStatement statement;
        Type type;

        public StatementQueueItem(ExtensibleStatement statement, Type type) {
            this.statement = statement;
            this.type = type;
        }

        static enum Type {
            added,
            removed;

        }
    }

    class ExtensibleDynamicEvaluationStatisticsCardinalityCalculator
    extends EvaluationStatistics.CardinalityCalculator {
        ExtensibleDynamicEvaluationStatisticsCardinalityCalculator() {
        }

        protected synchronized double getCardinality(StatementPattern sp) {
            double min = ExtensibleDynamicEvaluationStatistics.this.size.estimateCardinality() - ExtensibleDynamicEvaluationStatistics.this.size_removed.estimateCardinality();
            min = Math.min(min, this.getSubjectCardinality(sp.getSubjectVar()));
            min = Math.min(min, this.getPredicateCardinality(sp.getPredicateVar()));
            if ((min = Math.min(min, this.getObjectCardinality(sp.getObjectVar()))) < 2.0) {
                return min;
            }
            if (sp.getSubjectVar().getValue() != null && sp.getPredicateVar().getValue() != null) {
                min = Math.min(min, ExtensibleDynamicEvaluationStatistics.this.getHllCardinality(ExtensibleDynamicEvaluationStatistics.this.subjectPredicateIndex, ExtensibleDynamicEvaluationStatistics.this.subjectPredicateIndex_removed, sp.getSubjectVar().getValue(), sp.getPredicateVar().getValue()));
            }
            if (sp.getPredicateVar().getValue() != null && sp.getObjectVar().getValue() != null) {
                min = Math.min(min, ExtensibleDynamicEvaluationStatistics.this.getHllCardinality(ExtensibleDynamicEvaluationStatistics.this.predicateObjectIndex, ExtensibleDynamicEvaluationStatistics.this.predicateObjectIndex_removed, sp.getPredicateVar().getValue(), sp.getObjectVar().getValue()));
            }
            return min;
        }

        protected synchronized double getSubjectCardinality(Var var) {
            if (var.getValue() == null) {
                return ExtensibleDynamicEvaluationStatistics.this.size.estimateCardinality();
            }
            return ExtensibleDynamicEvaluationStatistics.this.getHllCardinality(ExtensibleDynamicEvaluationStatistics.this.subjectIndex, ExtensibleDynamicEvaluationStatistics.this.subjectIndex_removed, var.getValue());
        }

        protected synchronized double getPredicateCardinality(Var var) {
            if (var.getValue() == null) {
                return ExtensibleDynamicEvaluationStatistics.this.size.estimateCardinality();
            }
            return ExtensibleDynamicEvaluationStatistics.this.getHllCardinality(ExtensibleDynamicEvaluationStatistics.this.predicateIndex, ExtensibleDynamicEvaluationStatistics.this.predicateIndex_removed, var.getValue());
        }

        protected synchronized double getObjectCardinality(Var var) {
            if (var.getValue() == null) {
                return ExtensibleDynamicEvaluationStatistics.this.size.estimateCardinality();
            }
            return ExtensibleDynamicEvaluationStatistics.this.getHllCardinality(ExtensibleDynamicEvaluationStatistics.this.objectIndex, ExtensibleDynamicEvaluationStatistics.this.objectIndex_removed, var.getValue());
        }

        protected synchronized double getContextCardinality(Var var) {
            if (var.getValue() == null) {
                return ExtensibleDynamicEvaluationStatistics.this.defaultContext.estimateCardinality() - ExtensibleDynamicEvaluationStatistics.this.defaultContext_removed.estimateCardinality();
            }
            return ExtensibleDynamicEvaluationStatistics.this.getHllCardinality(ExtensibleDynamicEvaluationStatistics.this.contextIndex, ExtensibleDynamicEvaluationStatistics.this.contextIndex_removed, var.getValue());
        }
    }
}

