/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.extensiblestore;

import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;

@Experimental
public class FilteringIteration<E extends Statement, X extends Exception>
extends LookAheadIteration<E, X> {
    final Iteration<E, X> wrappedIteration;
    CloseableIteration<E, X> closeableWrappedIteration;
    Resource subject;
    IRI predicate;
    Value object;
    Resource[] context;

    public FilteringIteration(CloseableIteration<E, X> wrappedIteration, Resource subject, IRI predicate, Value object, Resource ... context) {
        this.wrappedIteration = wrappedIteration;
        this.closeableWrappedIteration = wrappedIteration;
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
        this.context = context;
    }

    public FilteringIteration(Iteration<E, X> wrappedIteration, Resource subject, IRI predicate, Value object, Resource ... context) {
        this.wrappedIteration = wrappedIteration;
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
        this.context = context;
    }

    protected E getNextElement() throws X {
        while (this.wrappedIteration.hasNext()) {
            Statement next = (Statement)this.wrappedIteration.next();
            if (this.subject != null && !next.getSubject().equals(this.subject) || this.predicate != null && !next.getPredicate().equals((Object)this.predicate) || this.object != null && !next.getObject().equals(this.object) || this.context != null && this.context.length > 0 && !FilteringIteration.containsContext(this.context, next.getContext())) continue;
            return (E)next;
        }
        return null;
    }

    protected void handleClose() throws X {
        super.handleClose();
        if (this.closeableWrappedIteration != null) {
            assert (this.closeableWrappedIteration == this.closeableWrappedIteration);
            this.closeableWrappedIteration.close();
        }
    }

    private static boolean containsContext(Resource[] haystack, Resource needle) {
        for (Resource resource : haystack) {
            if (resource == null && needle == null) {
                return true;
            }
            if (resource == null || !resource.equals(needle)) continue;
            return true;
        }
        return false;
    }
}

