/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.extensiblestore;

import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.SailChangedEvent;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.base.SailSourceConnection;
import org.eclipse.rdf4j.sail.base.SailStore;
import org.eclipse.rdf4j.sail.extensiblestore.ExtensibleStore;
import org.eclipse.rdf4j.sail.helpers.DefaultSailChangedEvent;

@Experimental
public class ExtensibleStoreConnection<E extends ExtensibleStore>
extends SailSourceConnection {
    protected final E sail;
    private volatile DefaultSailChangedEvent sailChangedEvent;

    protected ExtensibleStoreConnection(E sail) {
        super(sail, (SailStore)((ExtensibleStore)((Object)sail)).getSailStore(), ((ExtensibleStore)((Object)sail)).getEvaluationStrategyFactory());
        this.sail = sail;
        this.sailChangedEvent = new DefaultSailChangedEvent(sail);
    }

    public E getSail() {
        return this.sail;
    }

    protected void startTransactionInternal() throws SailException {
        super.startTransactionInternal();
    }

    protected void commitInternal() throws SailException {
        super.commitInternal();
        this.sail.notifySailChanged((SailChangedEvent)this.sailChangedEvent);
        this.sailChangedEvent = new DefaultSailChangedEvent(this.sail);
    }

    protected void rollbackInternal() throws SailException {
        super.rollbackInternal();
        this.sailChangedEvent = new DefaultSailChangedEvent(this.sail);
    }

    protected void addStatementInternal(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        this.sailChangedEvent.setStatementsAdded(true);
    }

    public boolean addInferredStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        boolean ret = super.addInferredStatement(subj, pred, obj, contexts);
        this.sailChangedEvent.setStatementsAdded(true);
        return ret;
    }

    protected void removeStatementsInternal(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        this.sailChangedEvent.setStatementsRemoved(true);
    }

    public boolean removeInferredStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        boolean ret = super.removeInferredStatement(subj, pred, obj, contexts);
        this.sailChangedEvent.setStatementsRemoved(true);
        return ret;
    }

    protected void clearInternal(Resource ... contexts) throws SailException {
        super.clearInternal(contexts);
        this.sailChangedEvent.setStatementsRemoved(true);
    }

    public void clearInferred(Resource ... contexts) throws SailException {
        super.clearInferred(contexts);
        this.sailChangedEvent.setStatementsRemoved(true);
    }
}

