/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.extensiblestore;

import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.EvaluationStatistics;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.base.SailSource;
import org.eclipse.rdf4j.sail.base.SailStore;
import org.eclipse.rdf4j.sail.extensiblestore.DataStructureInterface;
import org.eclipse.rdf4j.sail.extensiblestore.ExtensibleSailSource;
import org.eclipse.rdf4j.sail.extensiblestore.NamespaceStoreInterface;

class ExtensibleSailStore
implements SailStore {
    private ExtensibleSailSource sailSource;
    private ExtensibleSailSource sailSourceInferred;

    public ExtensibleSailStore(DataStructureInterface dataStructure, DataStructureInterface dataStructureInferred, NamespaceStoreInterface namespaceStore) {
        this.sailSource = new ExtensibleSailSource(dataStructure, namespaceStore);
        this.sailSourceInferred = new ExtensibleSailSource(dataStructureInferred, namespaceStore);
    }

    public void close() throws SailException {
        this.sailSource.close();
        this.sailSourceInferred.close();
    }

    public ValueFactory getValueFactory() {
        return SimpleValueFactory.getInstance();
    }

    public EvaluationStatistics getEvaluationStatistics() {
        return new EvaluationStatistics(){};
    }

    public SailSource getExplicitSailSource() {
        return this.sailSource;
    }

    public SailSource getInferredSailSource() {
        return this.sailSourceInferred;
    }

    public void init() {
        this.sailSource.init();
        this.sailSourceInferred.init();
    }
}

