/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.extensiblestore;

import java.util.Collection;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.SailException;

@Experimental
public interface DataStructureInterface {
    public void addStatement(Statement var1);

    public void removeStatement(Statement var1);

    default public void addStatement(Collection<Statement> statements) {
        for (Statement statement : statements) {
            this.addStatement(statement);
        }
    }

    default public void removeStatement(Collection<Statement> statements) {
        for (Statement statement : statements) {
            this.removeStatement(statement);
        }
    }

    public CloseableIteration<? extends Statement, SailException> getStatements(Resource var1, IRI var2, Value var3, Resource ... var4);

    public void flushForReading();

    public void init();

    default public void clear(Resource[] contexts) {
        try (CloseableIteration<? extends Statement, SailException> statements = this.getStatements(null, null, null, contexts);){
            while (statements.hasNext()) {
                this.removeStatement((Statement)statements.next());
            }
        }
    }

    public void flushForCommit();

    default public boolean removeStatementsByQuery(Resource subj, IRI pred, Value obj, Resource[] contexts) {
        boolean deleted = false;
        try (CloseableIteration<? extends Statement, SailException> statements = this.getStatements(subj, pred, obj, contexts);){
            while (statements.hasNext()) {
                this.removeStatement((Statement)statements.next());
                deleted = true;
            }
        }
        return deleted;
    }
}

