/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.extensiblestore;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.common.iteration.SingletonIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.extensiblestore.DataStructureInterface;

class ReadCommittedWrapper
implements DataStructureInterface {
    private DataStructureInterface dataStructure;
    private Set<Statement> internalAdded = new HashSet<Statement>(1000);
    private Set<Statement> internalRemoved = new HashSet<Statement>(100);

    ReadCommittedWrapper(DataStructureInterface dataStructure) {
        this.dataStructure = dataStructure;
    }

    @Override
    public void addStatement(Statement statement) {
        this.internalAdded.add(statement);
        this.internalRemoved.remove(statement);
    }

    @Override
    public void removeStatement(Statement statement) {
        this.internalRemoved.add(statement);
    }

    @Override
    public CloseableIteration<? extends Statement, SailException> getStatements(final Resource subject, final IRI predicate, final Value object, final Resource ... context) {
        if (subject != null && predicate != null && object != null && context != null && context.length == 1) {
            Statement statement = SimpleValueFactory.getInstance().createStatement(subject, predicate, object, context[0]);
            if (this.internalAdded.contains(statement)) {
                return new SingletonIteration((Object)statement);
            }
            if (this.internalRemoved.contains(statement)) {
                return new EmptyIteration();
            }
            return this.dataStructure.getStatements(subject, predicate, object, context);
        }
        return new LookAheadIteration<Statement, SailException>(){
            Set<Statement> internalAddedLocal;
            Set<Statement> internalRemovedLocal;
            Iterator<Statement> left;
            CloseableIteration<? extends Statement, SailException> right;
            {
                this.internalAddedLocal = new HashSet<Statement>(ReadCommittedWrapper.this.internalAdded);
                this.internalRemovedLocal = new HashSet<Statement>(ReadCommittedWrapper.this.internalRemoved);
                this.left = this.internalAddedLocal.stream().filter(statement -> {
                    if (subject != null && !statement.getSubject().equals(subject)) {
                        return false;
                    }
                    if (predicate != null && !statement.getPredicate().equals((Object)predicate)) {
                        return false;
                    }
                    if (object != null && !statement.getObject().equals(object)) {
                        return false;
                    }
                    return context == null || context.length <= 0 || ReadCommittedWrapper.containsContext(context, statement.getContext());
                }).iterator();
                this.right = ReadCommittedWrapper.this.dataStructure.getStatements(subject, predicate, object, context);
            }

            protected void handleClose() throws SailException {
                super.handleClose();
                this.right.close();
            }

            protected Statement getNextElement() throws SailException {
                Statement next = null;
                do {
                    Statement tempNext = null;
                    if (this.left.hasNext()) {
                        tempNext = this.left.next();
                    } else if (this.right.hasNext()) {
                        tempNext = (Statement)this.right.next();
                        if (!this.internalAddedLocal.isEmpty() && this.internalAddedLocal.contains(tempNext)) {
                            tempNext = null;
                        }
                    }
                    if (tempNext == null || !this.internalRemovedLocal.isEmpty() && this.internalRemovedLocal.contains(tempNext)) continue;
                    next = tempNext;
                } while (next == null && (this.left.hasNext() || this.right.hasNext()));
                return next;
            }
        };
    }

    private static boolean containsContext(Resource[] haystack, Resource needle) {
        for (Resource resource : haystack) {
            if (resource == null && needle == null) {
                return true;
            }
            if (resource == null || !resource.equals(needle)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void flushForCommit() {
        this.internalAdded.stream().filter(statement -> !this.internalRemoved.contains(statement)).forEach(statement -> this.dataStructure.addStatement((Statement)statement));
        this.internalRemoved.forEach(statement -> this.dataStructure.removeStatement((Statement)statement));
        this.internalAdded = new HashSet<Statement>(this.internalAdded.size());
        this.internalRemoved = new HashSet<Statement>(this.internalRemoved.size());
        this.dataStructure.flushForReading();
    }

    @Override
    public void flushForReading() {
    }

    @Override
    public void init() {
        this.dataStructure.init();
    }
}

