/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.extensiblestore;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.map.ReferenceMap;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.extensiblestore.DataStructureInterface;
import org.eclipse.rdf4j.sail.extensiblestore.PartialStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadCache
implements DataStructureInterface {
    private static final Logger logger = LoggerFactory.getLogger(ReadCache.class);
    DataStructureInterface delegate;
    final int STATEMENTS_PER_CACHE_ITEM_LIMIT = 100000;
    ReferenceMap<PartialStatement, List<Statement>> cache = new ReferenceMap();
    private volatile long cacheTicket = Long.MIN_VALUE;

    public ReadCache(DataStructureInterface delegate) {
        this.delegate = delegate;
    }

    @Override
    public void addStatement(Statement statement) {
        this.delegate.addStatement(statement);
        this.clearCache();
    }

    @Override
    public void removeStatement(Statement statement) {
        this.delegate.removeStatement(statement);
        this.clearCache();
    }

    @Override
    public CloseableIteration<? extends Statement, SailException> getStatements(final Resource subject, final IRI predicate, final Value object, final Resource ... context) {
        final PartialStatement partialStatement = new PartialStatement(subject, predicate, object, context);
        CloseableIteration<? extends Statement, SailException> cached = this.getCached(partialStatement);
        if (cached != null) {
            logger.trace("cache hit");
            return cached;
        }
        final long localCacheTicket = this.cacheTicket;
        return new CloseableIteration<Statement, SailException>(){
            CloseableIteration<? extends Statement, SailException> statements;
            List<Statement> cache;
            {
                this.statements = ReadCache.this.delegate.getStatements(subject, predicate, object, context);
                this.cache = new ArrayList<Statement>();
            }

            public boolean hasNext() throws SailException {
                return this.statements.hasNext();
            }

            public Statement next() throws SailException {
                Statement next = (Statement)this.statements.next();
                if (this.cache != null) {
                    this.cache.add(next);
                    if (this.cache.size() > 100000) {
                        this.cache = null;
                        logger.trace("cache limit");
                    }
                }
                return next;
            }

            public void remove() throws SailException {
            }

            public void close() throws SailException {
                if (!this.statements.hasNext()) {
                    ReadCache.this.submitToCache(localCacheTicket, partialStatement, this.cache);
                } else {
                    logger.trace("iteration was not fully consumed before being closed and could not be cached");
                }
                this.statements.close();
            }
        };
    }

    private synchronized CloseableIteration<? extends Statement, SailException> getCached(PartialStatement partialStatement) {
        final List statements = (List)this.cache.get((Object)partialStatement);
        if (statements != null) {
            return new LookAheadIteration<Statement, SailException>(){
                Iterator<Statement> iterator;
                {
                    this.iterator = statements.iterator();
                }

                protected Statement getNextElement() throws SailException {
                    if (this.iterator.hasNext()) {
                        return this.iterator.next();
                    }
                    return null;
                }
            };
        }
        return null;
    }

    @Override
    public void flushForReading() {
        this.delegate.flushForReading();
    }

    @Override
    public void init() {
        this.delegate.init();
    }

    @Override
    public void clear(Resource[] contexts) {
        this.delegate.clear(contexts);
        this.clearCache();
    }

    @Override
    public void flushForCommit() {
        this.delegate.flushForCommit();
        this.clearCache();
    }

    @Override
    public boolean removeStatementsByQuery(Resource subj, IRI pred, Value obj, Resource[] contexts) {
        boolean removed = this.delegate.removeStatementsByQuery(subj, pred, obj, contexts);
        this.clearCache();
        return removed;
    }

    public synchronized void clearCache() {
        if (!this.cache.isEmpty()) {
            this.cache.clear();
        }
        ++this.cacheTicket;
    }

    public synchronized void submitToCache(Long localCacheTicket, PartialStatement partialStatement, List<Statement> statements) {
        if (localCacheTicket == this.cacheTicket && statements != null) {
            this.cache.put((Object)partialStatement, statements);
        }
    }
}

