/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.elasticsearchstore;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.elasticsearchstore.BuilderAndSha;
import org.eclipse.rdf4j.sail.elasticsearchstore.ClientProvider;
import org.eclipse.rdf4j.sail.elasticsearchstore.ElasticsearchHelper;
import org.eclipse.rdf4j.sail.elasticsearchstore.ElasticsearchId;
import org.eclipse.rdf4j.sail.elasticsearchstore.ElasticsearchValueFactory;
import org.eclipse.rdf4j.sail.extensiblestore.DataStructureInterface;
import org.eclipse.rdf4j.sail.extensiblestore.valuefactory.ExtensibleStatement;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequestBuilder;
import org.elasticsearch.search.SearchHit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ElasticsearchDataStructure
implements DataStructureInterface {
    private static final String MAPPING;
    private int BUFFER_THRESHOLD = 16384;
    private final ClientProvider clientProvider;
    private Set<ExtensibleStatement> addStatementBuffer = new HashSet<ExtensibleStatement>();
    private Set<ElasticsearchId> deleteStatementBuffer = new HashSet<ElasticsearchId>();
    private static final ElasticsearchValueFactory vf;
    private static final Logger logger;
    private static final String ELASTICSEARCH_TYPE = "statement";
    private final String index;
    private int scrollTimeout = 60000;

    ElasticsearchDataStructure(ClientProvider clientProvider, String index) {
        this.index = index;
        this.clientProvider = clientProvider;
    }

    public synchronized void addStatement(ExtensibleStatement statement) {
        if (this.addStatementBuffer.size() >= this.BUFFER_THRESHOLD) {
            this.flushAddStatementBuffer();
        }
        this.addStatementBuffer.add(statement);
    }

    public synchronized void removeStatement(ExtensibleStatement statement) {
        ElasticsearchId elasticsearchIdStatement;
        if (statement instanceof ElasticsearchId) {
            elasticsearchIdStatement = (ElasticsearchId)statement;
        } else {
            String id = this.sha256(statement);
            elasticsearchIdStatement = statement.getContext() == null ? vf.createStatement(id, statement.getSubject(), statement.getPredicate(), (Value)statement.getPredicate(), statement.isInferred()) : vf.createStatement(id, statement.getSubject(), statement.getPredicate(), (Value)statement.getPredicate(), statement.getContext(), statement.isInferred());
        }
        if (this.deleteStatementBuffer.size() >= this.BUFFER_THRESHOLD) {
            this.flushRemoveStatementBuffer();
        }
        this.deleteStatementBuffer.add(elasticsearchIdStatement);
    }

    public void addStatement(Collection<ExtensibleStatement> statements) {
        this.addStatementBuffer.addAll(statements);
        if (this.addStatementBuffer.size() >= this.BUFFER_THRESHOLD) {
            this.flushAddStatementBuffer();
        }
    }

    public synchronized void clear(boolean inferred, Resource[] contexts) {
        BulkByScrollResponse response = (BulkByScrollResponse)((DeleteByQueryRequestBuilder)((DeleteByQueryRequestBuilder)new DeleteByQueryRequestBuilder((ElasticsearchClient)this.clientProvider.getClient(), (ActionType)DeleteByQueryAction.INSTANCE).filter(this.getQueryBuilder(null, null, null, inferred, contexts))).abortOnVersionConflict(false).source(new String[]{this.index})).get();
        long deleted = response.getDeleted();
    }

    public void flushForCommit() {
    }

    public CloseableIteration<? extends ExtensibleStatement> getStatements(final Resource subject, final IRI predicate, final Value object, boolean inferred, Resource ... context) {
        final QueryBuilder queryBuilder = this.getQueryBuilder(subject, predicate, object, inferred, context);
        return new LookAheadIteration<ExtensibleStatement>(){
            final CloseableIteration<SearchHit> iterator;
            {
                this.iterator = ElasticsearchHelper.getScrollingIterator(queryBuilder, ElasticsearchDataStructure.this.clientProvider.getClient(), ElasticsearchDataStructure.this.index, ElasticsearchDataStructure.this.scrollTimeout);
            }

            protected ExtensibleStatement getNextElement() throws SailException {
                ExtensibleStatement next = null;
                while (next == null && this.iterator.hasNext()) {
                    SearchHit nextSearchHit = (SearchHit)this.iterator.next();
                    Map sourceAsMap = nextSearchHit.getSourceAsMap();
                    String id = nextSearchHit.getId();
                    ExtensibleStatement statement = ElasticsearchDataStructure.sourceToStatement(sourceAsMap, id, subject, predicate, object);
                    if (object != null && object.stringValue().hashCode() == statement.getObject().stringValue().hashCode() && !object.equals(statement.getObject())) continue;
                    next = statement;
                }
                return next;
            }

            protected void handleClose() throws SailException {
                this.iterator.close();
            }
        };
    }

    private QueryBuilder getQueryBuilder(Resource subject, IRI predicate, Value object, boolean inferred, Resource[] contexts) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (subject != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"subject", (String)subject.stringValue()));
            if (subject instanceof IRI) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"subject_IRI", (boolean)true));
            } else {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"subject_BNode", (boolean)true));
            }
        }
        if (predicate != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"predicate", (String)predicate.stringValue()));
        }
        if (object != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"object_Hash", (int)object.stringValue().hashCode()));
            if (object instanceof IRI) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"object_IRI", (boolean)true));
            } else if (object instanceof BNode) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"object_BNode", (boolean)true));
            } else {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"object_Datatype", (String)((Literal)object).getDatatype().stringValue()));
                if (((Literal)object).getLanguage().isPresent()) {
                    boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"object_Lang", (String)((String)((Literal)object).getLanguage().get())));
                }
            }
        }
        if (contexts != null && contexts.length > 0) {
            BoolQueryBuilder contextQueryBuilder = new BoolQueryBuilder();
            for (Resource context : contexts) {
                if (context == null) {
                    contextQueryBuilder.should((QueryBuilder)new BoolQueryBuilder().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"context")));
                    continue;
                }
                if (context instanceof IRI) {
                    contextQueryBuilder.should((QueryBuilder)new BoolQueryBuilder().must((QueryBuilder)QueryBuilders.termQuery((String)"context", (String)context.stringValue())).must((QueryBuilder)QueryBuilders.termQuery((String)"context_IRI", (boolean)true)));
                    continue;
                }
                contextQueryBuilder.should((QueryBuilder)new BoolQueryBuilder().must((QueryBuilder)QueryBuilders.termQuery((String)"context", (String)context.stringValue())).must((QueryBuilder)QueryBuilders.termQuery((String)"context_BNode", (boolean)true)));
            }
            boolQueryBuilder.must((QueryBuilder)contextQueryBuilder);
        }
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"inferred", (boolean)inferred));
        return QueryBuilders.constantScoreQuery((QueryBuilder)boolQueryBuilder);
    }

    public void flushForReading() {
        this.flushAddStatementBuffer();
        this.flushRemoveStatementBuffer();
        this.refreshIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void flushAddStatementBuffer() {
        Set<Object> workingBuffer = null;
        try {
            ElasticsearchDataStructure elasticsearchDataStructure = this;
            synchronized (elasticsearchDataStructure) {
                if (this.addStatementBuffer.isEmpty()) {
                    return;
                }
                workingBuffer = new HashSet<ExtensibleStatement>(this.addStatementBuffer);
                this.addStatementBuffer = new HashSet<ExtensibleStatement>(Math.min(this.addStatementBuffer.size(), this.BUFFER_THRESHOLD));
            }
            int failures = 0;
            do {
                BulkRequestBuilder bulkRequest = this.clientProvider.getClient().prepareBulk();
                ((Stream)workingBuffer.stream().parallel()).map(statement -> {
                    Map<String, Object> jsonMap = this.statementToJsonMap((ExtensibleStatement)statement);
                    return new BuilderAndSha(this.sha256((ExtensibleStatement)statement), jsonMap);
                }).collect(Collectors.toList()).forEach(builderAndSha -> bulkRequest.add(this.clientProvider.getClient().prepareIndex(this.index, ELASTICSEARCH_TYPE, builderAndSha.getSha256()).setSource(builderAndSha.getMap()).setOpType(DocWriteRequest.OpType.CREATE)));
                BulkResponse bulkResponse = (BulkResponse)bulkRequest.get();
                if (bulkResponse.hasFailures()) {
                    List<BulkItemResponse> bulkItemResponses = this.getBulkItemResponses(bulkResponse);
                    boolean onlyVersionConflicts = bulkItemResponses.stream().filter(BulkItemResponse::isFailed).allMatch(resp -> resp.getFailure().getCause() instanceof VersionConflictEngineException);
                    if (onlyVersionConflicts) {
                        Set failedIDs = bulkItemResponses.stream().filter(BulkItemResponse::isFailed).map(BulkItemResponse::getId).collect(Collectors.toSet());
                        if (!(workingBuffer = workingBuffer.stream().filter(statement -> failedIDs.contains(this.sha256((ExtensibleStatement)statement))).filter(statement -> {
                            String sha256 = this.sha256((ExtensibleStatement)statement);
                            ExtensibleStatement statementById = this.getStatementById(sha256);
                            return !statement.equals(statementById);
                        }).map(statement -> statement).collect(Collectors.toSet())).isEmpty()) {
                            ++failures;
                        }
                    } else {
                        ++failures;
                        logger.info("Elasticsearch has failures when adding data, retrying. Message: {}", (Object)bulkResponse.buildFailureMessage());
                    }
                    if (failures > 10) {
                        throw new RuntimeException("Elasticsearch has failed " + failures + " times when adding data, retrying. Message: " + bulkResponse.buildFailureMessage());
                    }
                    try {
                        Thread.sleep(failures * 100);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                failures = 0;
            } while (failures > 0);
            logger.debug("Added {} statements", (Object)workingBuffer.size());
            workingBuffer = Collections.emptySet();
            return;
        }
        finally {
            if (workingBuffer != null && !workingBuffer.isEmpty()) {
                ElasticsearchDataStructure elasticsearchDataStructure = this;
                synchronized (elasticsearchDataStructure) {
                    this.addStatementBuffer.addAll(workingBuffer);
                }
            }
        }
    }

    private Map<String, Object> statementToJsonMap(ExtensibleStatement statement) {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put("subject", statement.getSubject().stringValue());
        jsonMap.put("predicate", statement.getPredicate().stringValue());
        jsonMap.put("object", statement.getObject().stringValue());
        jsonMap.put("object_Hash", statement.getObject().stringValue().hashCode());
        jsonMap.put("inferred", statement.isInferred());
        Resource context = statement.getContext();
        if (context != null) {
            jsonMap.put("context", context.stringValue());
            if (context instanceof IRI) {
                jsonMap.put("context_IRI", true);
            } else {
                jsonMap.put("context_BNode", true);
            }
        }
        if (statement.getSubject() instanceof IRI) {
            jsonMap.put("subject_IRI", true);
        } else {
            jsonMap.put("subject_BNode", true);
        }
        if (statement.getObject() instanceof IRI) {
            jsonMap.put("object_IRI", true);
        } else if (statement.getObject() instanceof BNode) {
            jsonMap.put("object_BNode", true);
        } else {
            jsonMap.put("object_Datatype", ((Literal)statement.getObject()).getDatatype().stringValue());
            if (((Literal)statement.getObject()).getLanguage().isPresent()) {
                jsonMap.put("object_Lang", ((Literal)statement.getObject()).getLanguage().get());
            }
        }
        return jsonMap;
    }

    private ExtensibleStatement getStatementById(String sha256) {
        Map source = ((GetResponse)this.clientProvider.getClient().prepareGet(this.index, ELASTICSEARCH_TYPE, sha256).get()).getSource();
        return ElasticsearchDataStructure.sourceToStatement(source, sha256, null, null, null);
    }

    private List<BulkItemResponse> getBulkItemResponses(BulkResponse bulkResponse) {
        return Arrays.asList(bulkResponse.getItems());
    }

    private synchronized void flushRemoveStatementBuffer() {
        if (this.deleteStatementBuffer.isEmpty()) {
            return;
        }
        BulkRequestBuilder bulkRequest = this.clientProvider.getClient().prepareBulk();
        int failures = 0;
        do {
            this.deleteStatementBuffer.forEach(statement -> bulkRequest.add(this.clientProvider.getClient().prepareDelete(this.index, ELASTICSEARCH_TYPE, statement.getElasticsearchId())));
            BulkResponse bulkResponse = (BulkResponse)bulkRequest.get();
            if (bulkResponse.hasFailures()) {
                if (++failures < 10) {
                    logger.warn("Elasticsearch has failures when adding data, retrying. Message: {}", (Object)bulkResponse.buildFailureMessage());
                    continue;
                }
                throw new RuntimeException("Elasticsearch has failed " + failures + " times when adding data, retrying. Message: " + bulkResponse.buildFailureMessage());
            }
            failures = 0;
        } while (failures > 0);
        logger.debug("Removed {} statements", (Object)this.deleteStatementBuffer.size());
        this.deleteStatementBuffer = Collections.synchronizedSet(new HashSet(this.BUFFER_THRESHOLD));
    }

    public void init() {
        boolean indexExistsAlready = ((IndicesExistsResponse)this.clientProvider.getClient().admin().indices().exists(new IndicesExistsRequest(new String[]{this.index})).actionGet()).isExists();
        if (!indexExistsAlready) {
            CreateIndexRequest request = new CreateIndexRequest(this.index);
            request.mapping(ELASTICSEARCH_TYPE, MAPPING, XContentType.JSON);
            this.clientProvider.getClient().admin().indices().create(request).actionGet();
        }
        this.refreshIndex();
    }

    private void refreshIndex() {
        this.clientProvider.getClient().admin().indices().prepareRefresh(new String[]{this.index}).get();
    }

    void setElasticsearchScrollTimeout(int timeout) {
        this.scrollTimeout = timeout;
    }

    public synchronized boolean removeStatementsByQuery(Resource subj, IRI pred, Value obj, boolean inferred, Resource[] contexts) {
        if (subj != null && pred != null && obj != null && contexts.length == 1) {
            ExtensibleStatement statement = contexts[0] == null ? vf.createStatement(subj, pred, obj, inferred) : vf.createStatement(subj, pred, obj, contexts[0], inferred);
            String id = this.sha256(statement);
            boolean exists = ((GetResponse)this.clientProvider.getClient().prepareGet(this.index, ELASTICSEARCH_TYPE, id).get()).isExists();
            if (exists) {
                statement = contexts[0] == null ? vf.createStatement(id, subj, pred, obj, inferred) : vf.createStatement(id, subj, pred, obj, contexts[0], inferred);
                this.removeStatement(statement);
            }
            return exists;
        }
        try (CloseableIteration<? extends ExtensibleStatement> statements = this.getStatements(subj, pred, obj, inferred, contexts);){
            ArrayList<ExtensibleStatement> statementsToDelete = new ArrayList<ExtensibleStatement>();
            for (int i = 0; i < 1000 && statements.hasNext(); ++i) {
                statementsToDelete.add((ExtensibleStatement)statements.next());
            }
            if (!statements.hasNext()) {
                for (ExtensibleStatement statement : statementsToDelete) {
                    this.removeStatement(statement);
                }
                boolean bl = !statementsToDelete.isEmpty();
                return bl;
            }
        }
        BulkByScrollResponse response = (BulkByScrollResponse)((DeleteByQueryRequestBuilder)((DeleteByQueryRequestBuilder)new DeleteByQueryRequestBuilder((ElasticsearchClient)this.clientProvider.getClient(), (ActionType)DeleteByQueryAction.INSTANCE).filter(this.getQueryBuilder(subj, pred, obj, inferred, contexts))).source(new String[]{this.index})).abortOnVersionConflict(false).get();
        long deleted = response.getDeleted();
        return deleted > 0L;
    }

    String sha256(ExtensibleStatement statement) {
        StringBuilder stringBuilder = new StringBuilder();
        Stream.of(statement.getSubject(), statement.getPredicate(), statement.getObject(), statement.getContext(), statement.isInferred()).forEachOrdered(o -> {
            if (o instanceof IRI) {
                stringBuilder.append("IRI<").append(o.toString()).append(">");
            } else if (o instanceof BNode) {
                stringBuilder.append("Bnode<").append(o.toString()).append(">");
            } else if (o instanceof Literal) {
                stringBuilder.append("Literal<").append(o.toString()).append(">");
            } else if (o instanceof Boolean) {
                stringBuilder.append("Boolean<").append(o).append(">");
            } else if (o == null) {
                stringBuilder.append("Null<>");
            } else {
                throw new IllegalStateException();
            }
        });
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(stringBuilder.toString().getBytes(StandardCharsets.UTF_8));
            StringBuilder hexString = new StringBuilder();
            for (byte b : hash) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static ExtensibleStatement sourceToStatement(Map<String, Object> sourceAsMap, String id, Resource subject, IRI predicate, Value object) {
        Resource subjectRes = subject;
        if (subjectRes == null && sourceAsMap.containsKey("subject_IRI")) {
            subjectRes = vf.createIRI((String)sourceAsMap.get("subject"));
        } else if (subjectRes == null) {
            subjectRes = vf.createBNode((String)sourceAsMap.get("subject"));
        }
        IRI predicateRes = predicate != null ? predicate : vf.createIRI((String)sourceAsMap.get("predicate"));
        String objectString = (String)sourceAsMap.get("object");
        Object objectRes = sourceAsMap.containsKey("object_IRI") ? vf.createIRI(objectString) : (sourceAsMap.containsKey("object_BNode") ? vf.createBNode(objectString) : (sourceAsMap.containsKey("object_Lang") ? vf.createLiteral(objectString, (String)sourceAsMap.get("object_Lang")) : vf.createLiteral(objectString, vf.createIRI((String)sourceAsMap.get("object_Datatype")))));
        IRI contextRes = null;
        if (sourceAsMap.containsKey("context_IRI")) {
            contextRes = vf.createIRI((String)sourceAsMap.get("context"));
        } else if (sourceAsMap.containsKey("context_BNode")) {
            contextRes = vf.createBNode((String)sourceAsMap.get("context"));
        }
        Object inferredNullable = sourceAsMap.get("inferred");
        boolean inferred = false;
        if (inferredNullable != null) {
            inferred = (Boolean)inferredNullable;
        }
        if (contextRes != null) {
            return vf.createStatement(id, subjectRes, predicateRes, (Value)objectRes, (Resource)contextRes, inferred);
        }
        return vf.createStatement(id, subjectRes, predicateRes, (Value)objectRes, inferred);
    }

    public void setElasticsearchBulkSize(int size) {
        this.BUFFER_THRESHOLD = size;
    }

    public long getEstimatedSize() {
        Client client = this.clientProvider.getClient();
        IndicesAdminClient indices = client.admin().indices();
        IndicesStatsResponse indicesStatsResponse = (IndicesStatsResponse)indices.prepareStats(new String[]{this.index}).get();
        return indicesStatsResponse.getTotal().docs.getCount();
    }

    static {
        vf = (ElasticsearchValueFactory)ElasticsearchValueFactory.getInstance();
        try {
            MAPPING = IOUtils.toString((InputStream)ElasticsearchDataStructure.class.getClassLoader().getResourceAsStream("elasticsearchStoreMapping.json"), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        logger = LoggerFactory.getLogger(ElasticsearchDataStructure.class);
    }
}

