/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.elasticsearchstore;

import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.SortOrder;

class ElasticsearchHelper {
    ElasticsearchHelper() {
    }

    static CloseableIteration<SearchHit> getScrollingIterator(final QueryBuilder queryBuilder, final Client client, final String index, final int scrollTimeout) {
        return new CloseableIteration<SearchHit>(){
            Iterator<SearchHit> items;
            String scrollId;
            long itemsRetrieved = 0L;
            final int size = 1000;
            SearchHit next;
            boolean empty;
            {
                SearchResponse scrollResp = (SearchResponse)client.prepareSearch(new String[]{index}).addSort("_doc", SortOrder.ASC).setScroll(scrollTimeout + "ms").setQuery(queryBuilder).setSize(1000).get();
                this.items = Arrays.asList(scrollResp.getHits().getHits()).iterator();
                this.scrollId = scrollResp.getScrollId();
                this.empty = false;
            }

            private void calculateNext() {
                if (this.next != null) {
                    return;
                }
                if (this.empty) {
                    return;
                }
                if (this.items.hasNext()) {
                    this.next = this.items.next();
                } else if (this.itemsRetrieved < 998L) {
                    this.scrollIsEmpty();
                } else {
                    SearchResponse scrollResp = (SearchResponse)client.prepareSearchScroll(this.scrollId).setScroll(scrollTimeout + "ms").execute().actionGet();
                    this.items = Arrays.asList(scrollResp.getHits().getHits()).iterator();
                    this.scrollId = scrollResp.getScrollId();
                    if (this.items.hasNext()) {
                        this.next = this.items.next();
                    } else {
                        this.scrollIsEmpty();
                    }
                    this.itemsRetrieved = 0L;
                }
            }

            private void scrollIsEmpty() {
                ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
                clearScrollRequest.addScrollId(this.scrollId);
                client.clearScroll(clearScrollRequest);
                this.scrollId = null;
                this.empty = true;
            }

            public boolean hasNext() {
                this.calculateNext();
                return this.next != null;
            }

            public SearchHit next() {
                this.calculateNext();
                SearchHit temp = this.next;
                this.next = null;
                ++this.itemsRetrieved;
                return temp;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void close() {
                if (this.scrollId != null) {
                    this.scrollIsEmpty();
                }
            }
        };
    }
}

