/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.elasticsearchstore.config;

import java.util.ArrayList;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Configurations;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.CONFIG;
import org.eclipse.rdf4j.sail.base.config.BaseSailConfig;
import org.eclipse.rdf4j.sail.config.SailConfigException;
import org.eclipse.rdf4j.sail.elasticsearchstore.config.ElasticsearchStoreSchema;

public class ElasticsearchStoreConfig
extends BaseSailConfig {
    private String hostname;
    private int port = -1;
    private String clusterName;
    private String index;

    public ElasticsearchStoreConfig() {
        super("rdf4j:ElasticsearchStore");
    }

    public Resource export(Model m) {
        if (Configurations.useLegacyConfig()) {
            return this.exportLegacy(m);
        }
        Resource implNode = super.export(m);
        if (this.hostname != null) {
            m.add(implNode, CONFIG.Ess.hostname, (Value)Values.literal((String)this.hostname), new Resource[0]);
        }
        if (this.clusterName != null) {
            m.add(implNode, CONFIG.Ess.clusterName, (Value)Values.literal((String)this.clusterName), new Resource[0]);
        }
        if (this.index != null) {
            m.add(implNode, CONFIG.Ess.index, (Value)Values.literal((String)this.index), new Resource[0]);
        }
        if (this.port != -1) {
            m.add(implNode, CONFIG.Ess.port, (Value)Values.literal((int)this.port), new Resource[0]);
        }
        return implNode;
    }

    private Resource exportLegacy(Model m) {
        Resource implNode = super.export(m);
        if (this.hostname != null) {
            m.add(implNode, ElasticsearchStoreSchema.hostname, (Value)Values.literal((String)this.hostname), new Resource[0]);
        }
        if (this.clusterName != null) {
            m.add(implNode, ElasticsearchStoreSchema.clusterName, (Value)Values.literal((String)this.clusterName), new Resource[0]);
        }
        if (this.index != null) {
            m.add(implNode, ElasticsearchStoreSchema.index, (Value)Values.literal((String)this.index), new Resource[0]);
        }
        if (this.port != -1) {
            m.add(implNode, ElasticsearchStoreSchema.port, (Value)Values.literal((int)this.port), new Resource[0]);
        }
        return implNode;
    }

    public void parse(Model graph, Resource implNode) throws SailConfigException {
        super.parse(graph, implNode);
        try {
            Configurations.getLiteralValue((Model)graph, (Resource)implNode, (IRI)CONFIG.Ess.hostname, (IRI)ElasticsearchStoreSchema.hostname).ifPresent(value -> {
                try {
                    this.setHostname(value.stringValue());
                }
                catch (IllegalArgumentException e) {
                    throw new SailConfigException("String value required for " + CONFIG.Ess.hostname + " property, found " + value);
                }
            });
            Configurations.getLiteralValue((Model)graph, (Resource)implNode, (IRI)CONFIG.Ess.index, (IRI)ElasticsearchStoreSchema.index).ifPresent(value -> {
                try {
                    this.setIndex(value.stringValue());
                }
                catch (IllegalArgumentException e) {
                    throw new SailConfigException("String value required for " + CONFIG.Ess.index + " property, found " + value);
                }
            });
            Configurations.getLiteralValue((Model)graph, (Resource)implNode, (IRI)CONFIG.Ess.clusterName, (IRI)ElasticsearchStoreSchema.clusterName).ifPresent(value -> {
                try {
                    this.setClusterName(value.stringValue());
                }
                catch (IllegalArgumentException e) {
                    throw new SailConfigException("String value required for " + CONFIG.Ess.clusterName + " property, found " + value);
                }
            });
            Configurations.getLiteralValue((Model)graph, (Resource)implNode, (IRI)CONFIG.Ess.port, (IRI)ElasticsearchStoreSchema.port).ifPresent(value -> {
                try {
                    this.setPort(value.intValue());
                }
                catch (IllegalArgumentException e) {
                    throw new SailConfigException("Integer value required for " + CONFIG.Ess.port + " property, found " + value);
                }
            });
        }
        catch (ModelException e) {
            throw new SailConfigException(e.getMessage(), (Throwable)e);
        }
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getIndex() {
        return this.index;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public void assertRequiredValuesPresent() {
        ArrayList<String> missingFields = new ArrayList<String>();
        if (this.hostname == null) {
            missingFields.add("hostname");
        }
        if (this.clusterName == null) {
            missingFields.add("clusterName");
        }
        if (this.index == null) {
            missingFields.add("index");
        }
        if (this.port == -1) {
            missingFields.add("port");
        }
        if (!missingFields.isEmpty()) {
            throw new SailConfigException("Required config missing for: " + missingFields.stream().reduce((a, b) -> a + " and " + b));
        }
    }
}

