/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.elasticsearchstore;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.stream.StreamSupport;
import org.apache.commons.io.IOUtils;
import org.eclipse.rdf4j.model.impl.SimpleNamespace;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.elasticsearchstore.ClientProvider;
import org.eclipse.rdf4j.sail.extensiblestore.NamespaceStoreInterface;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ElasticsearchNamespaceStore
implements NamespaceStoreInterface {
    private static final Logger logger = LoggerFactory.getLogger(ElasticsearchNamespaceStore.class);
    private static final String PREFIX = "prefix";
    private static final String NAMESPACE = "namespace";
    private final ClientProvider clientProvider;
    private final String index;
    private static final String ELASTICSEARCH_TYPE = "namespace";
    private static final String MAPPING;

    ElasticsearchNamespaceStore(ClientProvider clientProvider, String index) {
        this.clientProvider = clientProvider;
        this.index = index;
    }

    public String getNamespace(String prefix) {
        GetResponse documentFields = (GetResponse)this.clientProvider.getClient().prepareGet(this.index, "namespace", prefix).get();
        if (documentFields.isExists()) {
            return documentFields.getSource().get("namespace").toString();
        }
        return null;
    }

    public void setNamespace(String prefix, String namespace) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(PREFIX, prefix);
        map.put("namespace", namespace);
        this.clientProvider.getClient().prepareIndex(this.index, "namespace", prefix).setSource(map).get();
        this.clientProvider.getClient().admin().indices().prepareRefresh(new String[]{this.index}).get();
    }

    public void removeNamespace(String prefix) {
        this.clientProvider.getClient().prepareDelete(this.index, "namespace", prefix).get();
        this.clientProvider.getClient().admin().indices().prepareRefresh(new String[]{this.index}).get();
    }

    public void clear() {
        this.clientProvider.getClient().admin().indices().prepareDelete(new String[]{this.index}).get();
        this.init();
    }

    public void init() {
        boolean indexExistsAlready = ((IndicesExistsResponse)this.clientProvider.getClient().admin().indices().exists(new IndicesExistsRequest(new String[]{this.index})).actionGet()).isExists();
        if (!indexExistsAlready) {
            CreateIndexRequest request = new CreateIndexRequest(this.index);
            request.mapping("namespace", MAPPING, XContentType.JSON);
            this.clientProvider.getClient().admin().indices().create(request).actionGet();
        }
    }

    public Iterator<SimpleNamespace> iterator() {
        SearchResponse searchResponse = (SearchResponse)this.clientProvider.getClient().prepareSearch(new String[]{this.index}).addSort("_doc", SortOrder.ASC).setQuery((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchAllQuery())).setTrackTotalHits(true).setSize(10000).get();
        SearchHits hits = searchResponse.getHits();
        if (hits.getTotalHits().value > 10000L) {
            throw new SailException("Namespace store only supports 10 000 items, found " + hits.getTotalHits().value);
        }
        return StreamSupport.stream(hits.spliterator(), false).map(SearchHit::getSourceAsMap).map(map -> new SimpleNamespace(map.get(PREFIX).toString(), map.get("namespace").toString())).iterator();
    }

    static {
        try {
            MAPPING = IOUtils.toString((InputStream)ElasticsearchNamespaceStore.class.getClassLoader().getResourceAsStream("elasticsearchStoreNamespaceMapping.json"), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

