/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.elasticsearchstore;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.elasticsearchstore.ClientProvider;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.transport.client.PreBuiltTransportClient;

public class SingletonClientProvider
implements ClientProvider {
    private transient Client client;
    private transient boolean closed = false;
    private final String hostname;
    private final int port;
    private final String clusterName;

    public SingletonClientProvider(String hostname, int port, String clusterName) {
        this.hostname = hostname;
        this.port = port;
        this.clusterName = clusterName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Client getClient() {
        if (this.client != null) {
            return this.client;
        }
        SingletonClientProvider singletonClientProvider = this;
        synchronized (singletonClientProvider) {
            if (this.closed) {
                throw new IllegalStateException("Elasticsearch Client Provider is closed!");
            }
            try {
                Settings settings = Settings.builder().put("cluster.name", this.clusterName).build();
                PreBuiltTransportClient client = new PreBuiltTransportClient(settings, new Class[0]);
                client.addTransportAddress(new TransportAddress(InetAddress.getByName(this.hostname), this.port));
                this.client = client;
            }
            catch (UnknownHostException e) {
                throw new SailException((Throwable)e);
            }
        }
        return this.client;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized void close() throws Exception {
        if (!this.closed) {
            this.closed = true;
            if (this.client != null) {
                Client temp = this.client;
                this.client = null;
                temp.close();
            }
        }
    }
}

