/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.elasticsearchstore.config;

import java.util.ArrayList;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.sail.base.config.BaseSailConfig;
import org.eclipse.rdf4j.sail.config.SailConfigException;
import org.eclipse.rdf4j.sail.elasticsearchstore.config.ElasticsearchStoreSchema;

public class ElasticsearchStoreConfig
extends BaseSailConfig {
    private static final ValueFactory vf = SimpleValueFactory.getInstance();
    private String hostname;
    private int port = -1;
    private String clusterName;
    private String index;

    public ElasticsearchStoreConfig() {
        super("rdf4j:ElasticsearchStore");
    }

    public Resource export(Model graph) {
        Resource implNode = super.export(graph);
        graph.setNamespace("ess", "http://rdf4j.org/config/sail/elasticsearchstore#");
        if (this.hostname != null) {
            graph.add(implNode, ElasticsearchStoreSchema.hostname, (Value)vf.createLiteral(this.hostname), new Resource[0]);
        }
        if (this.clusterName != null) {
            graph.add(implNode, ElasticsearchStoreSchema.clusterName, (Value)vf.createLiteral(this.clusterName), new Resource[0]);
        }
        if (this.index != null) {
            graph.add(implNode, ElasticsearchStoreSchema.index, (Value)vf.createLiteral(this.index), new Resource[0]);
        }
        if (this.port != -1) {
            graph.add(implNode, ElasticsearchStoreSchema.port, (Value)vf.createLiteral(this.port), new Resource[0]);
        }
        return implNode;
    }

    public void parse(Model graph, Resource implNode) throws SailConfigException {
        super.parse(graph, implNode);
        try {
            Models.objectLiteral((Iterable)graph.getStatements(implNode, ElasticsearchStoreSchema.hostname, null, new Resource[0])).ifPresent(value -> {
                try {
                    this.setHostname(value.stringValue());
                }
                catch (IllegalArgumentException e) {
                    throw new SailConfigException("String value required for " + ElasticsearchStoreSchema.hostname + " property, found " + value);
                }
            });
            Models.objectLiteral((Iterable)graph.getStatements(implNode, ElasticsearchStoreSchema.index, null, new Resource[0])).ifPresent(value -> {
                try {
                    this.setIndex(value.stringValue());
                }
                catch (IllegalArgumentException e) {
                    throw new SailConfigException("String value required for " + ElasticsearchStoreSchema.index + " property, found " + value);
                }
            });
            Models.objectLiteral((Iterable)graph.getStatements(implNode, ElasticsearchStoreSchema.clusterName, null, new Resource[0])).ifPresent(value -> {
                try {
                    this.setClusterName(value.stringValue());
                }
                catch (IllegalArgumentException e) {
                    throw new SailConfigException("String value required for " + ElasticsearchStoreSchema.clusterName + " property, found " + value);
                }
            });
            Models.objectLiteral((Iterable)graph.getStatements(implNode, ElasticsearchStoreSchema.port, null, new Resource[0])).ifPresent(value -> {
                try {
                    this.setPort(value.intValue());
                }
                catch (IllegalArgumentException e) {
                    throw new SailConfigException("Integer value required for " + ElasticsearchStoreSchema.port + " property, found " + value);
                }
            });
        }
        catch (ModelException e) {
            throw new SailConfigException(e.getMessage(), (Throwable)e);
        }
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getIndex() {
        return this.index;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public void assertRequiredValuesPresent() {
        ArrayList<String> missingFields = new ArrayList<String>();
        if (this.hostname == null) {
            missingFields.add("hostname");
        }
        if (this.clusterName == null) {
            missingFields.add("clusterName");
        }
        if (this.index == null) {
            missingFields.add("index");
        }
        if (this.port == -1) {
            missingFields.add("port");
        }
        if (!missingFields.isEmpty()) {
            throw new SailConfigException("Required config missing for: " + missingFields.stream().reduce((a, b) -> a + " and " + b));
        }
    }
}

