/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.elasticsearchstore;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.sail.elasticsearchstore.ElasticsearchContextStatement;
import org.eclipse.rdf4j.sail.elasticsearchstore.ElasticsearchId;
import org.eclipse.rdf4j.sail.elasticsearchstore.ElasticsearchStatement;
import org.eclipse.rdf4j.sail.extensiblestore.valuefactory.ExtensibleContextStatement;
import org.eclipse.rdf4j.sail.extensiblestore.valuefactory.ExtensibleStatement;
import org.eclipse.rdf4j.sail.extensiblestore.valuefactory.ExtensibleStatementHelper;
import org.eclipse.rdf4j.sail.extensiblestore.valuefactory.ExtensibleStatementImpl;

class ElasticsearchValueFactory
extends SimpleValueFactory
implements ExtensibleStatementHelper {
    private static final ElasticsearchValueFactory sharedInstance = new ElasticsearchValueFactory();

    public static SimpleValueFactory getInstance() {
        return sharedInstance;
    }

    private ElasticsearchValueFactory() {
    }

    ExtensibleStatement createStatement(Resource subject, IRI predicate, Value object, boolean inferred) {
        return new ExtensibleStatementImpl(subject, predicate, object, inferred);
    }

    ExtensibleStatement createStatement(Resource subject, IRI predicate, Value object, Resource context, boolean inferred) {
        return new ExtensibleContextStatement(subject, predicate, object, context, inferred);
    }

    ElasticsearchStatement createStatement(String elasticsearchID, Resource subject, IRI predicate, Value object, boolean inferred) {
        return new ElasticsearchStatement(elasticsearchID, subject, predicate, object, inferred);
    }

    ElasticsearchContextStatement createStatement(String elasticsearchID, Resource subject, IRI predicate, Value object, Resource context, boolean inferred) {
        return new ElasticsearchContextStatement(elasticsearchID, subject, predicate, object, context, inferred);
    }

    public ExtensibleStatement fromStatement(Statement statement, boolean inferred) {
        ElasticsearchId elasticsearchIdStatement;
        if (statement instanceof ElasticsearchId && (elasticsearchIdStatement = (ElasticsearchId)statement).isInferred() == inferred) {
            return elasticsearchIdStatement;
        }
        return ExtensibleStatementHelper.getDefaultImpl().fromStatement(statement, inferred);
    }
}

