/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.elasticsearchstore.config;

import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategyFactory;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.config.SailConfigException;
import org.eclipse.rdf4j.sail.config.SailFactory;
import org.eclipse.rdf4j.sail.config.SailImplConfig;
import org.eclipse.rdf4j.sail.elasticsearchstore.ElasticsearchStore;
import org.eclipse.rdf4j.sail.elasticsearchstore.config.ElasticsearchStoreConfig;

public class ElasticsearchStoreFactory
implements SailFactory {
    public static final String SAIL_TYPE = "rdf4j:ElasticsearchStore";

    public String getSailType() {
        return SAIL_TYPE;
    }

    public SailImplConfig getConfig() {
        return new ElasticsearchStoreConfig();
    }

    public Sail getSail(SailImplConfig sailImplConfig) throws SailConfigException {
        if (!SAIL_TYPE.equals(sailImplConfig.getType())) {
            throw new SailConfigException("Invalid Sail type: " + sailImplConfig.getType());
        }
        if (sailImplConfig instanceof ElasticsearchStoreConfig) {
            ElasticsearchStoreConfig config = (ElasticsearchStoreConfig)sailImplConfig;
            config.assertRequiredValuesPresent();
            ElasticsearchStore elasticsearchStore = new ElasticsearchStore(config.getHostname(), config.getPort(), config.getClusterName(), config.getIndex());
            EvaluationStrategyFactory evalStratFactory = config.getEvaluationStrategyFactory();
            if (evalStratFactory != null) {
                elasticsearchStore.setEvaluationStrategyFactory(evalStratFactory);
            }
            return elasticsearchStore;
        }
        return null;
    }
}

