/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.rdf4j.common.iteration.AbstractCloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIteratorIteration;
import org.eclipse.rdf4j.common.iteration.DistinctIteration;
import org.eclipse.rdf4j.common.iteration.DualUnionIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.FilterIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleNamespace;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.base.Changeset;
import org.eclipse.rdf4j.sail.base.DistinctModelReducingUnionIteration;
import org.eclipse.rdf4j.sail.base.SailDataset;

class SailDatasetImpl
implements SailDataset {
    private static final EmptyIteration<Triple> TRIPLE_EMPTY_ITERATION = new EmptyIteration();
    private static final EmptyIteration<Namespace> NAMESPACES_EMPTY_ITERATION = new EmptyIteration();
    private final SailDataset derivedFrom;
    private final Changeset changes;

    public SailDatasetImpl(SailDataset derivedFrom, Changeset changes) {
        this.derivedFrom = derivedFrom;
        this.changes = changes;
        changes.addRefback(this);
    }

    public String toString() {
        return this.changes + "\n" + this.derivedFrom;
    }

    @Override
    public void close() throws SailException {
        this.changes.removeRefback(this);
        this.derivedFrom.close();
    }

    @Override
    public String getNamespace(String prefix) throws SailException {
        Map<String, String> addedNamespaces = this.changes.getAddedNamespaces();
        if (addedNamespaces != null && addedNamespaces.containsKey(prefix)) {
            return addedNamespaces.get(prefix);
        }
        Set<String> removedPrefixes = this.changes.getRemovedPrefixes();
        if (removedPrefixes != null && removedPrefixes.contains(prefix) || this.changes.isNamespaceCleared()) {
            return null;
        }
        return this.derivedFrom.getNamespace(prefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseableIteration<? extends Namespace> getNamespaces() throws SailException {
        Set<String> removed;
        final Object namespaces = this.changes.isNamespaceCleared() ? NAMESPACES_EMPTY_ITERATION : this.derivedFrom.getNamespaces();
        Iterator<Map.Entry<String, String>> added = null;
        SailDatasetImpl sailDatasetImpl = this;
        synchronized (sailDatasetImpl) {
            Map<String, String> addedNamespaces = this.changes.getAddedNamespaces();
            if (addedNamespaces != null) {
                added = addedNamespaces.entrySet().iterator();
            }
            removed = this.changes.getRemovedPrefixes();
        }
        if (added == null && removed == null) {
            return namespaces;
        }
        final Iterator<Map.Entry<String, String>> addedIter = added;
        final Set<String> removedSet = removed;
        return new AbstractCloseableIteration<Namespace>(){
            volatile Namespace next;

            public boolean hasNext() throws SailException {
                if (this.isClosed()) {
                    return false;
                }
                if (addedIter != null && addedIter.hasNext()) {
                    return true;
                }
                Namespace toCheckNext = this.next;
                while (toCheckNext == null && namespaces.hasNext()) {
                    toCheckNext = this.next = (Namespace)namespaces.next();
                    if (removedSet == null || !removedSet.contains(toCheckNext.getPrefix())) continue;
                    this.next = null;
                    toCheckNext = null;
                }
                return toCheckNext != null;
            }

            public Namespace next() throws SailException {
                if (this.isClosed()) {
                    throw new NoSuchElementException("The iteration has been closed.");
                }
                if (addedIter != null && addedIter.hasNext()) {
                    Map.Entry e = (Map.Entry)addedIter.next();
                    return new SimpleNamespace((String)e.getKey(), (String)e.getValue());
                }
                try {
                    Namespace toCheckNext;
                    if (this.hasNext() && (toCheckNext = this.next) != null) {
                        Namespace namespace = toCheckNext;
                        return namespace;
                    }
                    this.close();
                    throw new NoSuchElementException("The iteration has been closed.");
                }
                finally {
                    this.next = null;
                }
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void handleClose() throws SailException {
                namespaces.close();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseableIteration<? extends Resource> getContextIDs() throws SailException {
        final CloseableIteration<? extends Resource> contextIDs = this.derivedFrom.getContextIDs();
        Iterator<Resource> added = null;
        Set<Resource> removed = null;
        SailDatasetImpl sailDatasetImpl = this;
        synchronized (sailDatasetImpl) {
            Set<Resource> deprecatedContexts;
            Set<Resource> approvedContexts = this.changes.getApprovedContexts();
            if (approvedContexts != null) {
                added = approvedContexts.iterator();
            }
            if ((deprecatedContexts = this.changes.getDeprecatedContexts()) != null) {
                removed = deprecatedContexts;
            }
        }
        if (added == null && removed == null) {
            return contextIDs;
        }
        final Iterator<Resource> addedIter = added;
        final Set<Resource> removedSet = removed;
        return new AbstractCloseableIteration<Resource>(){
            volatile Resource next;

            public boolean hasNext() throws SailException {
                if (this.isClosed()) {
                    return false;
                }
                if (addedIter != null && addedIter.hasNext()) {
                    return true;
                }
                Resource toCheckNext = this.next;
                while (toCheckNext == null && contextIDs.hasNext()) {
                    toCheckNext = this.next = (Resource)contextIDs.next();
                    if (removedSet == null || !removedSet.contains(toCheckNext)) continue;
                    this.next = null;
                    toCheckNext = null;
                }
                return toCheckNext != null;
            }

            public Resource next() throws SailException {
                if (this.isClosed()) {
                    throw new NoSuchElementException("The iteration has been closed.");
                }
                if (addedIter != null && addedIter.hasNext()) {
                    return (Resource)addedIter.next();
                }
                try {
                    Resource toCheckNext;
                    if (this.hasNext() && (toCheckNext = this.next) != null) {
                        Resource resource = toCheckNext;
                        return resource;
                    }
                    this.close();
                    throw new NoSuchElementException("The iteration has been closed.");
                }
                finally {
                    this.next = null;
                }
            }

            public void remove() throws SailException {
                throw new UnsupportedOperationException();
            }

            public void handleClose() throws SailException {
                contextIDs.close();
            }
        };
    }

    @Override
    public CloseableIteration<? extends Statement> getStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        CloseableIteration<? extends Statement> iter;
        Set<Resource> deprecatedContexts = this.changes.getDeprecatedContexts();
        if (this.changes.isStatementCleared() || contexts == null && deprecatedContexts != null && deprecatedContexts.contains(null) || contexts != null && contexts.length > 0 && deprecatedContexts != null && deprecatedContexts.containsAll(Arrays.asList(contexts))) {
            iter = null;
        } else if (contexts != null && contexts.length > 0 && deprecatedContexts != null) {
            ArrayList<Resource> remaining = new ArrayList<Resource>(Arrays.asList(contexts));
            remaining.removeAll(deprecatedContexts);
            iter = this.derivedFrom.getStatements(subj, pred, obj, remaining.toArray(new Resource[0]));
        } else {
            iter = this.derivedFrom.getStatements(subj, pred, obj, contexts);
        }
        if (this.changes.hasDeprecated() && iter != null) {
            iter = this.difference(iter, this.changes::hasDeprecated);
        }
        if (this.changes.hasApproved() && iter != null) {
            return new DistinctModelReducingUnionIteration(iter, this.changes::removeApproved, () -> this.changes.getApprovedStatements(subj, pred, obj, contexts));
        }
        if (this.changes.hasApproved()) {
            Iterator<Statement> i = this.changes.getApprovedStatements(subj, pred, obj, contexts).iterator();
            return new CloseableIteratorIteration(i);
        }
        if (iter != null) {
            return iter;
        }
        return CloseableIteration.EMPTY_STATEMENT_ITERATION;
    }

    @Override
    public CloseableIteration<? extends Triple> getTriples(Resource subj, IRI pred, Value obj) throws SailException {
        CloseableIteration<? extends Triple> iter = this.changes.isStatementCleared() ? null : this.derivedFrom.getTriples(subj, pred, obj);
        if (this.changes.hasDeprecated() && iter != null) {
            iter = this.triplesDifference(iter, triple -> this.isDeprecated((Triple)triple, this.changes.getDeprecatedStatements()));
        }
        if (this.changes.hasApproved()) {
            if (iter != null) {
                CloseableIteratorIteration tripleExceptionCloseableIteratorIteration = new CloseableIteratorIteration(this.changes.getApprovedTriples(subj, pred, obj).iterator());
                return new DistinctIteration(DualUnionIteration.getWildcardInstance(iter, (CloseableIteration)tripleExceptionCloseableIteratorIteration), new HashSet());
            }
            return new CloseableIteratorIteration(this.changes.getApprovedTriples(subj, pred, obj).iterator());
        }
        if (iter != null) {
            return iter;
        }
        return TRIPLE_EMPTY_ITERATION;
    }

    private CloseableIteration<? extends Statement> difference(CloseableIteration<? extends Statement> result, final Function<Statement, Boolean> excluded) {
        return new FilterIteration<Statement>(result){

            protected boolean accept(Statement stmt) {
                return (Boolean)excluded.apply(stmt) == false;
            }

            protected void handleClose() {
            }
        };
    }

    private CloseableIteration<? extends Triple> triplesDifference(CloseableIteration<? extends Triple> result, final Function<Triple, Boolean> excluded) {
        return new FilterIteration<Triple>(result){

            protected boolean accept(Triple stmt) {
                return (Boolean)excluded.apply(stmt) == false;
            }

            protected void handleClose() {
            }
        };
    }

    private boolean isDeprecated(Triple triple, List<Statement> deprecatedStatements) {
        Statement st;
        try (CloseableIteration<? extends Statement> subjectStatements = this.derivedFrom.getStatements((Resource)triple, null, null, new Resource[0]);){
            while (subjectStatements.hasNext()) {
                st = (Statement)subjectStatements.next();
                if (deprecatedStatements.contains(st)) continue;
                boolean bl = false;
                return bl;
            }
        }
        try (CloseableIteration<? extends Statement> objectStatements = this.derivedFrom.getStatements(null, null, (Value)triple, new Resource[0]);){
            while (objectStatements.hasNext()) {
                st = (Statement)objectStatements.next();
                if (deprecatedStatements.contains(st)) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }
}

