/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIteratorIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.FilterIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.UnionIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleNamespace;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.base.Changeset;
import org.eclipse.rdf4j.sail.base.SailDataset;

class SailDatasetImpl
implements SailDataset {
    private final SailDataset derivedFrom;
    private final Changeset changes;

    public SailDatasetImpl(SailDataset derivedFrom, Changeset changes) {
        this.derivedFrom = derivedFrom;
        this.changes = changes;
        changes.addRefback(this);
    }

    public String toString() {
        return this.changes + "\n" + this.derivedFrom;
    }

    @Override
    public void close() throws SailException {
        this.changes.removeRefback(this);
        this.derivedFrom.close();
    }

    @Override
    public String getNamespace(String prefix) throws SailException {
        Map<String, String> addedNamespaces = this.changes.getAddedNamespaces();
        if (addedNamespaces != null && addedNamespaces.containsKey(prefix)) {
            return addedNamespaces.get(prefix);
        }
        Set<String> removedPrefixes = this.changes.getRemovedPrefixes();
        if (removedPrefixes != null && removedPrefixes.contains(prefix) || this.changes.isNamespaceCleared()) {
            return null;
        }
        return this.derivedFrom.getNamespace(prefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseableIteration<? extends Namespace, SailException> getNamespaces() throws SailException {
        final CloseableIteration<? extends Namespace, SailException> namespaces = this.changes.isNamespaceCleared() ? new CloseableIteration<Namespace, SailException>() : this.derivedFrom.getNamespaces();
        Iterator<Map.Entry<String, String>> added = null;
        Set<String> removed = null;
        SailDatasetImpl sailDatasetImpl = this;
        synchronized (sailDatasetImpl) {
            Map<String, String> addedNamespaces = this.changes.getAddedNamespaces();
            if (addedNamespaces != null) {
                added = addedNamespaces.entrySet().iterator();
            }
            removed = this.changes.getRemovedPrefixes();
        }
        if (added == null && removed == null) {
            return namespaces;
        }
        final Iterator<Map.Entry<String, String>> addedIter = added;
        final Set<String> removedSet = removed;
        return new CloseableIteration<Namespace, SailException>(){
            Namespace next;

            public boolean hasNext() throws SailException {
                if (addedIter != null && addedIter.hasNext()) {
                    return true;
                }
                while (this.next == null && namespaces.hasNext()) {
                    this.next = (Namespace)namespaces.next();
                    if (removedSet == null || !removedSet.contains(this.next.getPrefix())) continue;
                    this.next = null;
                }
                return this.next != null;
            }

            public Namespace next() throws SailException {
                if (addedIter != null && addedIter.hasNext()) {
                    Map.Entry e = (Map.Entry)addedIter.next();
                    return new SimpleNamespace((String)e.getKey(), (String)e.getValue());
                }
                try {
                    if (this.hasNext()) {
                        Namespace namespace = this.next;
                        return namespace;
                    }
                    throw new NoSuchElementException();
                }
                finally {
                    this.next = null;
                }
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void close() throws SailException {
                namespaces.close();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseableIteration<? extends Resource, SailException> getContextIDs() throws SailException {
        final CloseableIteration<? extends Resource, SailException> contextIDs = this.derivedFrom.getContextIDs();
        Iterator<Resource> added = null;
        Set<Resource> removed = null;
        SailDatasetImpl sailDatasetImpl = this;
        synchronized (sailDatasetImpl) {
            Set<Resource> deprecatedContexts;
            Set<Resource> approvedContexts = this.changes.getApprovedContexts();
            if (approvedContexts != null) {
                added = approvedContexts.iterator();
            }
            if ((deprecatedContexts = this.changes.getDeprecatedContexts()) != null) {
                removed = deprecatedContexts;
            }
        }
        if (added == null && removed == null) {
            return contextIDs;
        }
        final Iterator<Resource> addedIter = added;
        final Set<Resource> removedSet = removed;
        return new CloseableIteration<Resource, SailException>(){
            Resource next;

            public void close() throws SailException {
                contextIDs.close();
            }

            public boolean hasNext() throws SailException {
                if (addedIter != null && addedIter.hasNext()) {
                    return true;
                }
                while (this.next == null && contextIDs.hasNext()) {
                    this.next = (Resource)contextIDs.next();
                    if (removedSet == null || !removedSet.contains(this.next)) continue;
                    this.next = null;
                }
                return this.next != null;
            }

            public Resource next() throws SailException {
                if (addedIter != null && addedIter.hasNext()) {
                    return (Resource)addedIter.next();
                }
                try {
                    if (this.hasNext()) {
                        Resource resource = this.next;
                        return resource;
                    }
                    throw new NoSuchElementException();
                }
                finally {
                    this.next = null;
                }
            }

            public void remove() throws SailException {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public CloseableIteration<? extends Statement, SailException> getStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        Model approved;
        CloseableIteration<? extends Statement, SailException> iter;
        Set<Resource> deprecatedContexts = this.changes.getDeprecatedContexts();
        if (this.changes.isStatementCleared() || contexts == null && deprecatedContexts != null && deprecatedContexts.contains(null) || contexts.length > 0 && deprecatedContexts != null && deprecatedContexts.containsAll(Arrays.asList(contexts))) {
            iter = null;
        } else if (contexts.length > 0 && deprecatedContexts != null) {
            ArrayList<Resource> remaining = new ArrayList<Resource>(Arrays.asList(contexts));
            remaining.removeAll(deprecatedContexts);
            iter = this.derivedFrom.getStatements(subj, pred, obj, contexts);
        } else {
            iter = this.derivedFrom.getStatements(subj, pred, obj, contexts);
        }
        Model deprecated = this.changes.getDeprecated();
        if (deprecated != null && iter != null) {
            iter = this.difference(iter, deprecated.filter(subj, pred, obj, contexts));
        }
        if ((approved = this.changes.getApproved()) != null && iter != null) {
            return this.union(iter, approved.filter(subj, pred, obj, contexts));
        }
        if (approved != null) {
            Iterator i = approved.filter(subj, pred, obj, contexts).iterator();
            return new CloseableIteratorIteration(i);
        }
        if (iter != null) {
            return iter;
        }
        return new EmptyIteration();
    }

    private CloseableIteration<? extends Statement, SailException> difference(CloseableIteration<? extends Statement, SailException> result, final Model excluded) {
        if (excluded.isEmpty()) {
            return result;
        }
        return new FilterIteration<Statement, SailException>(result){

            protected boolean accept(Statement stmt) {
                return !excluded.contains((Object)stmt);
            }
        };
    }

    private CloseableIteration<? extends Statement, SailException> union(CloseableIteration<? extends Statement, SailException> result, Model included) {
        if (included.isEmpty()) {
            return result;
        }
        Iterator iter = included.iterator();
        CloseableIteratorIteration incl = new CloseableIteratorIteration(iter);
        return new UnionIteration(new Iteration[]{incl, result});
    }
}

