/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.config;

import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.sail.config.SailConfigException;
import org.eclipse.rdf4j.sail.config.SailConfigSchema;
import org.eclipse.rdf4j.sail.config.SailFactory;
import org.eclipse.rdf4j.sail.config.SailImplConfig;
import org.eclipse.rdf4j.sail.config.SailRegistry;

public class SailConfigUtil {
    public static SailImplConfig parseRepositoryImpl(Model m, Resource implNode) throws SailConfigException {
        try {
            Literal typeLit = Models.objectLiteral((Model)m.filter(implNode, SailConfigSchema.SAILTYPE, null, new Resource[0]));
            if (typeLit != null) {
                SailFactory factory = (SailFactory)SailRegistry.getInstance().get(typeLit.getLabel());
                if (factory != null) {
                    SailImplConfig implConfig = factory.getConfig();
                    implConfig.parse(m, implNode);
                    return implConfig;
                }
                throw new SailConfigException("Unsupported Sail type: " + typeLit.getLabel());
            }
            return null;
        }
        catch (ModelException e) {
            throw new SailConfigException(e.getMessage(), e);
        }
    }
}

