/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail;

import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.URI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.UnknownSailTransactionStateException;
import org.eclipse.rdf4j.sail.UpdateContext;

public interface SailConnection {
    public boolean isOpen() throws SailException;

    public void close() throws SailException;

    public CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluate(TupleExpr var1, Dataset var2, BindingSet var3, boolean var4) throws SailException;

    public CloseableIteration<? extends Resource, SailException> getContextIDs() throws SailException;

    public CloseableIteration<? extends Statement, SailException> getStatements(Resource var1, IRI var2, Value var3, boolean var4, Resource ... var5) throws SailException;

    @Deprecated
    public CloseableIteration<? extends Statement, SailException> getStatements(Resource var1, URI var2, Value var3, boolean var4, Resource ... var5) throws SailException;

    public boolean hasStatement(Resource var1, IRI var2, Value var3, boolean var4, Resource ... var5) throws SailException;

    public long size(Resource ... var1) throws SailException;

    public void begin() throws SailException;

    public void begin(IsolationLevel var1) throws UnknownSailTransactionStateException, SailException;

    public void flush() throws SailException;

    public void prepare() throws SailException;

    public void commit() throws SailException;

    public void rollback() throws SailException;

    public boolean isActive() throws UnknownSailTransactionStateException;

    public void addStatement(Resource var1, IRI var2, Value var3, Resource ... var4) throws SailException;

    @Deprecated
    public void addStatement(Resource var1, URI var2, Value var3, Resource ... var4) throws SailException;

    public void removeStatements(Resource var1, IRI var2, Value var3, Resource ... var4) throws SailException;

    @Deprecated
    public void removeStatements(Resource var1, URI var2, Value var3, Resource ... var4) throws SailException;

    public void startUpdate(UpdateContext var1) throws SailException;

    public void addStatement(UpdateContext var1, Resource var2, IRI var3, Value var4, Resource ... var5) throws SailException;

    @Deprecated
    public void addStatement(UpdateContext var1, Resource var2, URI var3, Value var4, Resource ... var5) throws SailException;

    public void removeStatement(UpdateContext var1, Resource var2, IRI var3, Value var4, Resource ... var5) throws SailException;

    @Deprecated
    public void removeStatement(UpdateContext var1, Resource var2, URI var3, Value var4, Resource ... var5) throws SailException;

    public void endUpdate(UpdateContext var1) throws SailException;

    public void clear(Resource ... var1) throws SailException;

    public CloseableIteration<? extends Namespace, SailException> getNamespaces() throws SailException;

    public String getNamespace(String var1) throws SailException;

    public void setNamespace(String var1, String var2) throws SailException;

    public void removeNamespace(String var1) throws SailException;

    public void clearNamespaces() throws SailException;
}

