/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.jsonld;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.core.RDFParser;
import com.github.jsonldjava.utils.JsonUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFWriter;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.rio.helpers.JSONLDMode;
import org.eclipse.rdf4j.rio.helpers.JSONLDSettings;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.eclipse.rdf4j.rio.jsonld.JSONLDHierarchicalProcessor;
import org.eclipse.rdf4j.rio.jsonld.JSONLDInternalRDFParser;

public class JSONLDWriter
extends AbstractRDFWriter
implements RDFWriter {
    private final Model model = new LinkedHashModel();
    private final StatementCollector statementCollector = new StatementCollector(this.model);
    private final String baseURI;
    private final Writer writer;

    public JSONLDWriter(OutputStream outputStream) {
        this(outputStream, null);
    }

    public JSONLDWriter(OutputStream outputStream, String baseURI) {
        this(new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8)), baseURI);
    }

    public JSONLDWriter(Writer writer) {
        this(writer, null);
    }

    public JSONLDWriter(Writer writer, String baseURI) {
        this.baseURI = baseURI;
        this.writer = writer;
    }

    @Override
    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        this.model.setNamespace(prefix, uri);
    }

    @Override
    public void startRDF() throws RDFHandlerException {
        this.statementCollector.clear();
        this.model.clear();
    }

    @Override
    public void endRDF() throws RDFHandlerException {
        JSONLDInternalRDFParser serialiser = new JSONLDInternalRDFParser();
        try {
            Object output = JsonLdProcessor.fromRDF((Object)this.model, (RDFParser)serialiser);
            JSONLDMode mode = this.getWriterConfig().get(JSONLDSettings.JSONLD_MODE);
            JsonLdOptions opts = new JsonLdOptions();
            opts.setUseRdfType(this.getWriterConfig().get(JSONLDSettings.USE_RDF_TYPE));
            opts.setUseNativeTypes(this.getWriterConfig().get(JSONLDSettings.USE_NATIVE_TYPES));
            if (this.getWriterConfig().get(JSONLDSettings.HIERARCHICAL_VIEW).booleanValue()) {
                output = JSONLDHierarchicalProcessor.fromJsonLdObject(output);
            }
            if (this.baseURI != null && this.getWriterConfig().get(BasicWriterSettings.BASE_DIRECTIVE).booleanValue()) {
                opts.setBase(this.baseURI);
            }
            if (mode == JSONLDMode.EXPAND) {
                output = JsonLdProcessor.expand((Object)output, (JsonLdOptions)opts);
            }
            Object inframe = null;
            if (mode == JSONLDMode.FLATTEN) {
                output = JsonLdProcessor.flatten((Object)output, inframe, (JsonLdOptions)opts);
            }
            if (mode == JSONLDMode.COMPACT) {
                LinkedHashMap<String, Object> ctx = new LinkedHashMap<String, Object>();
                JSONLDWriter.addPrefixes(ctx, this.model.getNamespaces());
                HashMap<String, LinkedHashMap<String, Object>> localCtx = new HashMap<String, LinkedHashMap<String, Object>>();
                localCtx.put("@context", ctx);
                output = JsonLdProcessor.compact((Object)output, localCtx, (JsonLdOptions)opts);
            }
            if (this.getWriterConfig().get(BasicWriterSettings.PRETTY_PRINT).booleanValue()) {
                JsonUtils.writePrettyPrint((Writer)this.writer, (Object)output);
            } else {
                JsonUtils.write((Writer)this.writer, (Object)output);
            }
        }
        catch (JsonLdError e) {
            throw new RDFHandlerException("Could not render JSONLD", e);
        }
        catch (JsonGenerationException e) {
            throw new RDFHandlerException("Could not render JSONLD", e);
        }
        catch (JsonMappingException e) {
            throw new RDFHandlerException("Could not render JSONLD", e);
        }
        catch (IOException e) {
            throw new RDFHandlerException("Could not render JSONLD", e);
        }
    }

    @Override
    public void handleStatement(Statement st) throws RDFHandlerException {
        this.statementCollector.handleStatement(st);
    }

    @Override
    public void handleComment(String comment) throws RDFHandlerException {
    }

    @Override
    public RDFFormat getRDFFormat() {
        return RDFFormat.JSONLD;
    }

    private static void addPrefixes(Map<String, Object> ctx, Set<Namespace> namespaces) {
        for (Namespace ns : namespaces) {
            ctx.put(ns.getPrefix().isEmpty() ? "@vocab" : ns.getPrefix(), ns.getName());
        }
    }
}

