/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console.command;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.eclipse.rdf4j.IsolationLevels;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.VerificationListener;
import org.eclipse.rdf4j.console.command.ConsoleCommand;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.vocabulary.RDF4J;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;
import org.eclipse.rdf4j.rio.WriterConfig;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.eclipse.rdf4j.sail.shacl.ShaclSail;
import org.eclipse.rdf4j.sail.shacl.ShaclSailValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Verify
extends ConsoleCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(Verify.class);

    @Override
    public String getName() {
        return "verify";
    }

    @Override
    public String getHelpShort() {
        return "Verifies the syntax of an RDF data file, takes a file path or URL as argument";
    }

    @Override
    public String getHelpLong() {
        return "Usage:\nverify <location> [<shacl-location> <report.ttl>]\n  <location>                               The file path or URL identifying the data file\n  <location> <shacl-location> <report.ttl> Validate using shacl file and create a report\nVerifies the validity of the specified data file\n";
    }

    public Verify(ConsoleIO consoleIO) {
        super(consoleIO);
    }

    @Override
    public void execute(String ... tokens) {
        if (tokens.length != 2 && tokens.length != 4) {
            this.consoleIO.writeln(this.getHelpLong());
            return;
        }
        String dataPath = this.parseDataPath(tokens[1]);
        this.verify(dataPath);
        if (tokens.length == 4) {
            String shaclPath = this.parseDataPath(tokens[2]);
            String reportFile = tokens[3];
            this.shacl(dataPath, shaclPath, reportFile);
        }
    }

    private void verify(String dataPath) {
        try {
            URL dataURL = new URL(dataPath);
            RDFFormat format = Rio.getParserFormatForFileName(dataPath).orElseThrow(Rio.unsupportedFormat(dataPath));
            RDFParser parser = Rio.createParser(format);
            this.consoleIO.writeln("RDF Format is " + parser.getRDFFormat().getName());
            VerificationListener listener = new VerificationListener(this.consoleIO);
            parser.set(BasicParserSettings.VERIFY_DATATYPE_VALUES, true);
            parser.set(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, true);
            parser.set(BasicParserSettings.VERIFY_LANGUAGE_TAGS, true);
            parser.set(BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES, true);
            parser.set(BasicParserSettings.VERIFY_RELATIVE_URIS, true);
            parser.set(BasicParserSettings.VERIFY_URI_SYNTAX, true);
            parser.setParseErrorListener(listener);
            parser.setRDFHandler(listener);
            this.consoleIO.writeln("Verifying data...");
            try (InputStream dataStream = dataURL.openStream();){
                parser.parse(dataStream, "urn://openrdf.org/RioVerifier/");
            }
            int warnings = listener.getWarnings();
            int errors = listener.getErrors();
            if (warnings + errors > 0) {
                this.consoleIO.writeError("Found " + warnings + " warnings and " + errors + " errors");
            } else {
                this.consoleIO.writeln("Data verified, no errors were found");
            }
            if (errors == 0) {
                this.consoleIO.writeln("File contains " + listener.getStatements() + " statements");
            }
        }
        catch (MalformedURLException e) {
            this.consoleIO.writeError("Malformed URL: " + dataPath);
        }
        catch (IOException e) {
            this.consoleIO.writeError("Failed to load data: " + e.getMessage());
        }
        catch (UnsupportedRDFormatException e) {
            this.consoleIO.writeError("No parser available for this RDF format");
        }
        catch (RDFParseException e) {
            this.consoleIO.writeError("Unexpected RDFParseException" + e.getMessage());
        }
        catch (RDFHandlerException e) {
            this.consoleIO.writeError("Unable to verify : " + e.getMessage());
            LOGGER.error("Unable to verify data file", (Throwable)e);
        }
    }

    private void shacl(String dataPath, String shaclPath, String reportFile) {
        SailRepository repo;
        block34: {
            Throwable throwable;
            SailRepositoryConnection conn;
            RDFFormat format;
            ShaclSail sail = new ShaclSail(new MemoryStore());
            repo = new SailRepository(sail);
            repo.init();
            sail.disableValidation();
            boolean loaded = false;
            try {
                this.consoleIO.writeln("Loading shapes from " + shaclPath);
                URL shaclURL = new URL(shaclPath);
                format = Rio.getParserFormatForFileName(reportFile).orElse(RDFFormat.TURTLE);
                conn = repo.getConnection();
                throwable = null;
                try {
                    conn.begin(IsolationLevels.NONE);
                    conn.add(shaclURL, "", format, RDF4J.SHACL_SHAPE_GRAPH);
                    conn.commit();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (conn != null) {
                        if (throwable != null) {
                            try {
                                conn.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            conn.close();
                        }
                    }
                }
                loaded = true;
            }
            catch (MalformedURLException e) {
                this.consoleIO.writeError("Malformed URL: " + shaclPath);
            }
            catch (IOException e) {
                this.consoleIO.writeError("Failed to load shacl shapes: " + e.getMessage());
            }
            if (!loaded) {
                this.consoleIO.writeError("No shapes found");
                repo.shutDown();
                return;
            }
            sail.enableValidation();
            try {
                URL dataURL = new URL(dataPath);
                format = Rio.getParserFormatForFileName(dataPath).orElseThrow(Rio.unsupportedFormat(dataPath));
                conn = repo.getConnection();
                throwable = null;
                try {
                    conn.begin(IsolationLevels.NONE);
                    conn.add(dataURL, "", format, new Resource[0]);
                    conn.commit();
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (conn != null) {
                        if (throwable != null) {
                            try {
                                conn.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            conn.close();
                        }
                    }
                }
                this.consoleIO.writeln("SHACL validation OK");
            }
            catch (MalformedURLException e) {
                this.consoleIO.writeError("Malformed URL: " + dataPath);
            }
            catch (IOException e) {
                this.consoleIO.writeError("Failed to load data: " + e.getMessage());
            }
            catch (RepositoryException e) {
                Throwable cause = e.getCause();
                if (!(cause instanceof ShaclSailValidationException)) break block34;
                this.consoleIO.writeError("SHACL validation failed, writing report to " + reportFile);
                ShaclSailValidationException sv = (ShaclSailValidationException)cause;
                this.writeReport(sv.validationReportAsModel(), reportFile);
            }
        }
        repo.shutDown();
    }

    private String parseDataPath(String str) {
        StringBuilder dataPath = new StringBuilder(str);
        try {
            new URL(dataPath.toString());
        }
        catch (MalformedURLException e) {
            dataPath.insert(0, "file:");
        }
        return dataPath.toString();
    }

    private void writeReport(Model model, String reportFile) {
        WriterConfig cfg = new WriterConfig();
        cfg.set((RioSetting)BasicWriterSettings.PRETTY_PRINT, (Object)true);
        cfg.set((RioSetting)BasicWriterSettings.INLINE_BLANK_NODES, (Object)true);
        RDFFormat format = Rio.getParserFormatForFileName(reportFile).orElse(RDFFormat.TURTLE);
        try (BufferedWriter w = Files.newBufferedWriter(Paths.get(reportFile, new String[0]), new OpenOption[0]);){
            Rio.write((Iterable<Statement>)model, (Writer)w, format, cfg);
        }
        catch (IOException ex) {
            this.consoleIO.writeError("Could not write report to " + reportFile);
        }
    }
}

