/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.rio.rdfxml;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.xml.security.Init;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.eclipse.rdf4j.rio.ntriples.NTriplesParser;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.xml.sax.SAXException;

public abstract class RDFXMLParserTestCase {
    private static final String W3C_TESTS_DIR = "http://www.w3.org/2000/10/rdf-tests/rdfcore/";
    private static final String LOCAL_TESTS_DIR = "/testcases/rdfxml/";
    private static final String W3C_MANIFEST_FILE = "http://www.w3.org/2000/10/rdf-tests/rdfcore/Manifest.rdf";

    public TestSuite createTestSuite() throws Exception {
        SailRepository repository = new SailRepository((Sail)new MemoryStore());
        TestSuite suite = new TestSuite(RDFXMLParserTestCase.class.getName());
        try (RepositoryConnection con = repository.getConnection();){
            String inputURL;
            String caseURI;
            BindingSet bindingSet;
            URL w3cManifest = RDFXMLParserTestCase.resolveURL(W3C_MANIFEST_FILE);
            con.add(w3cManifest, RDFXMLParserTestCase.base(W3C_MANIFEST_FILE), RDFFormat.RDFXML, new Resource[0]);
            String query = "PREFIX test: <http://www.w3.org/2000/10/rdf-tests/rdfcore/testSchema#> SELECT ?TESTCASE ?INPUT ?OUTPUT  WHERE { ?TESTCASE a test:PositiveParserTest;                 test:inputDocument ?INPUT;                 test:outputDocument ?OUTPUT;                 test:status \"APPROVED\" .} ";
            try (TupleQueryResult queryResult = con.prepareTupleQuery(query).evaluate();){
                while (queryResult.hasNext()) {
                    bindingSet = (BindingSet)queryResult.next();
                    caseURI = bindingSet.getValue("TESTCASE").toString();
                    inputURL = bindingSet.getValue("INPUT").toString();
                    String outputURL = bindingSet.getValue("OUTPUT").toString();
                    suite.addTest((Test)new PositiveParserTest(caseURI, inputURL, outputURL));
                }
            }
            query = "PREFIX test: <http://www.w3.org/2000/10/rdf-tests/rdfcore/testSchema#> SELECT ?TESTCASE ?INPUT ?OUTPUT  WHERE { ?TESTCASE a test:NegativeParserTest;                 test:inputDocument ?INPUT;                 test:outputDocument ?OUTPUT;                 test:status \"APPROVED\" .} ";
            queryResult = con.prepareTupleQuery(query).evaluate();
            try {
                while (queryResult.hasNext()) {
                    bindingSet = (BindingSet)queryResult.next();
                    caseURI = bindingSet.getValue("TESTCASE").toString();
                    inputURL = bindingSet.getValue("INPUT").toString();
                    suite.addTest((Test)new NegativeParserTest(caseURI, inputURL));
                }
            }
            finally {
                if (queryResult != null) {
                    queryResult.close();
                }
            }
        }
        repository.shutDown();
        return suite;
    }

    private static URL resolveURL(String urlString) throws MalformedURLException {
        if (((String)urlString).startsWith(W3C_TESTS_DIR)) {
            urlString = "/testcases/rdfxml/w3c-approved/" + ((String)urlString).substring(W3C_TESTS_DIR.length());
        }
        if (((String)urlString).startsWith("/")) {
            return RDFXMLParserTestCase.class.getResource((String)urlString);
        }
        return RDFXMLParserTestCase.url((String)urlString);
    }

    protected abstract RDFParser createRDFParser();

    private static URL url(String uri) throws MalformedURLException {
        return new URL(uri);
    }

    private static String base(String uri) {
        return uri;
    }

    private static class CanonXMLValueFactory
    extends SimpleValueFactory {
        private final Canonicalizer c14n;

        public CanonXMLValueFactory() throws InvalidCanonicalizerException {
            Init.init();
            this.c14n = Canonicalizer.getInstance((String)"http://www.w3.org/2001/10/xml-exc-c14n#");
        }

        public Literal createLiteral(String value, IRI datatype) {
            if (RDF.XMLLITERAL.equals((Object)datatype)) {
                value = this.canonicalizeXmlLiteral(value);
            }
            return super.createLiteral(value, datatype);
        }

        public Literal createLiteral(String value, CoreDatatype datatype) {
            if (datatype == CoreDatatype.RDF.XMLLITERAL) {
                value = this.canonicalizeXmlLiteral(value);
            }
            return super.createLiteral(value, datatype);
        }

        public Literal createLiteral(String value, IRI datatype, CoreDatatype coreDatatype) {
            if (coreDatatype == CoreDatatype.RDF.XMLLITERAL) {
                assert (RDF.XMLLITERAL.equals((Object)datatype));
                value = this.canonicalizeXmlLiteral(value);
            } else assert (!RDF.XMLLITERAL.equals((Object)datatype));
            return super.createLiteral(value, datatype, coreDatatype);
        }

        private String canonicalizeXmlLiteral(String value) {
            try {
                return new String(this.c14n.canonicalize(value.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            }
            catch (IOException | ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
            catch (CanonicalizationException | SAXException e) {
                return value;
            }
        }
    }

    private class NegativeParserTest
    extends TestCase {
        private final String inputURL;

        public NegativeParserTest(String caseURI, String inputURL) {
            super(caseURI);
            this.inputURL = inputURL;
        }

        protected void runTest() {
            try {
                RDFParser rdfxmlParser = RDFXMLParserTestCase.this.createRDFParser();
                rdfxmlParser.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (Object)true);
                rdfxmlParser.getParserConfig().set(BasicParserSettings.VERIFY_DATATYPE_VALUES, (Object)true);
                rdfxmlParser.getParserConfig().set(BasicParserSettings.NORMALIZE_DATATYPE_VALUES, (Object)true);
                rdfxmlParser.setRDFHandler((RDFHandler)new StatementCollector());
                InputStream in = RDFXMLParserTestCase.resolveURL(this.inputURL).openStream();
                rdfxmlParser.parse(in, RDFXMLParserTestCase.base(this.inputURL));
                in.close();
                NegativeParserTest.fail((String)"Parser parses erroneous data without reporting errors");
            }
            catch (RDFParseException rdfxmlParser) {
            }
            catch (Exception e) {
                NegativeParserTest.fail((String)("Error: " + e.getMessage()));
            }
        }
    }

    private class PositiveParserTest
    extends TestCase {
        private final String inputURL;
        private final String outputURL;

        public PositiveParserTest(String caseURI, String inputURL, String outputURL) {
            super(caseURI);
            this.inputURL = inputURL;
            this.outputURL = outputURL;
        }

        protected void runTest() throws Exception {
            RDFParser rdfxmlParser = RDFXMLParserTestCase.this.createRDFParser();
            rdfxmlParser.setValueFactory((ValueFactory)new CanonXMLValueFactory());
            rdfxmlParser.getParserConfig().addNonFatalError(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES);
            rdfxmlParser.getParserConfig().addNonFatalError(BasicParserSettings.VERIFY_DATATYPE_VALUES);
            LinkedHashSet inputCollection = new LinkedHashSet();
            StatementCollector inputCollector = new StatementCollector(inputCollection);
            rdfxmlParser.setRDFHandler((RDFHandler)inputCollector);
            try (InputStream in = RDFXMLParserTestCase.resolveURL(this.inputURL).openStream();){
                rdfxmlParser.parse(in, RDFXMLParserTestCase.base(this.inputURL));
            }
            NTriplesParser ntriplesParser = new NTriplesParser();
            ntriplesParser.setValueFactory((ValueFactory)new CanonXMLValueFactory());
            ntriplesParser.getParserConfig().addNonFatalError(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES);
            ntriplesParser.getParserConfig().addNonFatalError(BasicParserSettings.VERIFY_DATATYPE_VALUES);
            LinkedHashSet outputCollection = new LinkedHashSet();
            StatementCollector outputCollector = new StatementCollector(outputCollection);
            ntriplesParser.setRDFHandler((RDFHandler)outputCollector);
            try (InputStream in = RDFXMLParserTestCase.resolveURL(this.outputURL).openStream();){
                ntriplesParser.parse(in, RDFXMLParserTestCase.base(this.inputURL));
            }
            if (!Models.isomorphic(inputCollection, outputCollection)) {
                String expected = outputCollection.stream().map(Objects::toString).collect(Collectors.joining());
                String actual = inputCollection.stream().map(Objects::toString).collect(Collectors.joining("\n"));
                PositiveParserTest.assertEquals((String)expected, (String)actual);
            }
        }
    }
}

