/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.rio.n3;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.eclipse.rdf4j.rio.ntriples.NTriplesParser;

public abstract class N3ParserTestCase {
    private static final String BASE_URL = "http://www.w3.org/2000/10/swap/test/";
    private static final String MANIFEST_URL = "http://www.w3.org/2000/10/swap/test/n3parser.tests";

    public TestSuite createTestSuite() throws Exception {
        TestSuite suite = new TestSuite(N3ParserTestCase.class.getName());
        URL url = N3ParserTestCase.url(MANIFEST_URL);
        SimpleValueFactory f = SimpleValueFactory.getInstance();
        String n3test = "http://www.w3.org/2004/11/n3test#";
        IRI POSITIVE_PARSER_TEST = f.createIRI(n3test, "PositiveParserTest");
        IRI NEGATIVE_PARSER_TEST = f.createIRI(n3test, "NegativeParserTest");
        IRI INPUT_DOCUMENT = f.createIRI(n3test, "inputDocument");
        IRI OUTPUT_DOCUMENT = f.createIRI(n3test, "outputDocument");
        try (InputStream in = url.openStream();){
            Model manifest = Rio.parse((InputStream)in, (String)N3ParserTestCase.base(MANIFEST_URL), (RDFFormat)RDFFormat.TURTLE, (Resource[])new Resource[0]);
            Set positiveTests = manifest.filter(null, RDF.TYPE, (Value)POSITIVE_PARSER_TEST, new Resource[0]).subjects();
            for (Resource s : positiveTests) {
                String inputURL = Models.getProperty((Model)manifest, (Resource)s, (IRI)INPUT_DOCUMENT, (Resource[])new Resource[0]).toString();
                String outputURL = Models.getProperty((Model)manifest, (Resource)s, (IRI)OUTPUT_DOCUMENT, (Resource[])new Resource[0]).toString();
                suite.addTest((Test)new PositiveParserTest(s.toString(), inputURL, outputURL));
            }
            Set negativeTests = manifest.filter(null, RDF.TYPE, (Value)NEGATIVE_PARSER_TEST, new Resource[0]).subjects();
            for (Resource s : negativeTests) {
                String inputURL = Models.getProperty((Model)manifest, (Resource)s, (IRI)INPUT_DOCUMENT, (Resource[])new Resource[0]).toString();
                suite.addTest((Test)new NegativeParserTest(s.toString(), inputURL));
            }
        }
        return suite;
    }

    protected abstract RDFParser createRDFParser();

    private static URL url(String uri) throws MalformedURLException {
        return new URL(uri);
    }

    private static String base(String uri) {
        return uri;
    }

    private class NegativeParserTest
    extends TestCase {
        private final URL inputURL;

        public NegativeParserTest(String testURI, String inputURL) throws MalformedURLException {
            super(testURI);
            this.inputURL = N3ParserTestCase.url(inputURL);
        }

        protected void runTest() {
            try {
                RDFParser turtleParser = N3ParserTestCase.this.createRDFParser();
                turtleParser.setRDFHandler((RDFHandler)new StatementCollector());
                InputStream in = this.inputURL.openStream();
                turtleParser.parse(in, N3ParserTestCase.base(this.inputURL.toExternalForm()));
                in.close();
                NegativeParserTest.fail((String)"Parser parses erroneous data without reporting errors");
            }
            catch (RDFParseException turtleParser) {
            }
            catch (Exception e) {
                NegativeParserTest.fail((String)("Error: " + e.getMessage()));
            }
        }
    }

    private class PositiveParserTest
    extends TestCase {
        private final URL inputURL;
        private final URL outputURL;

        public PositiveParserTest(String testURI, String inputURL, String outputURL) throws MalformedURLException {
            super(testURI);
            this.inputURL = N3ParserTestCase.url(inputURL);
            this.outputURL = N3ParserTestCase.url(outputURL);
        }

        protected void runTest() throws Exception {
            RDFParser turtleParser = N3ParserTestCase.this.createRDFParser();
            LinkedHashSet inputCollection = new LinkedHashSet();
            StatementCollector inputCollector = new StatementCollector(inputCollection);
            turtleParser.setRDFHandler((RDFHandler)inputCollector);
            InputStream in = this.inputURL.openStream();
            turtleParser.parse(in, N3ParserTestCase.base(this.inputURL.toExternalForm()));
            in.close();
            NTriplesParser ntriplesParser = new NTriplesParser();
            LinkedHashSet outputCollection = new LinkedHashSet();
            StatementCollector outputCollector = new StatementCollector(outputCollection);
            ntriplesParser.setRDFHandler((RDFHandler)outputCollector);
            in = this.outputURL.openStream();
            ntriplesParser.parse(in, N3ParserTestCase.base(this.outputURL.toExternalForm()));
            in.close();
            if (!Models.isomorphic(inputCollection, outputCollection)) {
                System.err.println("===models not equal===");
                LinkedList missing = new LinkedList(outputCollection);
                missing.removeAll(inputCollection);
                LinkedList unexpected = new LinkedList(inputCollection);
                unexpected.removeAll(outputCollection);
                if (!missing.isEmpty()) {
                    System.err.println("Missing   : " + missing);
                }
                if (!unexpected.isEmpty()) {
                    System.err.println("Unexpected: " + unexpected);
                }
                PositiveParserTest.fail((String)"models not equal");
            }
        }
    }
}

