/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.rdfjson;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.LinkedHashSet;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.eclipse.rdf4j.rio.ntriples.NTriplesParser;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.memory.MemoryStore;

public abstract class RDFJSONParserTestCase {
    protected static String BASE_URL = "http://example/base/";
    private static String TEST_FILE_BASE_PATH = "/testcases/rdfjson/";
    private static String MANIFEST_GOOD_URL = "/testcases/rdfjson/manifest.ttl";

    public TestSuite createTestSuite() throws Exception {
        TestSuite suite = new TestSuite(RDFJSONParserTestCase.class.getName());
        SailRepository repository = new SailRepository((Sail)new MemoryStore());
        repository.initialize();
        RepositoryConnection con = repository.getConnection();
        InputStream inputStream = this.getClass().getResourceAsStream(MANIFEST_GOOD_URL);
        con.add(inputStream, BASE_URL, RDFFormat.TURTLE, new Resource[0]);
        StringBuilder positiveQuery = new StringBuilder();
        positiveQuery.append(" PREFIX mf:   <http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#>\n");
        positiveQuery.append(" PREFIX qt:   <http://www.w3.org/2001/sw/DataAccess/tests/test-query#>\n");
        positiveQuery.append(" PREFIX rdft: <http://www.w3.org/ns/rdftest#>\n");
        positiveQuery.append(" SELECT ?test ?testName ?inputURL ?outputURL \n");
        positiveQuery.append(" WHERE { \n");
        positiveQuery.append("     ?test a rdft:TestRDFJSONPositiveSyntax . ");
        positiveQuery.append("     ?test mf:name ?testName . ");
        positiveQuery.append("     ?test mf:action ?inputURL . ");
        positiveQuery.append(" }");
        TupleQueryResult queryResult = con.prepareTupleQuery(QueryLanguage.SPARQL, positiveQuery.toString()).evaluate();
        while (queryResult.hasNext()) {
            BindingSet bindingSet = (BindingSet)queryResult.next();
            String nextTestName = ((Literal)bindingSet.getValue("testName")).getLabel();
            String nextTestFile = this.removeBase(((IRI)bindingSet.getValue("inputURL")).toString());
            String nextInputURL = TEST_FILE_BASE_PATH + nextTestFile;
            String nextBaseUrl = BASE_URL + nextTestFile;
            suite.addTest((Test)new PositiveParserTest(nextTestName, nextInputURL, null, nextBaseUrl));
        }
        queryResult.close();
        StringBuilder negativeQuery = new StringBuilder();
        negativeQuery.append(" PREFIX mf:   <http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#>\n");
        negativeQuery.append(" PREFIX qt:   <http://www.w3.org/2001/sw/DataAccess/tests/test-query#>\n");
        negativeQuery.append(" PREFIX rdft: <http://www.w3.org/ns/rdftest#>\n");
        negativeQuery.append(" SELECT ?test ?testName ?inputURL ?outputURL \n");
        negativeQuery.append(" WHERE { \n");
        negativeQuery.append("     ?test a rdft:TestRDFJSONNegativeSyntax . ");
        negativeQuery.append("     ?test mf:name ?testName . ");
        negativeQuery.append("     ?test mf:action ?inputURL . ");
        negativeQuery.append(" }");
        queryResult = con.prepareTupleQuery(QueryLanguage.SPARQL, negativeQuery.toString()).evaluate();
        while (queryResult.hasNext()) {
            BindingSet bindingSet = (BindingSet)queryResult.next();
            String nextTestName = ((Literal)bindingSet.getValue("testName")).toString();
            String nextTestFile = this.removeBase(((IRI)bindingSet.getValue("inputURL")).toString());
            String nextInputURL = TEST_FILE_BASE_PATH + nextTestFile;
            String nextBaseUrl = BASE_URL + nextTestFile;
            suite.addTest((Test)new NegativeParserTest(nextTestName, nextInputURL, nextBaseUrl));
        }
        queryResult.close();
        StringBuilder positiveEvalQuery = new StringBuilder();
        positiveEvalQuery.append(" PREFIX mf:   <http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#>\n");
        positiveEvalQuery.append(" PREFIX qt:   <http://www.w3.org/2001/sw/DataAccess/tests/test-query#>\n");
        positiveEvalQuery.append(" PREFIX rdft: <http://www.w3.org/ns/rdftest#>\n");
        positiveEvalQuery.append(" SELECT ?test ?testName ?inputURL ?outputURL \n");
        positiveEvalQuery.append(" WHERE { \n");
        positiveEvalQuery.append("     ?test a rdft:TestRDFJSONEval . ");
        positiveEvalQuery.append("     ?test mf:name ?testName . ");
        positiveEvalQuery.append("     ?test mf:action ?inputURL . ");
        positiveEvalQuery.append("     ?test mf:result ?outputURL . ");
        positiveEvalQuery.append(" }");
        queryResult = con.prepareTupleQuery(QueryLanguage.SPARQL, positiveEvalQuery.toString()).evaluate();
        while (queryResult.hasNext()) {
            BindingSet bindingSet = (BindingSet)queryResult.next();
            String nextTestName = ((Literal)bindingSet.getValue("testName")).getLabel();
            String nextTestFile = this.removeBase(((IRI)bindingSet.getValue("inputURL")).toString());
            String nextInputURL = TEST_FILE_BASE_PATH + nextTestFile;
            String nextOutputURL = TEST_FILE_BASE_PATH + this.removeBase(((IRI)bindingSet.getValue("outputURL")).toString());
            String nextBaseUrl = BASE_URL + nextTestFile;
            suite.addTest((Test)new PositiveParserTest(nextTestName, nextInputURL, nextOutputURL, nextBaseUrl));
        }
        queryResult.close();
        con.close();
        repository.shutDown();
        return suite;
    }

    protected abstract RDFParser createRDFParser();

    private String removeBase(String baseUrl) {
        if (baseUrl.startsWith(BASE_URL)) {
            return baseUrl.substring(BASE_URL.length());
        }
        return baseUrl;
    }

    private class NegativeParserTest
    extends TestCase {
        private String inputURL;
        private String baseURL;

        public NegativeParserTest(String caseURI, String inputURL, String baseURL) throws MalformedURLException {
            super(caseURI);
            this.inputURL = inputURL;
            this.baseURL = baseURL;
        }

        protected void runTest() {
            try {
                RDFParser rdfjsonParser = RDFJSONParserTestCase.this.createRDFParser();
                rdfjsonParser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
                rdfjsonParser.setRDFHandler((RDFHandler)new StatementCollector());
                InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(this.inputURL);
                rdfjsonParser.parse(in, this.baseURL);
                in.close();
                NegativeParserTest.fail((String)"Parser parses erroneous data without reporting errors");
            }
            catch (RDFParseException rdfjsonParser) {
            }
            catch (Exception e) {
                NegativeParserTest.fail((String)("Error: " + e.getMessage()));
            }
        }
    }

    private class PositiveParserTest
    extends TestCase {
        private String inputURL;
        private String outputURL;
        private String baseURL;

        public PositiveParserTest(String testName, String inputURL, String outputURL, String baseURL) throws MalformedURLException {
            super(testName);
            this.inputURL = inputURL;
            if (outputURL != null) {
                this.outputURL = outputURL;
            }
            this.baseURL = baseURL;
        }

        protected void runTest() throws Exception {
            RDFParser rdfjsonParser = RDFJSONParserTestCase.this.createRDFParser();
            rdfjsonParser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
            LinkedHashSet inputCollection = new LinkedHashSet();
            StatementCollector inputCollector = new StatementCollector(inputCollection);
            rdfjsonParser.setRDFHandler((RDFHandler)inputCollector);
            InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(this.inputURL);
            rdfjsonParser.parse(in, this.baseURL);
            in.close();
            NTriplesParser ntriplesParser = new NTriplesParser();
            ntriplesParser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
            LinkedHashSet outputCollection = new LinkedHashSet();
            StatementCollector outputCollector = new StatementCollector(outputCollection);
            ntriplesParser.setRDFHandler((RDFHandler)outputCollector);
            if (this.outputURL != null) {
                in = ((Object)((Object)this)).getClass().getResourceAsStream(this.outputURL);
                ntriplesParser.parse(in, this.baseURL);
                in.close();
                if (!Models.isomorphic(inputCollection, outputCollection)) {
                    System.err.println("===models not equal===");
                    System.err.println("Expected: " + outputCollection);
                    System.err.println("Actual  : " + inputCollection);
                    System.err.println("======================");
                    PositiveParserTest.fail((String)"models not equal");
                }
            }
        }
    }
}

