/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.LinkedHashSet;
import junit.framework.TestCase;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.rio.ParseErrorListener;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.helpers.ParseErrorCollector;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PositiveParserTest
extends TestCase {
    private String inputURL;
    private String outputURL;
    private String baseURL;
    private RDFParser targetParser;
    private RDFParser ntriplesParser;
    protected IRI testUri;
    private static final Logger logger = LoggerFactory.getLogger(PositiveParserTest.class);

    public PositiveParserTest(IRI testUri, String testName, String inputURL, String outputURL, String baseURL, RDFParser targetParser, RDFParser ntriplesParser) throws MalformedURLException {
        super(testName);
        this.testUri = testUri;
        this.inputURL = inputURL;
        if (outputURL != null) {
            this.outputURL = outputURL;
        }
        this.baseURL = baseURL;
        this.targetParser = targetParser;
        this.ntriplesParser = ntriplesParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTest() throws Exception {
        LinkedHashSet inputCollection = new LinkedHashSet();
        StatementCollector inputCollector = new StatementCollector(inputCollection);
        this.targetParser.setRDFHandler((RDFHandler)inputCollector);
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(this.inputURL);
        PositiveParserTest.assertNotNull((String)("Test resource was not found: inputURL=" + this.inputURL), (Object)in);
        logger.debug("test: " + this.inputURL);
        ParseErrorCollector el = new ParseErrorCollector();
        this.targetParser.setParseErrorListener((ParseErrorListener)el);
        try {
            this.targetParser.parse(in, this.baseURL);
        }
        finally {
            in.close();
            if (!el.getFatalErrors().isEmpty()) {
                logger.error("[Turtle] Input file had fatal parsing errors: \n" + el.getFatalErrors());
            }
            if (!el.getErrors().isEmpty()) {
                logger.error("[Turtle] Input file had parsing errors: \n" + el.getErrors());
            }
            if (!el.getWarnings().isEmpty()) {
                logger.warn("[Turtle] Input file had parsing warnings: \n" + el.getWarnings());
            }
        }
        if (this.outputURL != null) {
            this.ntriplesParser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
            LinkedHashSet outputCollection = new LinkedHashSet();
            StatementCollector outputCollector = new StatementCollector(outputCollection);
            this.ntriplesParser.setRDFHandler((RDFHandler)outputCollector);
            in = ((Object)((Object)this)).getClass().getResourceAsStream(this.outputURL);
            try {
                this.ntriplesParser.parse(in, this.baseURL);
            }
            finally {
                in.close();
            }
            if (!Models.isomorphic(inputCollection, outputCollection)) {
                logger.error("===models not equal===\nExpected: " + outputCollection + "\nActual  : " + inputCollection + "\n======================");
                PositiveParserTest.fail((String)"models not equal");
            }
        }
    }
}

