/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.nquads;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.util.RepositoryUtil;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.RDFParserFactory;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.RDFWriterFactory;
import org.eclipse.rdf4j.rio.RDFWriterTest;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractNQuadsWriterTest
extends RDFWriterTest {
    private RDFParser parser;
    private RDFWriter writer;
    private ValueFactory vf;

    protected AbstractNQuadsWriterTest(RDFWriterFactory writerF, RDFParserFactory parserF) {
        super(writerF, parserF);
    }

    @Before
    public void setUp() throws Exception {
        this.parser = this.rdfParserFactory.getParser();
        this.vf = SimpleValueFactory.getInstance();
    }

    @After
    public void tearDown() {
        this.parser = null;
        this.writer = null;
    }

    public void testWrite() throws RepositoryException, RDFParseException, IOException, RDFHandlerException {
        SailRepository rep1 = new SailRepository((Sail)new MemoryStore());
        rep1.initialize();
        RepositoryConnection con1 = rep1.getConnection();
        URL ciaScheme = this.getClass().getResource("/cia-factbook/CIA-onto-enhanced.rdf");
        URL ciaFacts = this.getClass().getResource("/cia-factbook/CIA-facts-enhanced.rdf");
        con1.add(ciaScheme, ciaScheme.toExternalForm(), (RDFFormat)Rio.getParserFormatForFileName((String)ciaScheme.toExternalForm()).orElseThrow(Rio.unsupportedFormat((String)ciaScheme.toExternalForm())), new Resource[0]);
        con1.add(ciaFacts, ciaFacts.toExternalForm(), (RDFFormat)Rio.getParserFormatForFileName((String)ciaFacts.toExternalForm()).orElseThrow(Rio.unsupportedFormat((String)ciaFacts.toExternalForm())), new Resource[0]);
        StringWriter writer = new StringWriter();
        RDFWriter rdfWriter = this.rdfWriterFactory.getWriter((Writer)writer);
        con1.export((RDFHandler)rdfWriter, new Resource[0]);
        con1.close();
        SailRepository rep2 = new SailRepository((Sail)new MemoryStore());
        rep2.initialize();
        RepositoryConnection con2 = rep2.getConnection();
        con2.add((Reader)new StringReader(writer.toString()), "foo:bar", RDFFormat.NQUADS, new Resource[0]);
        con2.close();
        Assert.assertTrue((String)"result of serialization and re-upload should be equal to original", (boolean)RepositoryUtil.equals((Repository)rep1, (Repository)rep2));
    }

    @Test
    public void testReadWrite() throws RDFHandlerException, IOException, RDFParseException {
        StatementCollector statementCollector = new StatementCollector();
        this.parser.setRDFHandler((RDFHandler)statementCollector);
        this.parser.parse(this.getClass().getResourceAsStream("/testcases/nquads/test2.nq"), "http://test.base.uri");
        Assert.assertEquals((long)400L, (long)statementCollector.getStatements().size());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writer = this.rdfWriterFactory.getWriter((OutputStream)baos);
        this.writer.startRDF();
        for (Statement nextStatement : statementCollector.getStatements()) {
            this.writer.handleStatement(nextStatement);
        }
        this.writer.endRDF();
        Assert.assertEquals((String)"Unexpected number of lines.", (long)400L, (long)baos.toString().split("\n").length);
    }

    @Test
    public void testNoContext() throws RDFHandlerException {
        Statement s1 = this.vf.createStatement((Resource)this.vf.createIRI("http://test.example.org/test/subject/1"), this.vf.createIRI("http://other.example.com/test/predicate/1"), (Value)this.vf.createLiteral("test literal"));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writer = this.rdfWriterFactory.getWriter((OutputStream)baos);
        this.writer.startRDF();
        this.writer.handleStatement(s1);
        this.writer.endRDF();
        String content = baos.toString();
        String[] lines = content.split("\n");
        Assert.assertEquals((String)"Unexpected number of lines.", (long)1L, (long)lines.length);
        Assert.assertEquals((Object)"<http://test.example.org/test/subject/1> <http://other.example.com/test/predicate/1> \"test literal\" .", (Object)lines[0]);
    }

    @Test
    public void testNoContextAddXSDString() throws RDFHandlerException {
        Statement s1 = this.vf.createStatement((Resource)this.vf.createIRI("http://test.example.org/test/subject/1"), this.vf.createIRI("http://other.example.com/test/predicate/1"), (Value)this.vf.createLiteral("test literal"));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writer = this.rdfWriterFactory.getWriter((OutputStream)baos);
        this.writer.getWriterConfig().set(BasicWriterSettings.XSD_STRING_TO_PLAIN_LITERAL, (Object)false);
        this.writer.startRDF();
        this.writer.handleStatement(s1);
        this.writer.endRDF();
        String content = baos.toString();
        String[] lines = content.split("\n");
        Assert.assertEquals((String)"Unexpected number of lines.", (long)1L, (long)lines.length);
        Assert.assertEquals((Object)"<http://test.example.org/test/subject/1> <http://other.example.com/test/predicate/1> \"test literal\"^^<http://www.w3.org/2001/XMLSchema#string> .", (Object)lines[0]);
    }

    @Test
    public void testBlankNodeContext() throws RDFHandlerException {
        Statement s1 = this.vf.createStatement((Resource)this.vf.createIRI("http://test.example.org/test/subject/1"), this.vf.createIRI("http://other.example.com/test/predicate/1"), (Value)this.vf.createLiteral("test literal"), (Resource)this.vf.createBNode());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writer = this.rdfWriterFactory.getWriter((OutputStream)baos);
        this.writer.startRDF();
        this.writer.handleStatement(s1);
        this.writer.endRDF();
        String content = baos.toString();
        String[] lines = content.split("\n");
        Assert.assertEquals((String)"Unexpected number of lines.", (long)1L, (long)lines.length);
        Assert.assertTrue((boolean)lines[0].startsWith("<http://test.example.org/test/subject/1> <http://other.example.com/test/predicate/1> \"test literal\" _:"));
    }

    @Test
    public void testBlankNodeContextAddXSDString() throws RDFHandlerException {
        Statement s1 = this.vf.createStatement((Resource)this.vf.createIRI("http://test.example.org/test/subject/1"), this.vf.createIRI("http://other.example.com/test/predicate/1"), (Value)this.vf.createLiteral("test literal"), (Resource)this.vf.createBNode());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writer = this.rdfWriterFactory.getWriter((OutputStream)baos);
        this.writer.getWriterConfig().set(BasicWriterSettings.XSD_STRING_TO_PLAIN_LITERAL, (Object)false);
        this.writer.startRDF();
        this.writer.handleStatement(s1);
        this.writer.endRDF();
        String content = baos.toString();
        String[] lines = content.split("\n");
        Assert.assertEquals((String)"Unexpected number of lines.", (long)1L, (long)lines.length);
        Assert.assertTrue((boolean)lines[0].startsWith("<http://test.example.org/test/subject/1> <http://other.example.com/test/predicate/1> \"test literal\"^^<http://www.w3.org/2001/XMLSchema#string> _:"));
    }
}

