/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.n3;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.eclipse.rdf4j.rio.ntriples.NTriplesParser;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.memory.MemoryStore;

public abstract class N3ParserTestCase {
    private static String BASE_URL = "http://www.w3.org/2000/10/swap/test/";
    private static String MANIFEST_URL = "http://www.w3.org/2000/10/swap/test/n3parser.tests";

    public TestSuite createTestSuite() throws Exception {
        String inputURL;
        String testURI;
        BindingSet bindingSet;
        TestSuite suite = new TestSuite(N3ParserTestCase.class.getName());
        SailRepository repository = new SailRepository((Sail)new MemoryStore());
        repository.initialize();
        RepositoryConnection con = repository.getConnection();
        URL url = N3ParserTestCase.url(MANIFEST_URL);
        con.add(url, N3ParserTestCase.base(MANIFEST_URL), RDFFormat.TURTLE, new Resource[0]);
        String query = "SELECT testURI, inputURL, outputURL FROM {testURI} rdf:type {n3test:PositiveParserTest};                n3test:inputDocument {inputURL};                n3test:outputDocument {outputURL} USING NAMESPACE n3test = <http://www.w3.org/2004/11/n3test#>";
        TupleQueryResult queryResult = con.prepareTupleQuery(QueryLanguage.SERQL, query).evaluate();
        while (queryResult.hasNext()) {
            bindingSet = (BindingSet)queryResult.next();
            testURI = bindingSet.getValue("testURI").toString();
            inputURL = bindingSet.getValue("inputURL").toString();
            String outputURL = bindingSet.getValue("outputURL").toString();
            suite.addTest((Test)new PositiveParserTest(testURI, inputURL, outputURL));
        }
        queryResult.close();
        query = "SELECT testURI, inputURL FROM {testURI} rdf:type {n3test:NegativeParserTest};                n3test:inputDocument {inputURL} USING NAMESPACE n3test = <http://www.w3.org/2004/11/n3test#>";
        queryResult = con.prepareTupleQuery(QueryLanguage.SERQL, query).evaluate();
        while (queryResult.hasNext()) {
            bindingSet = (BindingSet)queryResult.next();
            testURI = bindingSet.getValue("testURI").toString();
            inputURL = bindingSet.getValue("inputURL").toString();
            suite.addTest((Test)new NegativeParserTest(testURI, inputURL));
        }
        queryResult.close();
        con.close();
        repository.shutDown();
        return suite;
    }

    protected abstract RDFParser createRDFParser();

    private static URL url(String uri) throws MalformedURLException {
        return new URL(uri);
    }

    private static String base(String uri) {
        return uri;
    }

    private class NegativeParserTest
    extends TestCase {
        private URL inputURL;

        public NegativeParserTest(String testURI, String inputURL) throws MalformedURLException {
            super(testURI);
            this.inputURL = N3ParserTestCase.url(inputURL);
        }

        protected void runTest() {
            try {
                RDFParser turtleParser = N3ParserTestCase.this.createRDFParser();
                turtleParser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
                turtleParser.setRDFHandler((RDFHandler)new StatementCollector());
                InputStream in = this.inputURL.openStream();
                turtleParser.parse(in, N3ParserTestCase.base(this.inputURL.toExternalForm()));
                in.close();
                NegativeParserTest.fail((String)"Parser parses erroneous data without reporting errors");
            }
            catch (RDFParseException turtleParser) {
            }
            catch (Exception e) {
                NegativeParserTest.fail((String)("Error: " + e.getMessage()));
            }
        }
    }

    private class PositiveParserTest
    extends TestCase {
        private URL inputURL;
        private URL outputURL;

        public PositiveParserTest(String testURI, String inputURL, String outputURL) throws MalformedURLException {
            super(testURI);
            this.inputURL = N3ParserTestCase.url(inputURL);
            this.outputURL = N3ParserTestCase.url(outputURL);
        }

        protected void runTest() throws Exception {
            RDFParser turtleParser = N3ParserTestCase.this.createRDFParser();
            turtleParser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
            LinkedHashSet inputCollection = new LinkedHashSet();
            StatementCollector inputCollector = new StatementCollector(inputCollection);
            turtleParser.setRDFHandler((RDFHandler)inputCollector);
            InputStream in = this.inputURL.openStream();
            turtleParser.parse(in, N3ParserTestCase.base(this.inputURL.toExternalForm()));
            in.close();
            NTriplesParser ntriplesParser = new NTriplesParser();
            ntriplesParser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
            LinkedHashSet outputCollection = new LinkedHashSet();
            StatementCollector outputCollector = new StatementCollector(outputCollection);
            ntriplesParser.setRDFHandler((RDFHandler)outputCollector);
            in = this.outputURL.openStream();
            ntriplesParser.parse(in, N3ParserTestCase.base(this.outputURL.toExternalForm()));
            in.close();
            if (!Models.isomorphic(inputCollection, outputCollection)) {
                System.err.println("===models not equal===");
                LinkedList missing = new LinkedList(outputCollection);
                missing.removeAll(inputCollection);
                LinkedList unexpected = new LinkedList(inputCollection);
                unexpected.removeAll(outputCollection);
                if (!missing.isEmpty()) {
                    System.err.println("Missing   : " + missing);
                }
                if (!unexpected.isEmpty()) {
                    System.err.println("Unexpected: " + unexpected);
                }
                PositiveParserTest.fail((String)"models not equal");
            }
        }
    }
}

