/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.nquads;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.rio.ParseLocationListener;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFHandler;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.rio.helpers.NTriplesParserSettings;
import org.eclipse.rdf4j.rio.helpers.SimpleParseLocationListener;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractNQuadsParserUnitTest {
    private static String NQUADS_TEST_URL = "http://www.w3.org/2000/10/rdf-tests/rdfcore/ntriples/test.nt";
    private static String NQUADS_TEST_FILE = "/testcases/nquads/test1.nq";
    private static String NTRIPLES_TEST_URL = "http://www.w3.org/2000/10/rdf-tests/rdfcore/ntriples/test.nt";
    private static String NTRIPLES_TEST_FILE = "/testcases/ntriples/test.nt";
    private RDFParser parser;
    private TestRDFHandler rdfHandler;

    @Before
    public void setUp() throws Exception {
        this.parser = this.createRDFParser();
        this.rdfHandler = new TestRDFHandler();
        this.parser.setRDFHandler((RDFHandler)this.rdfHandler);
    }

    @After
    public void tearDown() throws Exception {
        this.parser = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNQuadsFile() throws Exception {
        RDFParser nquadsParser = this.createRDFParser();
        nquadsParser.setRDFHandler((RDFHandler)new AbstractRDFHandler(){});
        try (InputStream in = AbstractNQuadsParserUnitTest.class.getResourceAsStream(NQUADS_TEST_FILE);){
            nquadsParser.parse(in, NQUADS_TEST_URL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNTriplesFile() throws Exception {
        RDFParser nquadsParser = this.createRDFParser();
        nquadsParser.setRDFHandler((RDFHandler)new AbstractRDFHandler(){});
        try (InputStream in = AbstractNQuadsParserUnitTest.class.getResourceAsStream(NTRIPLES_TEST_FILE);){
            nquadsParser.parse(in, NTRIPLES_TEST_URL);
        }
    }

    @Test
    public void testIncompleteParsingWithoutPeriod() throws RDFHandlerException, IOException, RDFParseException {
        ByteArrayInputStream bais = new ByteArrayInputStream("<http://s> <http://p> <http://o> <http://g>".getBytes());
        try {
            this.parser.parse((InputStream)bais, "http://test.base.uri");
            Assert.fail((String)"Expected exception when not inserting a trailing period at the end of a statement.");
        }
        catch (RDFParseException rDFParseException) {
            // empty catch block
        }
    }

    @Test
    public void testNonWhitespaceAfterPeriodNoContext() throws RDFHandlerException, IOException, RDFParseException {
        ByteArrayInputStream bais = new ByteArrayInputStream("<http://www.wrong.com> <http://wrong.com/1.1/tt> \"x\"^^<http://xxx.net/int> . <http://path.to.graph> ".getBytes());
        try {
            this.parser.parse((InputStream)bais, "http://base-uri");
            Assert.fail((String)"Expected exception when there is non-whitespace characters after a period.");
        }
        catch (RDFParseException rdfpe) {
            Assert.assertEquals((long)1L, (long)rdfpe.getLineNumber());
        }
    }

    @Test
    public void testNonWhitespaceAfterPeriodWithContext() throws RDFHandlerException, IOException, RDFParseException {
        ByteArrayInputStream bais = new ByteArrayInputStream("<http://www.wrong.com> <http://wrong.com/1.1/tt> \"x\"^^<http://xxx.net/int> <http://path.to.graph> . <thisisnotlegal> ".getBytes());
        try {
            this.parser.parse((InputStream)bais, "http://base-uri");
            Assert.fail((String)"Expected exception when there is non-whitespace characters after a period.");
        }
        catch (RDFParseException rdfpe) {
            Assert.assertEquals((long)1L, (long)rdfpe.getLineNumber());
        }
    }

    @Test
    public void testParseNoContext() throws RDFHandlerException, IOException, RDFParseException {
        ByteArrayInputStream bais = new ByteArrayInputStream("<http://s> <http://p> <http://o> .".getBytes());
        this.parser.parse((InputStream)bais, "http://base-uri");
    }

    @Test
    public void testParseEmptyLinesAndComments() throws RDFHandlerException, IOException, RDFParseException {
        ByteArrayInputStream bais = new ByteArrayInputStream("  \n\n\n# This is a comment\n\n#this is another comment.".getBytes());
        TestRDFHandler rdfHandler = new TestRDFHandler();
        this.parser.setRDFHandler((RDFHandler)rdfHandler);
        this.parser.parse((InputStream)bais, "http://test.base.uri");
        Assert.assertEquals((long)rdfHandler.getStatements().size(), (long)0L);
    }

    @Test
    public void testParseBasic() throws RDFHandlerException, IOException, RDFParseException {
        ByteArrayInputStream bais = new ByteArrayInputStream("<http://www.v/dat/4b> <http://www.w3.org/20/ica#dtend> <http://sin/value/2> <http://sin.siteserv.org/def/> .".getBytes());
        TestRDFHandler rdfHandler = new TestRDFHandler();
        this.parser.setRDFHandler((RDFHandler)rdfHandler);
        this.parser.parse((InputStream)bais, "http://test.base.uri");
        Assertions.assertThat((Iterable)rdfHandler.getStatements()).hasSize(1);
        Statement statement = (Statement)rdfHandler.getStatements().iterator().next();
        Assert.assertEquals((Object)"http://www.v/dat/4b", (Object)statement.getSubject().stringValue());
        Assert.assertEquals((Object)"http://www.w3.org/20/ica#dtend", (Object)statement.getPredicate().stringValue());
        Assert.assertTrue((boolean)(statement.getObject() instanceof IRI));
        Assert.assertEquals((Object)"http://sin/value/2", (Object)statement.getObject().stringValue());
        Assert.assertEquals((Object)"http://sin.siteserv.org/def/", (Object)statement.getContext().stringValue());
    }

    @Test
    public void testParseBasicBNode() throws RDFHandlerException, IOException, RDFParseException {
        ByteArrayInputStream bais = new ByteArrayInputStream("_:a123456768 <http://www.w3.org/20/ica#dtend> <http://sin/value/2> <http://sin.siteserv.org/def/>.".getBytes());
        TestRDFHandler rdfHandler = new TestRDFHandler();
        this.parser.setRDFHandler((RDFHandler)rdfHandler);
        this.parser.parse((InputStream)bais, "http://test.base.uri");
        Assertions.assertThat((Iterable)rdfHandler.getStatements()).hasSize(1);
        Statement statement = (Statement)rdfHandler.getStatements().iterator().next();
        Assert.assertTrue((boolean)(statement.getSubject() instanceof BNode));
        Assert.assertEquals((Object)"http://www.w3.org/20/ica#dtend", (Object)statement.getPredicate().stringValue());
        Assert.assertTrue((boolean)(statement.getObject() instanceof IRI));
        Assert.assertEquals((Object)"http://sin/value/2", (Object)statement.getObject().stringValue());
        Assert.assertEquals((Object)"http://sin.siteserv.org/def/", (Object)statement.getContext().stringValue());
    }

    @Test
    public void testParseBasicLiteral() throws RDFHandlerException, IOException, RDFParseException {
        ByteArrayInputStream bais = new ByteArrayInputStream("_:a123456768 <http://www.w3.org/20/ica#dtend> \"2010-05-02\" <http://sin.siteserv.org/def/>.".getBytes());
        TestRDFHandler rdfHandler = new TestRDFHandler();
        this.parser.setRDFHandler((RDFHandler)rdfHandler);
        this.parser.parse((InputStream)bais, "http://test.base.uri");
        Assertions.assertThat((Iterable)rdfHandler.getStatements()).hasSize(1);
        Statement statement = (Statement)rdfHandler.getStatements().iterator().next();
        Assert.assertTrue((boolean)(statement.getSubject() instanceof BNode));
        Assert.assertEquals((Object)"http://www.w3.org/20/ica#dtend", (Object)statement.getPredicate().stringValue());
        Assert.assertTrue((boolean)(statement.getObject() instanceof Literal));
        Assert.assertEquals((Object)"2010-05-02", (Object)statement.getObject().stringValue());
        Assert.assertEquals((Object)"http://sin.siteserv.org/def/", (Object)statement.getContext().stringValue());
    }

    @Test
    public void testParseBasicLiteralLang() throws RDFHandlerException, IOException, RDFParseException {
        ByteArrayInputStream bais = new ByteArrayInputStream("<http://www.v/dat/4b2-21> <http://www.w3.org/20/ica#dtend> \"2010-05-02\"@en <http://sin.siteserv.org/def/>.".getBytes());
        TestRDFHandler rdfHandler = new TestRDFHandler();
        this.parser.setRDFHandler((RDFHandler)rdfHandler);
        this.parser.parse((InputStream)bais, "http://test.base.uri");
        Statement statement = (Statement)rdfHandler.getStatements().iterator().next();
        Assert.assertEquals((Object)"http://www.v/dat/4b2-21", (Object)statement.getSubject().stringValue());
        Assert.assertEquals((Object)"http://www.w3.org/20/ica#dtend", (Object)statement.getPredicate().stringValue());
        Assert.assertTrue((boolean)(statement.getObject() instanceof Literal));
        Literal object = (Literal)statement.getObject();
        Assert.assertEquals((Object)"2010-05-02", (Object)object.stringValue());
        Assert.assertEquals((Object)"en", object.getLanguage().orElse(null));
        Assert.assertEquals((Object)RDF.LANGSTRING, (Object)object.getDatatype());
        Assert.assertEquals((Object)"http://sin.siteserv.org/def/", (Object)statement.getContext().stringValue());
    }

    @Test
    public void testParseBasicLiteralDatatype() throws RDFHandlerException, IOException, RDFParseException {
        ByteArrayInputStream bais = new ByteArrayInputStream("<http://www.v/dat/4b2-21> <http://www.w3.org/20/ica#dtend> \"2010\"^^<http://www.w3.org/2001/XMLSchema#integer> <http://sin.siteserv.org/def/>.".getBytes());
        TestRDFHandler rdfHandler = new TestRDFHandler();
        this.parser.setRDFHandler((RDFHandler)rdfHandler);
        this.parser.parse((InputStream)bais, "http://test.base.uri");
        Statement statement = (Statement)rdfHandler.getStatements().iterator().next();
        Assert.assertEquals((Object)"http://www.v/dat/4b2-21", (Object)statement.getSubject().stringValue());
        Assert.assertEquals((Object)"http://www.w3.org/20/ica#dtend", (Object)statement.getPredicate().stringValue());
        Assert.assertTrue((boolean)(statement.getObject() instanceof Literal));
        Literal object = (Literal)statement.getObject();
        Assert.assertEquals((Object)"2010", (Object)object.stringValue());
        Assert.assertFalse((boolean)object.getLanguage().isPresent());
        Assert.assertEquals((Object)"http://www.w3.org/2001/XMLSchema#integer", (Object)object.getDatatype().toString());
        Assert.assertEquals((Object)"http://sin.siteserv.org/def/", (Object)statement.getContext().stringValue());
    }

    @Test
    public void testParseBasicLiteralDatatypePrefix() throws RDFHandlerException, IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream("<http://www.v/dat/4b2-21> <http://www.w3.org/20/ica#dtend> \"2010\"^^xsd:integer <http://sin.siteserv.org/def/>.".getBytes());
        TestRDFHandler rdfHandler = new TestRDFHandler();
        this.parser.setRDFHandler((RDFHandler)rdfHandler);
        try {
            this.parser.parse((InputStream)bais, "http://test.base.uri");
            Assert.fail((String)"Expected exception when passing in a datatype using an N3 style prefix");
        }
        catch (RDFParseException rdfpe) {
            Assert.assertEquals((long)1L, (long)rdfpe.getLineNumber());
        }
    }

    @Test
    public void testLiteralEscapeManagement1() throws RDFHandlerException, IOException, RDFParseException {
        TestParseLocationListener parseLocationListener = new TestParseLocationListener();
        TestRDFHandler rdfHandler = new TestRDFHandler();
        this.parser.setParseLocationListener((ParseLocationListener)parseLocationListener);
        this.parser.setRDFHandler((RDFHandler)rdfHandler);
        ByteArrayInputStream bais = new ByteArrayInputStream("<http://a> <http://b> \"\\\\\" <http://c> .".getBytes());
        this.parser.parse((InputStream)bais, "http://base-uri");
        rdfHandler.assertHandler(1);
        parseLocationListener.assertListener(1, 1);
    }

    @Test
    public void testLiteralEscapeManagement2() throws RDFHandlerException, IOException, RDFParseException {
        TestParseLocationListener parseLocationListener = new TestParseLocationListener();
        TestRDFHandler rdfHandler = new TestRDFHandler();
        this.parser.setParseLocationListener((ParseLocationListener)parseLocationListener);
        this.parser.setRDFHandler((RDFHandler)rdfHandler);
        ByteArrayInputStream bais = new ByteArrayInputStream("<http://a> <http://b> \"Line text 1\\nLine text 2\" <http://c> .".getBytes());
        this.parser.parse((InputStream)bais, "http://base-uri");
        rdfHandler.assertHandler(1);
        Value object = ((Statement)rdfHandler.getStatements().iterator().next()).getObject();
        Assert.assertTrue((boolean)(object instanceof Literal));
        String literalContent = ((Literal)object).getLabel();
        Assert.assertEquals((Object)"Line text 1\nLine text 2", (Object)literalContent);
    }

    @Test
    public void testURIDecodingManagement() throws RDFHandlerException, IOException, RDFParseException {
        TestParseLocationListener parseLocationListener = new TestParseLocationListener();
        TestRDFHandler rdfHandler = new TestRDFHandler();
        this.parser.setParseLocationListener((ParseLocationListener)parseLocationListener);
        this.parser.setRDFHandler((RDFHandler)rdfHandler);
        ByteArrayInputStream bais = new ByteArrayInputStream("<http://s/\\u306F\\u3080> <http://p/\\u306F\\u3080> <http://o/\\u306F\\u3080> <http://g/\\u306F\\u3080> .".getBytes());
        this.parser.parse((InputStream)bais, "http://base-uri");
        rdfHandler.assertHandler(1);
        Statement statement = (Statement)rdfHandler.getStatements().iterator().next();
        Resource subject = statement.getSubject();
        Assert.assertTrue((boolean)(subject instanceof IRI));
        String subjectURI = subject.toString();
        Assert.assertEquals((Object)"http://s/\u306f\u3080", (Object)subjectURI);
        IRI predicate = statement.getPredicate();
        Assert.assertTrue((boolean)(predicate instanceof IRI));
        String predicateURI = predicate.toString();
        Assert.assertEquals((Object)"http://p/\u306f\u3080", (Object)predicateURI);
        Value object = statement.getObject();
        Assert.assertTrue((boolean)(object instanceof IRI));
        String objectURI = object.toString();
        Assert.assertEquals((Object)"http://o/\u306f\u3080", (Object)objectURI);
        Resource graph = statement.getContext();
        Assert.assertTrue((boolean)(graph instanceof IRI));
        String graphURI = graph.toString();
        Assert.assertEquals((Object)"http://g/\u306f\u3080", (Object)graphURI);
    }

    @Test
    public void testUnicodeLiteralDecoding() throws RDFHandlerException, IOException, RDFParseException {
        TestRDFHandler rdfHandler = new TestRDFHandler();
        this.parser.setRDFHandler((RDFHandler)rdfHandler);
        String INPUT_LITERAL_PLAIN = "[\u306f]";
        String INPUT_LITERAL_ENCODED = "[\\u306F]";
        String INPUT_STRING = String.format("<http://a> <http://b> \"%s\" <http://c> .", "[\\u306F]");
        ByteArrayInputStream bais = new ByteArrayInputStream(INPUT_STRING.getBytes());
        this.parser.parse((InputStream)bais, "http://base-uri");
        rdfHandler.assertHandler(1);
        Literal obj = (Literal)((Statement)rdfHandler.getStatements().iterator().next()).getObject();
        Assert.assertEquals((Object)"[\u306f]", (Object)obj.getLabel());
    }

    @Test
    public void testWrongUnicodeEncodedCharFail() throws RDFHandlerException, IOException, RDFParseException {
        ByteArrayInputStream bais = new ByteArrayInputStream("<http://s> <http://p> \"\\u123X\" <http://g> .".getBytes());
        try {
            this.parser.parse((InputStream)bais, "http://test.base.uri");
            Assert.fail((String)"Expected exception when an incorrect unicode character is included");
        }
        catch (RDFParseException rdfpe) {
            Assert.assertEquals((long)1L, (long)rdfpe.getLineNumber());
        }
    }

    @Test
    public void testEndOfStreamReached() throws RDFHandlerException, IOException, RDFParseException {
        ByteArrayInputStream bais = new ByteArrayInputStream("<http://a> <http://b> \"\\\" <http://c> .".getBytes());
        try {
            this.parser.parse((InputStream)bais, "http://test.base.uri");
            Assert.fail((String)"Expected exception when a literal is not closed");
        }
        catch (RDFParseException rDFParseException) {
            // empty catch block
        }
    }

    @Test
    public void testParserWithAllCases() throws IOException, RDFParseException, RDFHandlerException {
        TestParseLocationListener parseLocationListerner = new TestParseLocationListener();
        this.parser.setParseLocationListener((ParseLocationListener)parseLocationListerner);
        this.parser.setRDFHandler((RDFHandler)this.rdfHandler);
        BufferedReader br = new BufferedReader(new InputStreamReader(AbstractNQuadsParserUnitTest.class.getResourceAsStream("/testcases/nquads/test1.nq")));
        this.parser.parse((Reader)br, "http://test.base.uri");
        this.rdfHandler.assertHandler(6);
        parseLocationListerner.assertListener(9, 1);
    }

    @Test
    public void testParserWithRealData() throws IOException, RDFParseException, RDFHandlerException {
        TestParseLocationListener parseLocationListener = new TestParseLocationListener();
        TestRDFHandler rdfHandler = new TestRDFHandler();
        this.parser.setParseLocationListener((ParseLocationListener)parseLocationListener);
        this.parser.setRDFHandler((RDFHandler)rdfHandler);
        this.parser.parse(AbstractNQuadsParserUnitTest.class.getResourceAsStream("/testcases/nquads/test2.nq"), "http://test.base.uri");
        rdfHandler.assertHandler(400);
        parseLocationListener.assertListener(401, 1);
    }

    @Test
    public void testStatementWithInvalidLiteralContentAndIgnoreValidation() throws RDFHandlerException, IOException, RDFParseException {
        ByteArrayInputStream bais = new ByteArrayInputStream("<http://dbpedia.org/resource/Camillo_Benso,_conte_di_Cavour> <http://dbpedia.org/property/mandatofine> \"1380.0\"^^<http://www.w3.org/2001/XMLSchema#int> <http://it.wikipedia.org/wiki/Camillo_Benso,_conte_di_Cavour#absolute-line=20> .".getBytes());
        this.parser.getParserConfig().set(BasicParserSettings.VERIFY_DATATYPE_VALUES, (Object)false);
        this.parser.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (Object)false);
        this.parser.parse((InputStream)bais, "http://base-uri");
    }

    @Test
    public void testStatementWithInvalidLiteralContentAndStrictValidation() throws RDFHandlerException, IOException, RDFParseException {
        ByteArrayInputStream bais = new ByteArrayInputStream("<http://dbpedia.org/resource/Camillo_Benso,_conte_di_Cavour> <http://dbpedia.org/property/mandatofine> \"1380.0\"^^<http://www.w3.org/2001/XMLSchema#int> <http://it.wikipedia.org/wiki/Camillo_Benso,_conte_di_Cavour#absolute-line=20> .".getBytes());
        this.parser.getParserConfig().set(BasicParserSettings.VERIFY_DATATYPE_VALUES, (Object)true);
        this.parser.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (Object)true);
        try {
            this.parser.parse((InputStream)bais, "http://test.base.uri");
            Assert.fail((String)"Expected exception when passing in a datatype using an N3 style prefix");
        }
        catch (RDFParseException rDFParseException) {
            // empty catch block
        }
    }

    @Test
    public void testStatementWithInvalidDatatypeAndIgnoreValidation() throws RDFHandlerException, IOException, RDFParseException {
        this.verifyStatementWithInvalidDatatype(false);
    }

    @Test
    public void testStatementWithInvalidDatatypeAndVerifyValidation() throws RDFHandlerException, IOException, RDFParseException {
        try {
            this.verifyStatementWithInvalidDatatype(true);
            Assert.fail((String)"Did not find expected exception");
        }
        catch (RDFParseException rDFParseException) {
            // empty catch block
        }
    }

    @Test
    public void testStopAtFirstErrorStrictParsing() throws RDFHandlerException, IOException, RDFParseException {
        ByteArrayInputStream bais = new ByteArrayInputStream("<http://s0> <http://p0> <http://o0> <http://g0> .\n<http://sX>                                     .\n<http://s1> <http://p1> <http://o1> <http://g1> .\n".getBytes());
        this.parser.getParserConfig().set(NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES, (Object)false);
        try {
            this.parser.parse((InputStream)bais, "http://test.base.uri");
            Assert.fail((String)"Expected exception when encountering an invalid line");
        }
        catch (RDFParseException rdfpe) {
            Assert.assertEquals((long)2L, (long)rdfpe.getLineNumber());
        }
    }

    @Test
    public void testStopAtFirstErrorTolerantParsing() throws RDFHandlerException, IOException, RDFParseException {
        ByteArrayInputStream bais = new ByteArrayInputStream("<http://s0> <http://p0> <http://o0> <http://g0> .\n<http://sX>                                     .\n<http://s1> <http://p1> <http://o1> <http://g1> .\n".getBytes());
        TestRDFHandler rdfHandler = new TestRDFHandler();
        this.parser.setRDFHandler((RDFHandler)rdfHandler);
        this.parser.getParserConfig().set(NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES, (Object)false);
        this.parser.getParserConfig().addNonFatalError(NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES);
        this.parser.parse((InputStream)bais, "http://base-uri");
        rdfHandler.assertHandler(2);
        Collection statements = rdfHandler.getStatements();
        int i = 0;
        for (Statement nextStatement : statements) {
            Assert.assertEquals((Object)("http://s" + i), (Object)nextStatement.getSubject().stringValue());
            Assert.assertEquals((Object)("http://p" + i), (Object)nextStatement.getPredicate().stringValue());
            Assert.assertEquals((Object)("http://o" + i), (Object)nextStatement.getObject().stringValue());
            Assert.assertEquals((Object)("http://g" + i), (Object)nextStatement.getContext().stringValue());
            ++i;
        }
    }

    private void verifyStatementWithInvalidDatatype(boolean useDatatypeVerification) throws RDFHandlerException, IOException, RDFParseException {
        TestRDFHandler rdfHandler = new TestRDFHandler();
        this.parser.setRDFHandler((RDFHandler)rdfHandler);
        this.parser.getParserConfig().set(BasicParserSettings.VERIFY_DATATYPE_VALUES, (Object)useDatatypeVerification);
        this.parser.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (Object)useDatatypeVerification);
        if (!useDatatypeVerification) {
            this.parser.getParserConfig().addNonFatalError(BasicParserSettings.VERIFY_DATATYPE_VALUES);
            this.parser.getParserConfig().addNonFatalError(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream("<http://dbpedia.org/resource/Camillo_Benso,_conte_di_Cavour> <http://dbpedia.org/property/mandatofine> \"1380.0\"^^<http://dbpedia.org/invalid/datatype/second> <http://it.wikipedia.org/wiki/Camillo_Benso,_conte_di_Cavour#absolute-line=20> .".getBytes());
        this.parser.parse((InputStream)bais, "http://base-uri");
        rdfHandler.assertHandler(1);
    }

    @Test
    public void testSupportedSettings() throws Exception {
        Assertions.assertThat((Iterable)this.parser.getSupportedSettings()).hasSize(13);
    }

    protected abstract RDFParser createRDFParser();

    private class TestRDFHandler
    extends StatementCollector {
        private boolean started = false;
        private boolean ended = false;

        private TestRDFHandler() {
        }

        public void startRDF() throws RDFHandlerException {
            super.startRDF();
            this.started = true;
        }

        public void endRDF() throws RDFHandlerException {
            super.endRDF();
            this.ended = true;
        }

        public void assertHandler(int expected) {
            Assert.assertTrue((String)"Never started.", (boolean)this.started);
            Assert.assertTrue((String)"Never ended.", (boolean)this.ended);
            Assert.assertEquals((String)"Unexpected number of statements.", (long)expected, (long)this.getStatements().size());
        }
    }

    private class TestParseLocationListener
    extends SimpleParseLocationListener {
        private TestParseLocationListener() {
        }

        private void assertListener(int row, int col) {
            Assert.assertEquals((String)"Unexpected last row", (long)row, (long)this.getLineNo());
            Assert.assertEquals((String)"Unexpected last col", (long)col, (long)this.getColumnNo());
        }
    }
}

