/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.datatypes;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.util.LiteralUtilException;
import org.eclipse.rdf4j.rio.DatatypeHandler;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public abstract class AbstractDatatypeHandlerTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private DatatypeHandler testHandler;
    private ValueFactory vf;

    protected abstract DatatypeHandler getNewDatatypeHandler();

    protected abstract IRI getRecognisedDatatypeUri();

    protected abstract IRI getUnrecognisedDatatypeUri();

    protected abstract String getValueMatchingRecognisedDatatypeUri();

    protected abstract String getValueNotMatchingRecognisedDatatypeUri();

    protected abstract Literal getNormalisedLiteralForRecognisedDatatypeAndValue();

    protected abstract ValueFactory getValueFactory();

    protected abstract String getExpectedKey();

    @Before
    public void setUp() throws Exception {
        this.testHandler = this.getNewDatatypeHandler();
        this.vf = this.getValueFactory();
    }

    @After
    public void tearDown() throws Exception {
        this.testHandler = null;
        this.vf = null;
    }

    @Test
    public void testIsRecognizedDatatypeNull() throws Exception {
        this.thrown.expect(NullPointerException.class);
        this.testHandler.isRecognizedDatatype(null);
    }

    @Test
    public void testIsRecognizedDatatypeTrue() throws Exception {
        Assert.assertTrue((boolean)this.testHandler.isRecognizedDatatype(this.getRecognisedDatatypeUri()));
    }

    @Test
    public void testIsRecognizedDatatypeFalse() throws Exception {
        Assert.assertFalse((boolean)this.testHandler.isRecognizedDatatype(this.getUnrecognisedDatatypeUri()));
    }

    @Test
    public void testVerifyDatatypeNullDatatypeUri() throws Exception {
        this.thrown.expect(NullPointerException.class);
        this.testHandler.verifyDatatype(this.getValueMatchingRecognisedDatatypeUri(), null);
    }

    @Test
    public void testVerifyDatatypeNullValueRecognised() throws Exception {
        this.thrown.expect(NullPointerException.class);
        this.testHandler.verifyDatatype(null, this.getRecognisedDatatypeUri());
    }

    @Test
    public void testVerifyDatatypeNullValueUnrecognised() throws Exception {
        this.thrown.expect(LiteralUtilException.class);
        this.testHandler.verifyDatatype(null, this.getUnrecognisedDatatypeUri());
    }

    @Test
    public void testVerifyDatatypeUnrecognisedDatatypeUri() throws Exception {
        this.thrown.expect(LiteralUtilException.class);
        this.testHandler.verifyDatatype(this.getValueMatchingRecognisedDatatypeUri(), this.getUnrecognisedDatatypeUri());
    }

    @Test
    public void testVerifyDatatypeInvalidValue() throws Exception {
        Assert.assertFalse((boolean)this.testHandler.verifyDatatype(this.getValueNotMatchingRecognisedDatatypeUri(), this.getRecognisedDatatypeUri()));
    }

    @Test
    public void testVerifyDatatypeValidValue() throws Exception {
        Assert.assertTrue((boolean)this.testHandler.verifyDatatype(this.getValueMatchingRecognisedDatatypeUri(), this.getRecognisedDatatypeUri()));
    }

    @Test
    public void testNormalizeDatatypeNullDatatypeUri() throws Exception {
        this.thrown.expect(NullPointerException.class);
        this.testHandler.normalizeDatatype(this.getValueMatchingRecognisedDatatypeUri(), null, this.vf);
    }

    @Test
    public void testNormalizeDatatypeNullValue() throws Exception {
        this.thrown.expect(NullPointerException.class);
        this.testHandler.normalizeDatatype(null, this.getRecognisedDatatypeUri(), this.vf);
    }

    @Test
    public void testNormalizeDatatypeUnrecognisedDatatypeUri() throws Exception {
        this.thrown.expect(LiteralUtilException.class);
        this.testHandler.normalizeDatatype(this.getValueMatchingRecognisedDatatypeUri(), this.getUnrecognisedDatatypeUri(), this.vf);
    }

    @Test
    public void testNormalizeDatatypeInvalidValue() throws Exception {
        this.thrown.expect(LiteralUtilException.class);
        this.testHandler.normalizeDatatype(this.getValueNotMatchingRecognisedDatatypeUri(), this.getRecognisedDatatypeUri(), this.vf);
    }

    @Test
    public void testNormalizeDatatypeValidValue() throws Exception {
        Literal result = this.testHandler.normalizeDatatype(this.getValueMatchingRecognisedDatatypeUri(), this.getRecognisedDatatypeUri(), this.vf);
        Literal expectedResult = this.getNormalisedLiteralForRecognisedDatatypeAndValue();
        Assert.assertNotNull((Object)expectedResult.getDatatype());
        Assert.assertNotNull((Object)expectedResult.getLabel());
        Assert.assertFalse((boolean)expectedResult.getLanguage().isPresent());
        Assert.assertEquals((Object)expectedResult.getDatatype(), (Object)result.getDatatype());
        Assert.assertEquals((Object)expectedResult.getLabel(), (Object)result.getLabel());
        Assert.assertEquals((Object)expectedResult.getLanguage(), (Object)result.getLanguage());
    }

    @Test
    public void testGetKey() throws Exception {
        String result = this.testHandler.getKey();
        String expectedResult = this.getExpectedKey();
        Assert.assertEquals((Object)expectedResult, (Object)result);
    }
}

